/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

public final class MonitorBlock {
    private LocalCounter read = new LocalCounter();
    private LocalCounter write = new LocalCounter();
    private int access = 0;
    private int wannaBeChangers = 0;
    private boolean change = false;

    public synchronized void tryToChange() {
        Counter w = (Counter)this.write.get();
        int wCount = w.get();
        int rCount = ((Counter)this.read.get()).get();
        boolean effectiveChange = this.change && wCount == 0;
        int effectiveAccess = this.access - rCount;
        ++this.wannaBeChangers;
        while (effectiveAccess > 0 || effectiveChange) {
            try {
                this.access -= rCount;
                this.wait();
                this.access += rCount;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            effectiveChange = this.change && wCount == 0;
            effectiveAccess = this.access - rCount;
        }
        this.change = true;
        --this.wannaBeChangers;
        w.increase();
    }

    public synchronized void endChange() {
        this.change = ((Counter)this.write.get()).decrease() > 0;
        this.notifyAll();
    }

    public synchronized void tryToAccess() {
        Counter r = (Counter)this.read.get();
        int wCount = ((Counter)this.write.get()).get();
        int rCount = r.get();
        boolean effectiveChange = (this.change || this.wannaBeChangers > 0) && wCount == 0;
        while (effectiveChange) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            boolean bl = effectiveChange = (this.change || this.wannaBeChangers > 0) && wCount == 0;
        }
        ++this.access;
        r.increase();
    }

    public synchronized void endAccess() {
        --this.access;
        ((Counter)this.read.get()).decrease();
        this.notifyAll();
    }

    private class Counter {
        private int count = 0;

        Counter() {
        }

        Counter(int initialCount) {
            this.count = initialCount;
        }

        int increase() {
            return ++this.count;
        }

        int decrease() {
            if (--this.count < 0) {
                this.count = 0;
            }
            return this.count;
        }

        int get() {
            return this.count;
        }
    }

    private class LocalCounter
    extends ThreadLocal {
        private LocalCounter() {
        }

        protected Object initialValue() {
            return new Counter(0);
        }
    }
}

