/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DynamicClassLoader
extends ClassLoader {
    private String classPath;
    private ClassLoader parent;

    public DynamicClassLoader(String classPath) {
        this(classPath, null);
    }

    public DynamicClassLoader(String classPath, ClassLoader parent) {
        this.classPath = classPath;
        this.parent = parent;
        if (this.parent == null) {
            this.parent = this.getClass().getClassLoader();
        }
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            byte[] arr = this.readFileFromClassPath(name, false);
            return new ByteArrayInputStream(arr);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> res = null;
        res = this.findLoadedClass(name);
        if (res == null) {
            try {
                res = this.parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                byte[] classData = null;
                try {
                    classData = this.readFileFromClassPath(name, true);
                }
                catch (Exception ioEx) {
                    throw new ClassNotFoundException(name);
                }
                if (classData != null) {
                    res = this.defineClass(name, classData, 0, classData.length);
                }
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(res);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readFileFromClassPath(String name, boolean isClass) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        StringTokenizer token = new StringTokenizer(this.classPath, File.pathSeparator);
        while (token.hasMoreTokens()) {
            File f = new File(token.nextToken());
            if (!f.exists()) continue;
            if (!f.isDirectory()) {
                Object var12_12;
                ZipFile zip;
                block15: {
                    byte[] byArray;
                    zip = null;
                    try {
                        try {
                            zip = new ZipFile(f);
                            ZipEntry zipEntry = null;
                            zipEntry = isClass ? zip.getEntry(name.replace('.', '/') + ".class") : zip.getEntry(name);
                            if (zipEntry == null) break block15;
                            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(zipEntry));
                            try {
                                int c;
                                while ((c = ((InputStream)is).read()) != -1) {
                                    void var9_14;
                                    buff.write((int)var9_14);
                                }
                            }
                            catch (EOFException e) {
                                // empty catch block
                            }
                            buff.close();
                            ((InputStream)is).close();
                            byArray = buff.toByteArray();
                            var12_12 = null;
                            if (zip == null) return byArray;
                        }
                        catch (IOException e) {
                            var12_12 = null;
                            if (zip == null) continue;
                            zip.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var12_12 = null;
                        if (zip != null) {
                            zip.close();
                        }
                        throw throwable;
                    }
                    zip.close();
                    return byArray;
                }
                var12_12 = null;
                if (zip == null) continue;
                zip.close();
                continue;
            }
            try {
                BufferedInputStream is = null;
                is = isClass ? new BufferedInputStream(new FileInputStream(new File(f, name.replace('.', File.separatorChar) + ".class"))) : new BufferedInputStream(new FileInputStream(new File(name)));
                while (true) {
                    void e;
                    int c;
                    if ((c = ((InputStream)is).read()) == -1) {
                        buff.close();
                        ((InputStream)is).close();
                        return buff.toByteArray();
                    }
                    buff.write((int)e);
                }
            }
            catch (IOException e) {
                // empty catch block
                continue;
            }
            break;
        }
        return null;
    }

    public void setClasspath(String classpath) {
        this.classPath = classpath;
    }

    public String getClasspath() {
        return this.classPath;
    }

    public void addClasspath(String classpath) {
        if (classpath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        String token = null;
        if (!this.classPath.endsWith(File.pathSeparator)) {
            this.classPath = this.classPath + File.pathSeparator;
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (this.classPath.indexOf(token) != -1) continue;
            this.classPath = this.classPath + token + File.pathSeparator;
        }
    }
}

