/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.xmi.ReferencesCounter;
import com.sap.ip.mmr.xmi.UnresolvedReference;
import com.sap.ip.mmr.xmi.XmiContent;
import com.sap.ip.mmr.xmi.XmiContext;
import com.sap.ip.mmr.xmi.XmiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.model.AliasType;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import org.xml.sax.Attributes;

public class XmiStructureValue
extends XmiElement
implements ReferencesCounter {
    private StructureType type;
    private List fields;
    private Iterator fieldsIterator;
    private StructureField currentField;
    private Map fieldsValues = new HashMap();
    private boolean oldFormat;
    private int counter = 0;
    private boolean endReached = false;
    private UnresolvedReference unresRef = null;

    public XmiStructureValue(XmiElement parent, XmiContext context, StructureType type, Attributes attrs, boolean oldFormat) {
        super(parent, context);
        this.type = type;
        this.oldFormat = oldFormat;
        int attrsLength = attrs.getLength();
        this.fields = context.structureFields(type);
        if (oldFormat) {
            this.fieldsIterator = this.fields.iterator();
        } else {
            boolean isMultiplicityType = XmiContext.getQualifiedName((Classifier)type).equals("Model.MultiplicityType");
            for (int index = 0; index < attrsLength; ++index) {
                String fieldName = attrs.getQName(index);
                if (isMultiplicityType) {
                    if (fieldName.equals("is_ordered")) {
                        fieldName = "isOrdered";
                    } else if (fieldName.equals("is_unique")) {
                        fieldName = "isUnique";
                    }
                }
                String fieldValue = attrs.getValue(index);
                this.resolveFieldValue(fieldName, fieldValue);
            }
        }
    }

    public XmiElement startSubElement(String qName, Attributes attrs) {
        if (this.oldFormat) {
            if (!this.fieldsIterator.hasNext()) {
                throw new JmiException("2138", new Object[]{this.type.getName()});
            }
            this.currentField = (StructureField)this.fieldsIterator.next();
        } else {
            this.currentField = (StructureField)this.context.resolveElementName(qName);
        }
        Classifier type = this.currentField.getType();
        return this.context.resolveValue(this, type, attrs);
    }

    public void receiveValue(Object value) {
        if (value instanceof List) {
            if (((List)value).size() != 1) {
                throw new JmiException("2139", new Object[]{this.currentField.getName()});
            }
            value = ((List)value).get(0);
        }
        if (value instanceof UnresolvedReference) {
            ((UnresolvedReference)value).setOwner(this);
        }
        this.setFieldValue((TypedElement)this.currentField, value);
    }

    private void setFieldValue(TypedElement field, Object value) {
        if (this.fieldsValues.get(field) != null) {
            throw new JmiException("2138", new Object[]{this.type.getName()});
        }
        this.fieldsValues.put(field, value);
    }

    private void resolveFieldValue(String fieldName, String fieldValue) {
        StructureField field;
        try {
            field = (StructureField)this.type.lookupElement(fieldName);
        }
        catch (NameNotFoundException e) {
            throw new JmiException("2140", new Object[]{this.type.getName(), fieldName});
        }
        Classifier type = field.getType();
        while (type instanceof AliasType) {
            type = ((AliasType)type).getType();
        }
        Object value = null;
        if (type instanceof PrimitiveType) {
            value = XmiContext.resolvePrimitiveValue((PrimitiveType)type, fieldValue);
        } else if (type instanceof EnumerationType) {
            value = this.context.resolveEnumerationValue((EnumerationType)type, fieldValue);
        } else if (type instanceof MofClass) {
            String xmiId = fieldValue.trim();
            Object obj = this.context.getReference(xmiId);
            if (obj == null) {
                obj = new UnresolvedReference(this);
                this.context.registerUnresolvedRef(xmiId, (UnresolvedReference)obj);
                value = obj;
            }
        } else {
            throw new JmiException("2141", new Object[]{type.getName()});
        }
        this.setFieldValue((TypedElement)field, value);
    }

    private RefStruct createInstance() {
        ArrayList args = new ArrayList();
        Iterator iter = this.fields.iterator();
        while (iter.hasNext()) {
            StructureField field = (StructureField)iter.next();
            Object param = this.fieldsValues.get(field);
            if (param instanceof UnresolvedReference) {
                param = ((UnresolvedReference)param).getValue();
            }
            if (param == null) {
                param = XmiContext.defaultValue(field.getType());
            }
            args.add(param);
        }
        RefStruct struct = null;
        RefBaseObject proxy = this.context.findProxy((ModelElement)this.type);
        if (proxy == null) {
            throw new JmiException("2103", new Object[]{this.type.getName()});
        }
        struct = proxy instanceof RefClass ? ((RefClass)proxy).refCreateStruct((RefObject)this.type, args) : ((RefPackage)proxy).refCreateStruct((RefObject)this.type, args);
        return struct;
    }

    public XmiElement endElement(String qName) {
        this.endReached = true;
        if (this.counter == 0) {
            RefStruct instance = this.createInstance();
            if (!(this.parent instanceof XmiContent)) {
                this.parent.receiveValue(instance);
            }
        } else if (!(this.parent instanceof XmiContent)) {
            this.unresRef = new UnresolvedReference();
            this.parent.receiveValue(this.unresRef);
        }
        if (this.oldFormat) {
            return this.parent.endElement(qName);
        }
        return this.parent;
    }

    public void increaseUnresolvedRefs() {
        ++this.counter;
    }

    public void decreaseUnresolvedRefs() {
        --this.counter;
        if (this.endReached && this.counter == 0) {
            RefStruct instance = this.createInstance();
            if (this.unresRef != null) {
                this.unresRef.referenceResolved(instance);
            }
        }
    }
}

