/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.MMRObject;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.xmi.ReferenceHandler;
import com.sap.ip.mmr.xmi.ReferencesCounter;
import com.sap.ip.mmr.xmi.UnresolvedReference;
import com.sap.ip.mmr.xmi.XmiContent;
import com.sap.ip.mmr.xmi.XmiContext;
import com.sap.ip.mmr.xmi.XmiElement;
import com.sap.ip.mmr.xmi.XmiObjectValues;
import com.sap.ip.mmr.xmi.XmiReferenceValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jmi.model.AliasType;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.MofClass;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.StructuralFeature;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import org.xml.sax.Attributes;

public class XmiInstance
extends XmiElement
implements ReferencesCounter {
    private String name;
    private String xmiId = null;
    private int docId;
    private int unresolvedRefsCounter = 0;
    private boolean endReached = false;
    private UnresolvedReference unresRef = null;
    private StructuralFeature currentFeature;
    private RefClass refClass;
    private MofClass metaClass;
    private Map attributesValues = new HashMap();
    private Map referencesValues = new HashMap();
    private Map attributesSAPValues = new HashMap();

    public XmiInstance(XmiElement parent, XmiContext context, String qName, RefClass refClass, Attributes attrs) {
        super(parent, context);
        this.name = qName;
        this.docId = context.getCurrentDocId();
        this.refClass = refClass;
        this.metaClass = (MofClass)refClass.refMetaObject();
        int attrsLength = attrs.getLength();
        for (int index = 0; index < attrsLength; ++index) {
            String attrName = attrs.getQName(index);
            String attrValue = attrs.getValue(index);
            if (attrName.startsWith("xmi.")) {
                if (!attrName.equals("xmi.id")) continue;
                this.xmiId = attrValue;
                continue;
            }
            this.resolveAttributeValue(attrName, attrValue);
        }
    }

    public RefBaseObject renderTree(RefBaseObject rbo) {
        return rbo;
    }

    public XmiElement startSubElement(String qName, Attributes attrs) {
        Object ref = this.context.resolveElementName(qName);
        if (!(ref instanceof StructuralFeature)) {
            throw new JmiException("2133", new Object[]{qName});
        }
        this.currentFeature = (StructuralFeature)ref;
        if (this.currentFeature instanceof Attribute) {
            Classifier type = this.currentFeature.getType();
            return this.context.resolveValue(this, type, attrs);
        }
        if (this.currentFeature instanceof Reference) {
            XmiObjectValues xmiObjectValues = new XmiObjectValues(this, this.context, null);
            String idRef = attrs.getValue("href");
            if (idRef != null) {
                XmiReferenceValue rv = new XmiReferenceValue(this.context);
                xmiObjectValues.receiveValue(rv.initExternal(this, idRef));
            }
            return xmiObjectValues;
        }
        throw new JmiException("2133", new Object[]{qName});
    }

    private RefObject createInstance() {
        Iterator<Object> iter;
        List attributes = this.context.instanceAttributes(this.refClass);
        List references = this.context.instanceReferences(this.refClass);
        ArrayList args = new ArrayList();
        if (attributes != null) {
            Iterator iter2 = attributes.iterator();
            while (iter2.hasNext()) {
                Attribute attr = (Attribute)iter2.next();
                Object param = this.attributesValues.get(attr);
                if (param instanceof UnresolvedReference) {
                    param = ((UnresolvedReference)param).getValue();
                } else if (param instanceof List) {
                    Iterator iter22 = ((List)param).iterator();
                    ArrayList temp = new ArrayList();
                    while (iter22.hasNext()) {
                        Object value = iter22.next();
                        if (value instanceof UnresolvedReference) {
                            value = ((UnresolvedReference)value).getValue();
                        }
                        temp.add(value);
                    }
                    param = temp;
                }
                if (param == null) {
                    param = XmiContext.defaultValue(attr);
                }
                args.add(param);
            }
        }
        RefObject instance = null;
        try {
            instance = this.refClass.refCreateInstance(args);
        }
        catch (Exception e) {
            instance = null;
        }
        if (instance == null || instance instanceof MMRObject) {
            try {
                instance = this.refClass.refCreateInstance(null);
                if (instance == null) {
                    throw new JmiException("2134", new Object[]{this.refClass.getClass().getName()});
                }
                iter = this.attributesValues.keySet().iterator();
                while (iter.hasNext()) {
                    String attrName = (String)iter.next();
                    Object value = this.attributesValues.get(attrName);
                    instance.refSetValue(attrName, value);
                }
            }
            catch (Exception e1) {
                throw new JmiException("2134", new Object[]{this.refClass.getClass().getName()});
            }
        }
        if (instance.equals(instance.refOutermostComposite())) {
            this.context.addOutermostObject(instance);
        }
        this.addSAPAttributes(instance);
        if (this.xmiId != null) {
            this.context.putReference(this.docId, this.xmiId, instance);
        }
        if (references != null) {
            iter = references.iterator();
            while (iter.hasNext()) {
                Reference ref = (Reference)iter.next();
                List values = (List)this.referencesValues.get(ref);
                if (values == null) continue;
                new ReferenceHandler(ref, instance, values, this.context);
            }
        }
        this.context.countInstance();
        if (this.xmiId != null && this.context.isSAPXmiVersion()) {
            if (instance instanceof ModelElementImpl) {
                ((ModelElementImpl)instance).setMofId(this.xmiId);
            } else if (instance instanceof IMMRObject) {
                ((IMMRObject)instance).set___MofId(this.xmiId);
            }
        }
        return instance;
    }

    protected void addSAPAttributes(RefObject instance) {
        if (this.attributesSAPValues.size() < 1) {
            return;
        }
        if (instance instanceof IModelElement) {
            IModelElement me = (IModelElement)instance;
            me.setCreatedAt((String)this.attributesSAPValues.get("___createdAt"));
            me.setCreatedBy((String)this.attributesSAPValues.get("___createdBy"));
            me.setLastChangedAt((String)this.attributesSAPValues.get("___lastChangedAt"));
            me.setLastChangedBy((String)this.attributesSAPValues.get("___lastChangedBy"));
            me.setRelease((String)this.attributesSAPValues.get("___release"));
            String str = (String)this.attributesSAPValues.get("___deprecated");
            if (str != null) {
                me.setDeprecated(Integer.parseInt(str));
            }
        } else if (instance instanceof IMMRObject) {
            IMMRObject mmro = (IMMRObject)instance;
            mmro.set___CreatedAt((String)this.attributesSAPValues.get("___createdAt"));
            mmro.set___CreatedBy((String)this.attributesSAPValues.get("___createdBy"));
            mmro.set___LastChangedAt((String)this.attributesSAPValues.get("___lastChangedAt"));
            mmro.set___LastChangedBy((String)this.attributesSAPValues.get("___lastChangedBy"));
            mmro.set___Release((String)this.attributesSAPValues.get("___release"));
            String str = (String)this.attributesSAPValues.get("___deprecated");
            if (str != null) {
                mmro.set___Deprecated(Integer.parseInt(str));
            }
        }
    }

    public XmiElement endElement(String qName) {
        this.endReached = true;
        if (this.unresolvedRefsCounter == 0) {
            RefObject instance = this.createInstance();
            if (!(this.parent instanceof XmiContent)) {
                this.parent.receiveValue(instance);
            }
        } else if (!(this.parent instanceof XmiContent)) {
            this.unresRef = new UnresolvedReference();
            this.parent.receiveValue(this.unresRef);
        }
        return this.parent;
    }

    private void setAttributeValue(StructuralFeature attr, Object value) {
        boolean isMultivalued = XmiContext.isMultivalued(attr);
        Object tempValue = this.attributesValues.get(attr);
        if (!isMultivalued) {
            if (tempValue != null) {
                throw new JmiException("2112", new Object[]{attr.getName()});
            }
            this.attributesValues.put(attr, value);
        } else {
            if (tempValue == null) {
                tempValue = new ArrayList();
                this.attributesValues.put(attr, tempValue);
            }
            ((List)tempValue).add(value);
        }
    }

    private void setAttributeValues(StructuralFeature attr, List values) {
        boolean isMultivalued = XmiContext.isMultivalued(attr);
        if (!isMultivalued && values.size() == 1) {
            this.setAttributeValue(attr, values.get(0));
            return;
        }
        if (!isMultivalued) {
            throw new JmiException("2112", new Object[]{attr.getName()});
        }
        Object tempValue = this.attributesValues.get(attr);
        if (tempValue == null) {
            tempValue = new ArrayList();
            this.attributesValues.put(attr, tempValue);
        }
        ((List)tempValue).addAll(values);
    }

    private void setReferenceValues(Reference ref, List values) {
        boolean isMultivalued = XmiContext.isMultivalued((StructuralFeature)ref);
        Object tempValue = this.referencesValues.get(ref);
        if (!isMultivalued) {
            boolean flagThrow = false;
            if (values.size() > 1) {
                flagThrow = true;
            } else if (tempValue != null) {
                flagThrow = true;
                if (values != null && values.size() > 0) {
                    if (tempValue instanceof List) {
                        List l = (List)tempValue;
                        if (l.get(0).equals(values.get(0))) {
                            flagThrow = false;
                        }
                    } else if (tempValue.equals(values.get(0))) {
                        flagThrow = false;
                    }
                }
            }
            if (flagThrow) {
                throw new JmiException("2135", new Object[]{ref, values});
            }
            this.referencesValues.put(ref, values);
            return;
        }
        if (tempValue == null) {
            tempValue = new ArrayList();
            this.referencesValues.put(ref, tempValue);
        }
        ((List)tempValue).addAll(values);
    }

    public void receiveValue(Object value) {
        if (this.currentFeature instanceof Attribute) {
            if (value instanceof List) {
                this.setAttributeValues(this.currentFeature, value);
            } else {
                this.setAttributeValue(this.currentFeature, value);
            }
        } else {
            if (!(value instanceof List)) {
                ArrayList temp = new ArrayList();
                temp.add(value);
                value = temp;
            }
            this.setReferenceValues((Reference)this.currentFeature, value);
        }
    }

    private void resolveAttributeValue(String attrName, String attrValue) {
        StructuralFeature attr = this.context.instanceElementByName(this.refClass, attrName);
        if (attr == null) {
            this.attributesSAPValues.put(attrName, attrValue);
            return;
        }
        Classifier type = attr.getType();
        while (type instanceof AliasType) {
            type = ((AliasType)type).getType();
        }
        Object value = null;
        if (type instanceof PrimitiveType) {
            value = XmiContext.resolvePrimitiveValue((PrimitiveType)type, attrValue);
            this.setAttributeValue(attr, value);
        } else if (type instanceof EnumerationType) {
            value = this.context.resolveEnumerationValue((EnumerationType)type, attrValue);
            this.setAttributeValue(attr, value);
        } else if (type instanceof MofClass) {
            boolean isReference = attr instanceof Reference;
            StringTokenizer tokenizer = new StringTokenizer(attrValue, " ");
            ArrayList<RefObject> list = new ArrayList<RefObject>();
            while (tokenizer.hasMoreTokens()) {
                String xmiId = tokenizer.nextToken();
                Object obj = this.context.getReference(xmiId);
                if (obj == null && (obj = this.context.getReferenceAllDocs(xmiId)) == null) {
                    obj = isReference ? new UnresolvedReference() : new UnresolvedReference(this);
                    this.context.registerUnresolvedRef(xmiId, (UnresolvedReference)obj);
                }
                list.add((RefObject)obj);
            }
            if (isReference) {
                this.setReferenceValues((Reference)attr, list);
            } else {
                this.setAttributeValues(attr, list);
            }
        } else {
            String name = "???";
            if (attr != null) {
                name = attr.getType() != null ? attr.getType().getName() : attr.getName();
            }
            throw new JmiException("2136", new Object[]{name});
        }
    }

    public void increaseUnresolvedRefs() {
        ++this.unresolvedRefsCounter;
    }

    public void decreaseUnresolvedRefs() {
        --this.unresolvedRefsCounter;
        if (this.endReached && this.unresolvedRefsCounter == 0) {
            RefObject instance = this.createInstance();
            if (this.unresRef != null) {
                this.unresRef.referenceResolved(instance);
            }
        }
    }
}

