/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ILocalTransaction;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.tools.XMIImport;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.MofClass;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;

public class DisplayMetadata {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$DisplayMetadata == null ? (class$com$sap$ip$mmr$tools$DisplayMetadata = DisplayMetadata.class$("com.sap.ip.mmr.tools.DisplayMetadata")) : class$com$sap$ip$mmr$tools$DisplayMetadata);
    private IConnection cx;
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$DisplayMetadata;

    public DisplayMetadata(int dbType) {
        ConnectionSpec cxs = new ConnectionSpec();
        cxs.setDbType(dbType);
        ConnectionFactory cxf = new ConnectionFactory();
        try {
            this.cx = cxf.getConnection(cxs);
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    public static void main(String[] args) {
        int dbType = -1;
        String qualifiedNamePackage = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                DisplayMetadata.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            String value = XMIImport.getValue(args[i]);
            if (param == null) {
                DisplayMetadata.writeUsage();
                return;
            }
            if (param.compareToIgnoreCase("package") == 0) {
                qualifiedNamePackage = value;
                continue;
            }
            if (param.compareToIgnoreCase("dbType") != 0) continue;
            dbType = XMIImport.getDBType(value);
        }
        if (qualifiedNamePackage == null) {
            DisplayMetadata.writeUsage();
            return;
        }
        DisplayMetadata dm = new DisplayMetadata(dbType);
        dm.displayPackage(qualifiedNamePackage);
        dm.close();
    }

    public static void writeUsage() {
        System.err.println("Usage: DisplayMetadata [-options]");
        System.err.println("where options include:");
        System.err.println("    -dbType=[no]");
        System.err.println("    -package=[qualified name of M2-layer package]");
    }

    public void close() {
        try {
            this.cx.close();
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPackage(String qualifiedNamePackage) {
        try {
            ILocalTransaction lt = (ILocalTransaction)this.cx.getLocalTransaction();
            try {
                lt.begin();
                System.out.println("M1-layer, package: " + qualifiedNamePackage);
                RefPackage topM1 = this.cx.getTopLevelPackageM1();
                RefPackage refPackage = topM1.refPackage(qualifiedNamePackage);
                System.out.println("  Packages:");
                Collection c = refPackage.refAllPackages();
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    RefPackage p = (RefPackage)iter.next();
                    System.out.println("     " + p.refMofId());
                }
                System.out.println("  Classes:");
                c = refPackage.refAllClasses();
                iter = c.iterator();
                while (iter.hasNext()) {
                    RefClass cl = (RefClass)iter.next();
                    System.out.println("    Instances: " + cl.toString());
                    Collection co = this.cx.getRepository().selectM1AllOfClass(((MofClass)cl.refMetaObject()).getQualifiedName());
                    Iterator iter1 = co.iterator();
                    while (iter1.hasNext()) {
                        RefBaseObject ro = (RefBaseObject)iter1.next();
                        System.out.println("        " + ro.toString());
                    }
                }
                System.out.println("  Associations:");
                c = refPackage.refAllAssociations();
                iter = c.iterator();
                while (iter.hasNext()) {
                    RefAssociation a = (RefAssociation)iter.next();
                    System.out.println("     " + a.refMofId());
                }
            }
            finally {
                lt.rollback();
            }
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

