/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.search;

import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.List;

public class QueryFilter {
    public static final int COMPARATOR_EQ = 0;
    public static final int COMPARATOR_NE = 1;
    public static final int COMPARATOR_LT = 2;
    public static final int COMPARATOR_GT = 3;
    public static final int COMPARATOR_LE = 4;
    public static final int COMPARATOR_GE = 5;
    public static final int COMPARATOR_CP = 6;
    public static final char COMPARATOR_CP_CHARS = '*';
    public static final char COMPARATOR_CP_CHAR = '%';
    public static final char COMPARATOR_CP_CHARQ = '?';
    public static final char COMPARATOR_CP_ESCAPE = '\\';
    public static final int SORT_MODE_NONE = 0;
    public static final int SORT_MODE_ASCENDING = 1;
    public static final int SORT_MODE_DESCENDING = 2;
    private String attribute;
    private int comparator = 0;
    private String value;
    private int sortMode = 0;
    private static List comparatorAsString;
    private static List comparatorAsSQLString;
    private static List sortModeAsString;
    private static final Location location;
    static /* synthetic */ Class class$com$sap$ip$mmr$search$QueryFilter;

    public QueryFilter() {
        QueryFilter.initialize();
    }

    public QueryFilter(String attribute, int comparator, String value) {
        this.setAttribute(attribute);
        this.setComparator(comparator);
        this.setValue(value);
        QueryFilter.initialize();
    }

    public QueryFilter(String attribute, String comparator, String value) {
        this.setAttribute(attribute);
        this.setComparator(QueryFilter.getComparatorByString(comparator));
        this.setValue(value);
        QueryFilter.initialize();
    }

    public QueryFilter(String attribute, int comparator, String value, int sortMode) {
        this.setAttribute(attribute);
        this.setComparator(comparator);
        this.setValue(value);
        this.setSortMode(sortMode);
        QueryFilter.initialize();
    }

    private static void initialize() {
        if (comparatorAsString == null) {
            comparatorAsString = new ArrayList(10);
            comparatorAsString.add(0, "==");
            comparatorAsString.add(1, "!=");
            comparatorAsString.add(2, "<");
            comparatorAsString.add(3, ">");
            comparatorAsString.add(4, "<=");
            comparatorAsString.add(5, ">=");
            comparatorAsString.add(6, "LIKE");
        }
        if (comparatorAsSQLString == null) {
            comparatorAsSQLString = new ArrayList(10);
            comparatorAsSQLString.add(0, "=");
            comparatorAsSQLString.add(1, "!=");
            comparatorAsSQLString.add(2, "<");
            comparatorAsSQLString.add(3, ">");
            comparatorAsSQLString.add(4, "<=");
            comparatorAsSQLString.add(5, ">=");
            comparatorAsSQLString.add(6, "LIKE");
        }
        if (sortModeAsString == null) {
            sortModeAsString = new ArrayList(3);
            sortModeAsString.add(0, "no sorting");
            sortModeAsString.add(1, "sort ascending");
            sortModeAsString.add(2, "sort descending");
        }
    }

    public static int getComparatorByString(String comparator) {
        QueryFilter.initialize();
        int cmp = -1;
        for (int i = 0; i < comparatorAsString.size() && cmp < 0; ++i) {
            String str = (String)comparatorAsString.get(i);
            if (str.compareToIgnoreCase(comparator) != 0) continue;
            cmp = i;
        }
        return cmp;
    }

    public static String getComparatorAsString(int comparator) {
        QueryFilter.initialize();
        return (String)comparatorAsString.get(comparator);
    }

    public String getComparatorAsString() {
        return QueryFilter.getComparatorAsString(this.getComparator());
    }

    public static String getComparatorAsSQLString(int comparator) {
        QueryFilter.initialize();
        return (String)comparatorAsSQLString.get(comparator);
    }

    public String getComparatorAsSQLString() {
        return QueryFilter.getComparatorAsSQLString(this.getComparator());
    }

    public static String getSortModeAsString(int sortMode) {
        QueryFilter.initialize();
        return (String)sortModeAsString.get(sortMode);
    }

    public String getSortModeAsString() {
        return QueryFilter.getSortModeAsString(this.getSortMode());
    }

    public String getAttribute() {
        return this.attribute;
    }

    public int getComparator() {
        return this.comparator;
    }

    public String getValue() {
        return this.value;
    }

    public final void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public final void setComparator(int comparator) {
        if (comparator < 0 || comparator > 6) {
            String method = "setComparator(int comparator)";
            RepositoryServer.getCategory().errorT(location, "setComparator(int comparator)", MMRResourceAccessor.getInstance().getMessageText("3013"), new Object[]{new Integer(comparator)});
            return;
        }
        this.comparator = comparator;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public int getSortMode() {
        return this.sortMode;
    }

    public final void setSortMode(int sortMode) {
        this.sortMode = sortMode;
    }

    public String toString() {
        return this.attribute + this.getComparatorAsString() + "'" + this.value.replace('?', '%') + "'";
    }

    public String toSQLString() {
        return this.attribute + this.getComparatorAsSQLString() + "'" + this.value + "'";
    }

    public boolean check(String value) {
        String method = "check(String value)";
        boolean flag = false;
        switch (this.comparator) {
            case 0: {
                flag = this.value.compareTo(value) == 0;
                break;
            }
            case 1: {
                flag = this.value.compareTo(value) != 0;
                break;
            }
            case 2: {
                flag = this.value.compareTo(value) < 0;
                break;
            }
            case 3: {
                flag = this.value.compareTo(value) > 0;
                break;
            }
            case 4: {
                flag = this.value.compareTo(value) <= 0;
                break;
            }
            case 5: {
                flag = this.value.compareTo(value) >= 0;
                break;
            }
            case 6: {
                flag = Utilities.getUtilities().containsPattern(this.value, value);
                break;
            }
            default: {
                RepositoryServer.getCategory().errorT(location, "check(String value)", MMRResourceAccessor.getInstance().getMessageText("3013"), new Object[]{new Integer(this.comparator)});
            }
        }
        return flag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$search$QueryFilter == null ? (class$com$sap$ip$mmr$search$QueryFilter = QueryFilter.class$("com.sap.ip.mmr.search.QueryFilter")) : class$com$sap$ip$mmr$search$QueryFilter);
    }
}

