/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl;
import com.sap.ip.mmr.m2layer.model.TypedElementImpl;
import java.util.Collection;
import javax.jmi.model.DirectionKind;
import javax.jmi.model.DirectionKindEnum;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Parameter;

public class ParameterImpl
extends TypedElementImpl
implements Parameter {
    static final long serialVersionUID = -8960258360175917790L;
    public static final String MULTIPLICITY = "multiplicity";
    public static final String DIRECTION = "direction";
    private MultiplicityType multiplicity = new MultiplicityTypeImpl(1, 1, false, false);
    private DirectionKind direction = DirectionKindEnum.IN_DIR;

    public ParameterImpl(IRepository repository) {
        super(repository);
    }

    public ParameterImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public ParameterImpl(IRepository repository, String name, String annotation, DirectionKind direction, MultiplicityType multiplicity) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setDirection(direction);
        this.setMultiplicity(multiplicity);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof ParameterImpl) {
            ParameterImpl p = (ParameterImpl)modelElement;
            this.setMultiplicity(p.getMultiplicity());
            this.setDirection(p.getDirection());
        }
    }

    public DirectionKind getDirection() {
        return this.direction;
    }

    public final void setDirection(DirectionKind newValue) {
        if (newValue == null) {
            return;
        }
        if (this.direction == null || !this.direction.equals(newValue)) {
            this.direction = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public MultiplicityType getMultiplicity() {
        return this.multiplicity;
    }

    public final void setMultiplicity(MultiplicityType newValue) {
        if (newValue == null) {
            return;
        }
        if (this.multiplicity == null || !this.multiplicity.equals(newValue)) {
            this.multiplicity = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(MULTIPLICITY) == 0) {
            this.setMultiplicity((MultiplicityType)value);
        } else if (featureName.compareTo(DIRECTION) == 0) {
            this.setDirection((DirectionKind)value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(MULTIPLICITY) == 0) {
                o = this.getMultiplicity();
            } else if (featureName.compareTo(DIRECTION) == 0) {
                o = this.getDirection();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        col = this.checkMultipliticy(col, this.getMultiplicity());
        return col;
    }
}

