/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ClassifierImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.Attribute;
import javax.jmi.model.Constant;
import javax.jmi.model.Constraint;
import javax.jmi.model.DataType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.Operation;
import javax.jmi.model.Reference;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKind;

public class MofClassImpl
extends ClassifierImpl
implements MofClass {
    static final long serialVersionUID = 4882580750978739287L;
    public static final String ISSINGLETON = "isSingleton";
    private boolean singleton = false;

    public MofClassImpl(IRepository repository) {
        super(repository);
    }

    public MofClassImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public MofClassImpl(IRepository repository, String name, String annotation, boolean isRoot, boolean isLeaf, boolean isAbstract, VisibilityKind visibility, boolean isSingleton) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setRoot(isRoot);
        this.setLeaf(isLeaf);
        this.setAbstract(isAbstract);
        this.setVisibility(visibility);
        this.setSingleton(isSingleton);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof MofClassImpl) {
            MofClassImpl mc = (MofClassImpl)modelElement;
            this.setSingleton(mc.singleton);
        }
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public final void setSingleton(boolean newValue) {
        if (this.singleton != newValue) {
            this.singleton = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(ISSINGLETON) == 0) {
            if (value instanceof String) {
                this.setSingleton(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setSingleton((Boolean)value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null && featureName.compareTo(ISSINGLETON) == 0) {
            o = new Boolean(this.isSingleton());
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (me instanceof MofClass || me instanceof DataType || me instanceof Attribute || me instanceof Reference || me instanceof Operation || me instanceof MofException || me instanceof Constant || me instanceof Constraint || me instanceof Tag) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_15", new Object[]{this}));
        }
        if (this.isAbstract() && this.isSingleton()) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_16", new Object[]{this}));
        }
        return col;
    }
}

