/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.m2layer.model.DataTypeImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.ArrayList;
import java.util.List;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.VisibilityKind;

public class EnumerationTypeImpl
extends DataTypeImpl
implements EnumerationType {
    static final long serialVersionUID = 5350840618848603437L;
    public static final String LABELS = "labels";
    private List labels;

    public EnumerationTypeImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public EnumerationTypeImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public EnumerationTypeImpl(IRepository repository, String name, String annotation, boolean isRoot, boolean isLeaf, boolean isAbstract, VisibilityKind visibility, List labels) {
        super(repository, name);
        this.initialize();
        this.setAnnotation(annotation);
        this.setRoot(isRoot);
        this.setLeaf(isLeaf);
        this.setAbstract(isAbstract);
        this.setVisibility(visibility);
        this.labels = labels;
    }

    private void initialize() {
        this.labels = new ArrayList();
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof EnumerationTypeImpl) {
            EnumerationTypeImpl et = (EnumerationTypeImpl)modelElement;
            if (!this.labels.containsAll(et.labels)) {
                this.labels = new ArrayList(et.labels);
                this.setState(StateEnum.STATE_CHANGED);
            }
        }
    }

    public List getLabels() {
        return this.labels;
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(LABELS) == 0) {
            this.labels = (List)value;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null && featureName.compareTo(LABELS) == 0) {
            o = this.getLabels();
        }
        return o;
    }
}

