/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepositoryClassLoader;
import com.sap.ip.mmr.foundation.ClassLoaderMMR;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public class ClassLoaderFactory {
    private static ClassLoaderFactory clf;
    private SAXParserFactory saxParserFactory;
    private DocumentBuilderFactory dbf;
    private Map classLoaders = new HashMap();

    public static ClassLoaderFactory getClassLoaderFactory() {
        if (clf == null) {
            clf = new ClassLoaderFactory();
        }
        return clf;
    }

    public void removeClassLoader(IConnection con) {
        this.classLoaders.remove(con.getConnectionId());
    }

    public ClassLoaderMMR getClassLoader(IRepositoryClassLoader rcl, IConnection con) {
        ClassLoaderMMR cl = null;
        if (con != null) {
            cl = (ClassLoaderMMR)this.classLoaders.get(con.getConnectionId());
        }
        if (cl == null) {
            ClassLoader clParent = null;
            if (con != null) {
                clParent = con.getConnectionSpec().getComponentClassLoader();
            }
            if (clParent == null) {
                clParent = Thread.currentThread().getContextClassLoader();
            }
            cl = new ClassLoaderMMR(clParent, rcl);
            cl.setClThread(Thread.currentThread().getContextClassLoader());
            ClassLoader clComponent = null;
            if (con != null) {
                clComponent = con.getConnectionSpec().getComponentClassLoader();
            }
            if (clComponent == null) {
                clComponent = this.getClass().getClassLoader();
            }
            cl.setClClass(clComponent);
            cl.setClSystem(ClassLoader.getSystemClassLoader());
            if (con != null) {
                this.classLoaders.put(con.getConnectionId(), cl);
            }
        }
        return cl;
    }

    public SAXParserFactory getSAXParserFactory(IRepositoryClassLoader rcl, IConnection con) {
        if (this.saxParserFactory == null) {
            ClassLoader clct = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader(rcl, con));
            this.saxParserFactory = SAXParserFactory.newInstance();
            this.saxParserFactory.setValidating(true);
            this.saxParserFactory.setNamespaceAware(true);
            Thread.currentThread().setContextClassLoader(clct);
        }
        return this.saxParserFactory;
    }

    public SAXParser getSAXParser(IRepositoryClassLoader rcl, IConnection con) {
        SAXParser saxParser = null;
        ClassLoader clct = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader(rcl, con));
        try {
            saxParser = this.getSAXParserFactory(rcl, con).newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            saxParser = null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            saxParser = null;
        }
        Thread.currentThread().setContextClassLoader(clct);
        return saxParser;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory(IRepositoryClassLoader rcl, IConnection con) {
        if (this.dbf == null) {
            ClassLoader clct = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader(rcl, con));
            this.dbf = DocumentBuilderFactory.newInstance();
            Thread.currentThread().setContextClassLoader(clct);
        }
        return this.dbf;
    }
}

