/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.dbmemory;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.applications.IProgressMonitor;
import com.sap.ip.mmr.applications.InstanceAndProperties;
import com.sap.ip.mmr.applications.SynchronizationState;
import com.sap.ip.mmr.dbmemory.Cache;
import com.sap.ip.mmr.foundation.AssociationsContainer;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.ListInstanceInfo;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.Generator;
import com.sap.ip.mmr.generate.jmi.GeneratorAssociation;
import com.sap.ip.mmr.generate.jmi.GeneratorClass;
import com.sap.ip.mmr.generate.jmi.GeneratorPackage;
import com.sap.ip.mmr.generate.jmi.GeneratorStructureType;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.IRefClass;
import com.sap.ip.mmr.m1layer.Instantiator;
import com.sap.ip.mmr.m1layer.MMRClass;
import com.sap.ip.mmr.m1layer.RefPackageImpl;
import com.sap.ip.mmr.m1layer.TopLevelPackage;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.ModelPackageImpl;
import com.sap.ip.mmr.m2layer.model.MofPackageImpl;
import com.sap.ip.mmr.m2layer.model.RefAssociationImpl;
import com.sap.ip.mmr.m3layer.RepositoryDBLayerM3;
import com.sap.ip.mmr.search.AttributesValues;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.Association;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.NameNotResolvedException;
import javax.jmi.model.Namespace;
import javax.jmi.model.StructureType;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.TypeMismatchException;

public class RepositoryDBMemory {
    private IRepository repository = null;
    private IRepositoryServer repositoryServer = null;
    private IConnection connection = null;
    private Cache cacheM2 = null;
    private Cache cacheM1 = null;
    private Cache cacheM2Deleted = null;
    private Cache cacheM1Deleted = null;
    private Map cacheQualifiedName = new HashMap();
    private Set modelElementsForTask = new HashSet();
    private Set objectsForTask = new HashSet();
    private Set modelElementsDeletedForTask = new HashSet();
    private Set objectsDeletedForTask = new HashSet();
    private Map copiesM2 = null;
    private Map copiesM1 = null;
    private MofPackage mofPackageRootM2 = null;
    private List cacheHierarchy;
    private RepositoryDBLayerM3 repositoryDB_M3;
    private boolean initialized = false;
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$dbmemory$RepositoryDBMemory == null ? (class$com$sap$ip$mmr$dbmemory$RepositoryDBMemory = RepositoryDBMemory.class$("com.sap.ip.mmr.dbmemory.RepositoryDBMemory")) : class$com$sap$ip$mmr$dbmemory$RepositoryDBMemory);
    static /* synthetic */ Class class$com$sap$ip$mmr$dbmemory$RepositoryDBMemory;

    public RepositoryDBMemory(IRepository repository, IRepositoryServer repositoryServer, IConnection connection) {
        this.repository = repository;
        this.repositoryServer = repositoryServer;
        this.connection = connection;
        this.initialize();
    }

    private final void initialize() {
        if (!this.initialized) {
            this.cacheM2 = new Cache();
            this.cacheM2Deleted = new Cache(3153600000000L);
            this.copiesM2 = new HashMap();
            this.cacheM1 = new Cache();
            this.cacheM1Deleted = new Cache(3153600000000L);
            this.copiesM1 = new HashMap();
            this.cacheHierarchy = new ArrayList(4);
            for (int i = 0; i < 4; ++i) {
                this.cacheHierarchy.add(new HashMap());
            }
            this.initialized = true;
        }
    }

    public void finalizer() {
        try {
            this.repositoryServer.connectionClosed(this.connection);
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        this.repository = null;
        this.repositoryServer = null;
        this.connection = null;
        this.cacheM2 = null;
        this.cacheM1 = null;
        this.cacheM2Deleted = null;
        this.cacheM1Deleted = null;
        this.cacheQualifiedName = null;
        this.modelElementsForTask = null;
        this.objectsForTask = null;
        this.modelElementsDeletedForTask = null;
        this.objectsDeletedForTask = null;
        this.copiesM2 = null;
        this.copiesM1 = null;
        this.mofPackageRootM2 = null;
        this.cacheHierarchy = null;
    }

    private IRepositoryServer getRepositoryServer() {
        if (this.repositoryServer.isFinalized()) {
            this.repositoryServer = null;
        }
        if (this.repositoryServer == null) {
            this.repositoryServer = RepositoryServer.getRepositoryServer();
        }
        return this.repositoryServer;
    }

    public boolean transactionBegin() {
        return true;
    }

    public boolean transactionCommit() {
        return this.commit();
    }

    public boolean transactionRollback() {
        return this.rollback();
    }

    public void deleteAllM2() {
        this.cacheM2.clear();
        this.cacheM2Deleted.clear();
        this.copiesM2.clear();
        ((HashMap)this.cacheHierarchy.get(2)).clear();
        this.getRepositoryServer().deleteM2All(this.connection);
    }

    public void deleteAllM1() {
        this.cacheM1.clear();
        this.cacheM1Deleted.clear();
        this.copiesM1.clear();
        ((HashMap)this.cacheHierarchy.get(1)).clear();
        this.getRepositoryServer().deleteM1All(this.connection);
    }

    public Collection commit(Collection collection) {
        if (collection == null) {
            return null;
        }
        String method = "commit(Collection collection)";
        LinkedList colM2 = new LinkedList();
        LinkedList colM1 = new LinkedList();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof IModelElement) {
                colM2.add(o);
                continue;
            }
            if (o instanceof IMMRObject) {
                colM1.add(o);
                continue;
            }
            Repository.getCategory().errorT(location, "commit(Collection collection)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2016"), new Object[]{o});
        }
        return this.commit(colM2, colM1);
    }

    public boolean isNewInstance(int mofLayer, String mofId) {
        boolean isNew = false;
        switch (mofLayer) {
            case 1: {
                IMMRObject mmro = (IMMRObject)this.cacheM1.get(mofId);
                if (mmro == null) break;
                isNew = mmro.get___State() == StateEnum.STATE_NEW;
                break;
            }
            case 2: {
                IModelElement me = (IModelElement)this.cacheM2.get(mofId);
                if (me == null) break;
                isNew = me.getState() == StateEnum.STATE_NEW;
                break;
            }
            case 3: {
                isNew = false;
                break;
            }
            default: {
                isNew = true;
            }
        }
        return isNew;
    }

    public Collection insertM2(Collection modelElements) {
        Collection colFailed = null;
        if (modelElements == null || modelElements.size() <= 0) {
            return colFailed;
        }
        Iterator i = modelElements.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof ModelElementImpl)) continue;
            ((ModelElementImpl)o).setRepository(this.repository);
        }
        this.insertM2Cache(modelElements);
        Iterator iter = modelElements.iterator();
        while (iter.hasNext()) {
            ModelElementImpl me = (ModelElementImpl)iter.next();
            this.copiesM2.put(me.refMofId(), this.getRepositoryServer().createCloneM2(this.repository, me));
        }
        return colFailed;
    }

    protected void insertM2Cache(Collection modelElements) {
        if (modelElements.size() > 0) {
            this.cacheM2.putAll(modelElements);
        }
    }

    public Collection insertM1(Collection objects) {
        if (objects == null) {
            return null;
        }
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof IMMRObject)) continue;
            ((IMMRObject)o).set___Repository(this.repository);
        }
        Collection col = this.cacheM1.putAll(objects);
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            IMMRObject mmro = (IMMRObject)iter.next();
            this.copiesM1.put(mmro.get___MofId(), this.getRepositoryServer().createCloneM1(this.repository, mmro));
        }
        return col;
    }

    public Collection deleteM2(Collection modelElements, boolean deleteContainedElements) {
        Collection contained;
        if (modelElements == null) {
            return null;
        }
        Collection colFailed = null;
        if (deleteContainedElements && (contained = this.getContainedElements(modelElements)) != null) {
            modelElements.addAll(contained);
        }
        this.cacheM2Deleted.putAll(modelElements);
        colFailed = this.cacheM2.remove(modelElements);
        Iterator iter = modelElements.iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            this.copiesM2.remove(me.refMofId());
        }
        ModelPackageImpl topLevelPackageM2 = (ModelPackageImpl)this.repository.getTopLevelPackageM2();
        topLevelPackageM2.getAssociationsContainer().removeAllLinks(modelElements);
        return colFailed;
    }

    protected Collection getContainedElements(Collection modelElements) {
        if (modelElements == null) {
            return null;
        }
        HashSet meIn = new HashSet(modelElements);
        HashSet<ModelElement> meOut = new HashSet<ModelElement>();
        HashSet<ModelElement> meAll = new HashSet<ModelElement>();
        while (meIn.size() > 0) {
            Iterator iter = meIn.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof Namespace)) continue;
                List list = ((Namespace)me).getContents();
                Iterator iter1 = list.iterator();
                while (iter1.hasNext()) {
                    ModelElement me_ = (ModelElement)iter1.next();
                    meOut.add(me_);
                }
            }
            meAll.addAll(meOut);
            meIn.clear();
            meIn.addAll(meOut);
            meOut.clear();
        }
        return new LinkedList(meAll);
    }

    public Collection deleteM1(Collection objects) {
        this.cacheM1Deleted.putAll(objects);
        Collection colFailed = null;
        colFailed = this.cacheM1.remove(objects);
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            RefBaseObject rbo = (RefBaseObject)iter.next();
            this.copiesM1.remove(rbo.refMofId());
        }
        return colFailed;
    }

    public boolean containsM2(String mofId) {
        if (mofId == null) {
            return false;
        }
        LinkedList<String> list = new LinkedList<String>();
        list.add(mofId);
        Collection col = this.selectM2(list, false);
        return col != null && col.size() >= 1;
    }

    public Collection selectM2(Collection mofIds, boolean forUpdate) {
        HashSet set = new HashSet(mofIds);
        LinkedList<Object> col = new LinkedList<Object>();
        LinkedList<String> colNotInCache = new LinkedList<String>();
        Iterator iter = mofIds.iterator();
        while (iter.hasNext()) {
            String mofId = (String)iter.next();
            Object o = this.cacheM2.get(mofId);
            if (o == null) {
                colNotInCache.add(mofId);
                continue;
            }
            col.add(o);
        }
        if (colNotInCache.size() > 0) {
            Collection colDb = null;
            try {
                colDb = this.getRepositoryServer().selectM2(this.connection, colNotInCache, forUpdate);
            }
            catch (BaseRuntimeException e1) {
                e1.log();
            }
            catch (BaseException e1) {
                e1.log();
            }
            if (colDb != null && colDb.size() > 0) {
                this.insertM2Cache(colDb);
                col.addAll(colDb);
            }
        }
        iter = col.iterator();
        while (iter.hasNext()) {
            ModelElementImpl me = (ModelElementImpl)iter.next();
            me.setRepository(this.repository);
            this.copiesM2.put(me.refMofId(), this.getRepositoryServer().createCloneM2(this.repository, me));
        }
        if (col != null && col.size() > 0) {
            iter = col.iterator();
            while (iter.hasNext()) {
                RefBaseObject rbo = (RefBaseObject)iter.next();
                if (set.contains(rbo.refMofId())) continue;
                iter.remove();
            }
        }
        return col;
    }

    public ModelElement resolveQualifiedNameM2(List qualifiedName) {
        ModelElement me = null;
        try {
            me = this.getRepositoryServer().resolveQualifiedNameM2(this.connection, qualifiedName);
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        return me;
    }

    public ModelElement resolveQualifiedNameM2UsingCache(List qualifiedName) {
        ModelElement me = null;
        try {
            me = this.getRepositoryServer().resolveQualifiedNameM2(this.connection, qualifiedName);
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        if (me == null) {
            try {
                me = this.selectMofPackageRootM2().resolveQualifiedName(qualifiedName);
            }
            catch (NameNotResolvedException e1) {
                me = null;
            }
        }
        return me;
    }

    public ModelElement selectM2ByName(String qualifiedName, boolean forUpdate) {
        if (qualifiedName == null || qualifiedName.compareTo("ModelPackageMetaObject") == 0) {
            return this.repository.getMofPackageRootM2();
        }
        return this.isValidQualifiedName(qualifiedName);
    }

    public Collection selectM2AllOfClass(List qualifiedName) {
        LinkedList col = null;
        try {
            col = this.getRepositoryServer().selectM2AllOfClass(this.connection, qualifiedName);
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        if (col == null) {
            col = new LinkedList();
        }
        List colCached = null;
        colCached = this.cacheM2.getAll();
        col.addAll(colCached);
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            IModelElement me = (IModelElement)iter.next();
            me.setRepository(this.repository);
        }
        return col;
    }

    public Collection selectM2TopLevelPackages() {
        Collection c = null;
        try {
            c = this.getRepositoryServer().selectM2TopLevelPackages(this.connection);
        }
        catch (BaseRuntimeException e) {
            e.log();
            c = null;
        }
        catch (BaseException e) {
            e.log();
            c = null;
        }
        return c;
    }

    public Collection selectM1(Collection mofIdsOrObjects, boolean forUpdate) {
        Iterator iter;
        HashSet<String> set = new HashSet<String>(mofIdsOrObjects.size());
        LinkedList colFound = new LinkedList();
        LinkedList<String> colNotFound = new LinkedList<String>();
        if (mofIdsOrObjects != null) {
            iter = mofIdsOrObjects.iterator();
            while (iter.hasNext()) {
                String mofId = null;
                Object o = iter.next();
                if (o instanceof String) {
                    mofId = (String)o;
                } else if (o instanceof RefBaseObject) {
                    mofId = ((RefBaseObject)o).refMofId();
                }
                if (mofId == null) continue;
                set.add(mofId);
                o = this.cacheM1.get(mofId);
                if (o instanceof RefBaseObject) {
                    colFound.add(o);
                }
                if (o != null) continue;
                colNotFound.add(mofId);
            }
            if (colNotFound.size() > 0) {
                Collection colFoundDB = null;
                try {
                    colFoundDB = this.getRepositoryServer().selectM1(this.connection, colNotFound, forUpdate);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
                if (colFoundDB != null) {
                    colFound.addAll(colFoundDB);
                    this.cacheM1.putAll(colFoundDB);
                }
            }
        }
        if (colFound != null && colFound.size() > 0) {
            IMMRObject rbo;
            iter = colFound.iterator();
            while (iter.hasNext()) {
                rbo = (IMMRObject)iter.next();
                rbo.set___Repository(this.repository);
                this.copiesM1.put(rbo.get___MofId(), this.getRepositoryServer().createCloneM1(this.repository, rbo));
            }
            iter = colFound.iterator();
            while (iter.hasNext()) {
                rbo = (RefBaseObject)iter.next();
                if (set.contains(rbo.refMofId())) continue;
                iter.remove();
            }
        }
        return colFound;
    }

    public IMMRObject selectM1ByName(String type, List args, List instantiators, boolean forUpdate) {
        IMMRObject mmro = null;
        if (type == null) {
            mmro = (IMMRObject)this.repository.getTopLevelPackageM1();
        } else {
            try {
                mmro = this.getRepositoryServer().selectM1ByName(this.connection, type, args, instantiators, forUpdate);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return mmro;
    }

    public Collection selectM1AllOfClass(List qualifiedName) {
        LinkedList col = null;
        try {
            col = this.getRepositoryServer().selectM1AllOfClass(this.connection, qualifiedName);
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        if (col == null) {
            col = new LinkedList();
        }
        List colCached = null;
        String qNameTypeJava = Generator.correctQualifiedName(qualifiedName);
        colCached = this.cacheM1.getAllOfType(qNameTypeJava);
        if (colCached != null && colCached.size() > 0) {
            col.addAll(colCached);
        }
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                IMMRObject me = (IMMRObject)iter.next();
                me.set___Repository(this.repository);
            }
        }
        return col;
    }

    public List queryAssociationsM2(String mofId, String associationType, int depth) {
        ModelPackageImpl modelPackage = (ModelPackageImpl)this.repository.getTopLevelPackageM2();
        return modelPackage.queryAssociations(mofId, associationType, depth);
    }

    public boolean commit() {
        Collection col = this.commit(null, null);
        return col == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Collection commit(Collection objectsM2, Collection objectsM1) {
        Collection colFailed;
        block91: {
            Object o;
            HashMap aoosM1I;
            TopLevelPackage topLevelPackageM1;
            LinkedList<String> mofIdsM1;
            HashMap aoosM2I;
            LinkedList<String> mofIdsM2;
            List colM1I;
            List colM2I;
            ModelPackageImpl topLevelPackageM2;
            block89: {
                Iterator iterD;
                RefBaseObject rbo;
                ModelElement me;
                Iterator iter;
                String method = "commit(Collection objectsM2, Collection objectM1)";
                colFailed = null;
                location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2000"));
                this.getRepositoryServer().transactionBegin(this.connection);
                topLevelPackageM2 = null;
                topLevelPackageM2 = (ModelPackageImpl)this.repository.getTopLevelPackageM2();
                colM2I = this.cacheM2.getAllChanged(objectsM2);
                if (this.cacheM2Deleted.size() > 0) {
                    Iterator iter2 = this.cacheM2Deleted.getAll().iterator();
                    while (iter2.hasNext()) {
                        ModelElement me2 = (ModelElement)iter2.next();
                        colM2I.remove(me2);
                    }
                }
                if (colM2I.size() > 0) {
                    location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2001"));
                    ArrayList modelElementsObsolete = new ArrayList();
                    this.checkPersistenceM2(colM2I, modelElementsObsolete);
                    this.cacheM2.remove(modelElementsObsolete);
                    if (modelElementsObsolete.size() > 0) {
                        iter = modelElementsObsolete.iterator();
                        while (iter.hasNext()) {
                            me = (ModelElement)iter.next();
                            colM2I.remove(me);
                        }
                    }
                    topLevelPackageM2.getAssociationsContainer().clearAssociationsChanged(modelElementsObsolete);
                }
                if (colM2I.size() > 0) {
                    location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2002"));
                    colFailed = this.verifyObjects(colM2I);
                    if (colFailed != null && colFailed.size() > 0) {
                        Repository.getCategory().errorT(location, "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2003"));
                        Iterator i = colFailed.iterator();
                        while (i.hasNext()) {
                            Object o2 = i.next();
                            Repository.getCategory().errorT(location, "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2023"), new Object[]{o2.toString()});
                        }
                    }
                }
                this.modelElementsForTask.clear();
                if (colM2I.size() > 0) {
                    this.modelElementsForTask.addAll(colM2I);
                }
                if ((colM1I = this.cacheM1.getAllChanged(objectsM1)).size() > 0) {
                    iter = colM1I.iterator();
                    while (iter.hasNext()) {
                        rbo = (RefBaseObject)iter.next();
                        if (!(rbo instanceof RefPackage) && !(rbo instanceof RefClass)) continue;
                        iter.remove();
                    }
                }
                if (this.cacheM1Deleted.size() > 0) {
                    iter = colM1I.iterator();
                    while (iter.hasNext()) {
                        rbo = (RefBaseObject)iter.next();
                        if (!this.cacheM1Deleted.containsKey(rbo.refMofId())) continue;
                        iter.remove();
                    }
                }
                if (colM1I.size() > 0) {
                    location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2004"));
                    colFailed = this.verifyObjects(colM1I);
                    if (colFailed != null && colFailed.size() > 0) {
                        Repository.getCategory().errorT(location, "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2005"));
                        Iterator i = colFailed.iterator();
                        while (i.hasNext()) {
                            Object o3 = i.next();
                            Repository.getCategory().errorT(location, "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2023"), new Object[]{o3.toString()});
                        }
                    }
                }
                this.objectsForTask.clear();
                if (colM1I.size() > 0) {
                    this.objectsForTask.addAll(colM1I);
                }
                if (this.cacheM2Deleted.size() > 0) {
                    this.modelElementsDeletedForTask.clear();
                    if (this.cacheM2Deleted.size() > 0) {
                        this.modelElementsDeletedForTask.addAll(this.cacheM2Deleted.getAll());
                    }
                    iterD = this.cacheM2Deleted.values().iterator();
                    while (iterD.hasNext()) {
                        me = (IModelElement)iterD.next();
                        if (!StateEnum.STATE_NEW.equals(me.getState())) continue;
                        iterD.remove();
                    }
                    location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2006"), new Object[]{new Integer(this.cacheM2Deleted.size())});
                }
                if (this.cacheM1Deleted.size() > 0) {
                    this.objectsDeletedForTask.clear();
                    if (this.cacheM1Deleted.size() > 0) {
                        this.objectsDeletedForTask.addAll(this.cacheM1Deleted.getAll());
                    }
                    iterD = this.cacheM1Deleted.values().iterator();
                    while (iterD.hasNext()) {
                        IMMRObject mmro = (IMMRObject)iterD.next();
                        if (!StateEnum.STATE_NEW.equals(mmro.get___State())) continue;
                        iterD.remove();
                    }
                    location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2007"), new Object[]{new Integer(this.cacheM1Deleted.size())});
                }
                mofIdsM2 = null;
                if (colM2I != null) {
                    mofIdsM2 = new LinkedList<String>();
                    Iterator iter3 = colM2I.iterator();
                    while (iter3.hasNext()) {
                        ModelElement me3 = (ModelElement)iter3.next();
                        mofIdsM2.add(me3.refMofId());
                    }
                }
                aoosM2I = new HashMap();
                topLevelPackageM2.getAssociationsContainer().getAssociationsChanged(mofIdsM2, aoosM2I);
                this.addEmptyAssociations(aoosM2I, colM2I);
                mofIdsM1 = null;
                if (colM1I != null) {
                    mofIdsM1 = new LinkedList<String>();
                    Iterator iter4 = colM1I.iterator();
                    while (iter4.hasNext()) {
                        RefBaseObject ro = (RefBaseObject)iter4.next();
                        mofIdsM1.add(ro.refMofId());
                    }
                }
                topLevelPackageM1 = null;
                topLevelPackageM1 = (TopLevelPackage)this.repository.getTopLevelPackageM1();
                aoosM1I = new HashMap();
                aoosM1I.clear();
                topLevelPackageM1.getAssociationsContainer().getAssociationsChanged(mofIdsM1, aoosM1I);
                this.addEmptyAssociations(aoosM1I, colM1I);
                boolean res = true;
                try {
                    res = this.getRepositoryServer().transactionBeforeCommit(this.connection, colM2I, aoosM2I, this.cacheM2Deleted.values(), colM1I, aoosM1I, this.cacheM1Deleted.values());
                }
                catch (Exception e) {
                    Repository.getCategory().errorT(location, "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2024"), new Object[]{e.toString()});
                    ArrayList arrayList = colFailed;
                    Object var20_34 = null;
                    try {
                        this.getRepositoryServer().transactionCommit(this.connection);
                    }
                    catch (Exception e2) {
                        Repository.writeExceptionToCategory("commit(Collection objectsM2, Collection objectM1)", e2);
                    }
                    return arrayList;
                }
                if (res) break block89;
                Repository.getCategory().errorT(location, "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2024"));
                if (colFailed == null) {
                    colFailed = new ArrayList();
                }
                colFailed.addAll(colM2I);
                colFailed.addAll(colM1I);
                Collection e = colFailed;
                Object var20_35 = null;
                try {
                    this.getRepositoryServer().transactionCommit(this.connection);
                }
                catch (Exception e2) {
                    Repository.writeExceptionToCategory("commit(Collection objectsM2, Collection objectM1)", e2);
                }
                return e;
            }
            if (this.cacheM2Deleted.size() > 0) {
                try {
                    colFailed = this.getRepositoryServer().deleteM2(this.connection, this.cacheM2Deleted.values());
                }
                catch (BaseRuntimeException e1) {
                    e1.log();
                }
                catch (BaseException e1) {
                    e1.log();
                }
            }
            if (this.cacheM1Deleted.size() > 0) {
                try {
                    colFailed = this.getRepositoryServer().deleteM1(this.connection, this.cacheM1Deleted.values());
                }
                catch (BaseRuntimeException e1) {
                    e1.log();
                }
                catch (BaseException e1) {
                    e1.log();
                }
            }
            if (colM2I.size() > 0) {
                location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2008"), new Object[]{new Integer(colM2I.size())});
                try {
                    colFailed = this.getRepositoryServer().insertM2(this.connection, colM2I);
                }
                catch (BaseRuntimeException e1) {
                    e1.log();
                }
                catch (BaseException e1) {
                    e1.log();
                }
            }
            if (colM1I.size() > 0) {
                location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2009"), new Object[]{new Integer(colM1I.size())});
                try {
                    colFailed = this.getRepositoryServer().insertM1(this.connection, colM1I);
                }
                catch (BaseRuntimeException e2) {
                    e2.log();
                }
                catch (BaseException e2) {
                    e2.log();
                }
            }
            if (aoosM2I.size() > 0) {
                location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2010"), new Object[]{new Integer(aoosM2I.size())});
                try {
                    if (!this.getRepositoryServer().insertM2Assoc(this.connection, aoosM2I)) {
                        colFailed = new ArrayList();
                        colFailed.addAll(aoosM2I.values());
                    }
                }
                catch (BaseRuntimeException e3) {
                    e3.log();
                }
                catch (BaseException e3) {
                    e3.log();
                }
            }
            if (aoosM1I.size() > 0) {
                location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2011"), new Object[]{new Integer(aoosM1I.size())});
                try {
                    if (!this.getRepositoryServer().insertM1Assoc(this.connection, aoosM1I)) {
                        colFailed = new ArrayList();
                        colFailed.addAll(aoosM1I.values());
                    }
                }
                catch (BaseRuntimeException e3) {
                    e3.log();
                }
                catch (BaseException e3) {
                    e3.log();
                }
            }
            for (int mofLayer = 0; mofLayer < 3; ++mofLayer) {
                HashMap map = (HashMap)this.cacheHierarchy.get(mofLayer);
                Iterator iter = map.values().iterator();
                while (iter.hasNext()) {
                    Hierarchy h = (Hierarchy)iter.next();
                    if (!h.isChanged()) continue;
                    switch (mofLayer) {
                        case 0: {
                            try {
                                if (!this.getRepositoryServer().writeHierarchyM0(this.connection, h)) {
                                    colFailed = new ArrayList();
                                    colFailed.add(h);
                                    break;
                                }
                                h.setChanged(false, true);
                            }
                            catch (BaseRuntimeException e3) {
                                e3.log();
                            }
                            catch (BaseException e3) {
                                e3.log();
                            }
                            break;
                        }
                        case 1: {
                            try {
                                if (!this.getRepositoryServer().writeHierarchyM1(this.connection, h)) {
                                    colFailed = new ArrayList();
                                    colFailed.add(h);
                                    break;
                                }
                                h.setChanged(false, true);
                            }
                            catch (BaseRuntimeException e4) {
                                e4.log();
                            }
                            catch (BaseException e4) {
                                e4.log();
                            }
                            break;
                        }
                    }
                }
            }
            location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2012"));
            if (topLevelPackageM2 != null) {
                topLevelPackageM2.getAssociationsContainer().clearAssociationsChanged(mofIdsM2);
            }
            if (topLevelPackageM1 != null) {
                topLevelPackageM1.getAssociationsContainer().clearAssociationsChanged(mofIdsM1);
            }
            this.copiesM2.clear();
            Iterator<Object> iter = this.cacheM2.keySet().iterator();
            while (iter.hasNext()) {
                String mofId = (String)iter.next();
                ModelElementImpl me = (ModelElementImpl)this.cacheM2.get(mofId);
                this.copiesM2.put(me.refMofId(), this.getRepositoryServer().createCloneM2(this.repository, me));
            }
            this.copiesM1.clear();
            iter = this.cacheM1.keySet().iterator();
            while (iter.hasNext()) {
                o = iter.next();
                if (o == null || !(o instanceof String)) continue;
                String mofId = (String)o;
                RefBaseObject rbo = (RefBaseObject)this.cacheM1.get(mofId);
                this.copiesM1.put(rbo.refMofId(), this.getRepositoryServer().createCloneM1(this.repository, (IMMRObject)rbo));
            }
            this.cacheM2Deleted.clear();
            this.cacheM1Deleted.clear();
            iter = colM2I.iterator();
            while (iter.hasNext()) {
                ModelElementImpl me = (ModelElementImpl)iter.next();
                me.setState(StateEnum.STATE_UNCHANGED);
            }
            iter = colM1I.iterator();
            while (iter.hasNext()) {
                o = (IMMRObject)iter.next();
                o.set___State(StateEnum.STATE_UNCHANGED);
            }
            Object var20_36 = null;
            try {
                this.getRepositoryServer().transactionCommit(this.connection);
            }
            catch (Exception e2) {
                Repository.writeExceptionToCategory("commit(Collection objectsM2, Collection objectM1)", e2);
            }
            break block91;
            {
                catch (Exception e) {
                    Repository.writeExceptionToCategory("commit(Collection objectsM2, Collection objectM1)", e);
                    Object var20_37 = null;
                    try {
                        this.getRepositoryServer().transactionCommit(this.connection);
                    }
                    catch (Exception e2) {
                        Repository.writeExceptionToCategory("commit(Collection objectsM2, Collection objectM1)", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var20_38 = null;
                try {
                    this.getRepositoryServer().transactionCommit(this.connection);
                }
                catch (Exception e2) {
                    Repository.writeExceptionToCategory("commit(Collection objectsM2, Collection objectM1)", e2);
                }
                throw throwable;
            }
        }
        location.debugT(Repository.getCategory(), "commit(Collection objectsM2, Collection objectM1)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2013"));
        return colFailed;
    }

    private void addEmptyAssociations(Map aoos, Collection objects) {
        if (objects == null) {
            return;
        }
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            String mofId = null;
            boolean isNew = true;
            if (o instanceof IModelElement) {
                mofId = ((IModelElement)o).refMofId();
                isNew = ((IModelElement)o).getState() == StateEnum.STATE_NEW;
            } else if (o instanceof RefBaseObject) {
                mofId = ((RefBaseObject)o).refMofId();
                if (o instanceof IMMRObject) {
                    boolean bl = isNew = ((IMMRObject)o).get___State() == StateEnum.STATE_NEW;
                }
            }
            if (!isNew || mofId == null || aoos.containsKey(mofId)) continue;
            AssociationsOfObject aoo = new AssociationsOfObject(mofId);
            aoos.put(mofId, aoo);
        }
    }

    public void checkPersistenceM2(Collection modelElements, Collection modelElementsObsolete) {
        IModelElement me;
        if (modelElements == null || modelElementsObsolete == null) {
            return;
        }
        String method = "checkPersistenceM2(Collection modelElements,Collection modelElementsObsolete)";
        LinkedList<IModelElement> listInsert = new LinkedList<IModelElement>();
        LinkedList<ModelElemenPairCopy> colCopy = new LinkedList<ModelElemenPairCopy>();
        HashMap<String, AssociationsContainer.MyRefObject> mapMofIds = new HashMap<String, AssociationsContainer.MyRefObject>();
        this.cacheQualifiedName.clear();
        HashMap<String, IModelElement> colToCheck = new HashMap<String, IModelElement>();
        Iterator<Object> iter = modelElements.iterator();
        while (iter.hasNext()) {
            IModelElement me2 = (IModelElement)iter.next();
            if (me2 == null) continue;
            if (me2.getState().equals(StateEnum.STATE_NEW)) {
                colToCheck.put(me2.refMofId(), me2);
                continue;
            }
            listInsert.add(me2);
        }
        MofPackageImpl root = (MofPackageImpl)this.selectMofPackageRootM2();
        if (colToCheck.size() > 0) {
            ModelElementQualifiedName meqn;
            LinkedList<ModelElementQualifiedName> list = new LinkedList<ModelElementQualifiedName>();
            iter = colToCheck.values().iterator();
            while (iter.hasNext()) {
                ModelElementImpl me3 = (ModelElementImpl)iter.next();
                ModelElementQualifiedName meqn2 = new ModelElementQualifiedName(me3);
                list.add(meqn2);
            }
            colToCheck = null;
            Collections.sort(list);
            iter = list.iterator();
            while (iter.hasNext()) {
                meqn = (ModelElementQualifiedName)iter.next();
                ModelElementImpl meResolved = (ModelElementImpl)this.resolveQualifiedNameM2(meqn.qualifiedName);
                if (meResolved != null) {
                    if (!meResolved.equals(meqn.modelElement)) {
                        colCopy.add(new ModelElemenPairCopy(meResolved, meqn.modelElement));
                        mapMofIds.put(meqn.modelElement.refMofId(), new AssociationsContainer.MyRefObject(meResolved.refMofId(), true, (RefObject)meResolved));
                        continue;
                    }
                    listInsert.add(meResolved);
                    continue;
                }
                listInsert.add(meqn.modelElement);
            }
            iter = colCopy.iterator();
            while (iter.hasNext()) {
                ModelElemenPairCopy pair = (ModelElemenPairCopy)iter.next();
                if (pair.me1 instanceof ModelElementImpl && pair.me2 instanceof ModelElementImpl) {
                    ((ModelElementImpl)pair.me1).copy((ModelElementImpl)pair.me2);
                } else {
                    Repository.getCategory().errorT(location, "checkPersistenceM2(Collection modelElements,Collection modelElementsObsolete)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2017"), new Object[]{pair.me1});
                }
                modelElementsObsolete.add(pair.me2);
                listInsert.add(pair.me1);
            }
            iter = list.iterator();
            while (iter.hasNext()) {
                meqn = (ModelElementQualifiedName)iter.next();
                if (!(meqn.modelElement instanceof MofPackage) || meqn.modelElement.getQualifiedName().size() != 1) continue;
                root.getContents().add(meqn.modelElement);
            }
            ModelPackageImpl topLevelPackageM2 = (ModelPackageImpl)this.repository.getTopLevelPackageM2();
            topLevelPackageM2.getAssociationsContainer().replace(mapMofIds);
        }
        iter = listInsert.iterator();
        while (iter.hasNext()) {
            me = (ModelElementImpl)iter.next();
            if (me.getState() != StateEnum.STATE_UNCHANGED) continue;
            iter.remove();
        }
        iter = listInsert.iterator();
        while (iter.hasNext()) {
            MofPackage p;
            me = (IModelElement)iter.next();
            if (!(me instanceof MofPackage) || (p = (MofPackage)me).getContainer() != null) continue;
            root.getContents().add(p);
        }
        modelElements.clear();
        modelElements.addAll(listInsert);
    }

    public boolean rollback() {
        String mofId;
        String method = "rollback()";
        boolean flag = true;
        Iterator iter = this.cacheM2Deleted.keySet().iterator();
        while (iter.hasNext()) {
            mofId = (String)iter.next();
            ModelElementImpl me = (ModelElementImpl)this.cacheM2Deleted.get(mofId);
            if (me == null) continue;
            this.cacheM2.put(me);
        }
        this.cacheM2Deleted.clear();
        iter = this.copiesM2.keySet().iterator();
        while (iter.hasNext()) {
            mofId = (String)iter.next();
            ModelElementImpl me_c = (ModelElementImpl)this.copiesM2.get(mofId);
            ModelElementImpl me = (ModelElementImpl)this.cacheM2.get(mofId);
            if (me == null || me_c == null) continue;
            me.copy(me_c);
        }
        this.copiesM2.clear();
        iter = this.cacheM1Deleted.keySet().iterator();
        while (iter.hasNext()) {
            mofId = (String)iter.next();
            IMMRObject o = (IMMRObject)this.cacheM1Deleted.get(mofId);
            if (o == null) continue;
            this.cacheM1.put(o);
        }
        this.cacheM1Deleted.clear();
        iter = this.copiesM1.keySet().iterator();
        while (iter.hasNext()) {
            mofId = (String)iter.next();
            IMMRObject mmri_c = (IMMRObject)this.copiesM1.get(mofId);
            IMMRObject mmri = (IMMRObject)this.cacheM1.get(mofId);
            if (mmri == null || mmri_c == null) continue;
            mmri.___copy(mmri_c);
        }
        this.copiesM1.clear();
        location.debugT(Repository.getCategory(), "rollback()", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2014"));
        location.debugT(Repository.getCategory(), "rollback()", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2015"));
        return flag;
    }

    public Collection rollback(Collection modelElements) {
        ModelElementImpl me;
        String method = "rollback(Collection modelElements)";
        Iterator iter = modelElements.iterator();
        while (iter.hasNext()) {
            me = (ModelElementImpl)iter.next();
            ModelElementImpl me_c = (ModelElementImpl)this.copiesM2.get(me.refMofId());
            if (me == null || me_c == null) continue;
            me.copy(me_c);
        }
        iter = modelElements.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            ModelElement me_ = (ModelElement)this.cacheM2Deleted.get((RefBaseObject)me);
            if (me_ == null) continue;
            this.cacheM2.put(me_);
        }
        location.debugT(Repository.getCategory(), "rollback(Collection modelElements)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "2015"));
        return null;
    }

    public boolean insertM2Assoc(Map aoos) {
        boolean flag = true;
        try {
            flag = this.getRepositoryServer().insertM2Assoc(this.connection, aoos);
        }
        catch (BaseRuntimeException e) {
            e.log();
            flag = false;
        }
        catch (BaseException e) {
            e.log();
            flag = false;
        }
        return flag;
    }

    public boolean deleteM2Assoc(Collection mofIds) {
        boolean flag = true;
        try {
            flag = this.getRepositoryServer().deleteM2Assoc(this.connection, mofIds);
        }
        catch (BaseRuntimeException e) {
            e.log();
            flag = false;
        }
        catch (BaseException e) {
            e.log();
            flag = false;
        }
        return flag;
    }

    public AssociationsOfObject selectM2Assoc(String associationId, String mofId) {
        AssociationsOfObject aoo = null;
        try {
            aoo = this.getRepositoryServer().selectM2Assoc(this.connection, associationId, mofId);
        }
        catch (BaseRuntimeException e) {
            e.log();
            aoo = null;
        }
        catch (BaseException e) {
            e.log();
            aoo = null;
        }
        return aoo;
    }

    public boolean insertM1Assoc(Map aoos) {
        boolean flag = true;
        try {
            flag = this.getRepositoryServer().insertM1Assoc(this.connection, aoos);
        }
        catch (BaseRuntimeException e) {
            e.log();
            flag = false;
        }
        catch (BaseException e) {
            e.log();
            flag = false;
        }
        return flag;
    }

    public boolean deleteM1Assoc(Collection mofIds) {
        boolean flag = true;
        try {
            flag = this.getRepositoryServer().deleteM1Assoc(this.connection, mofIds);
        }
        catch (BaseRuntimeException e) {
            e.log();
            flag = false;
        }
        catch (BaseException e) {
            e.log();
            flag = false;
        }
        return flag;
    }

    public AssociationsOfObject selectM1Assoc(String associationId, String mofId) {
        AssociationsOfObject aoo = null;
        try {
            aoo = this.getRepositoryServer().selectM1Assoc(this.connection, associationId, mofId);
        }
        catch (BaseRuntimeException e) {
            e.log();
            aoo = null;
        }
        catch (BaseException e) {
            e.log();
            aoo = null;
        }
        return aoo;
    }

    public RepositoryDBLayerM3 getRepositoryDBLayerM3() {
        if (this.repositoryDB_M3 == null) {
            this.repositoryDB_M3 = new RepositoryDBLayerM3(this.repository);
            this.repositoryDB_M3.initialize();
        }
        return this.repositoryDB_M3;
    }

    public RefObject selectM3(String mofId) {
        RefObject o = this.getRepositoryDBLayerM3().selectM3(this.connection, mofId);
        if (o != null) {
            ((IModelElement)o).setRepository(this.repository);
        }
        return o;
    }

    public RefObject selectM3ByName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        RefObject o = this.getRepositoryDBLayerM3().selectM3ByName(this.connection, qualifiedName);
        if (o != null) {
            ((IModelElement)o).setRepository(this.repository);
        }
        return o;
    }

    public AssociationsOfObject selectM3Assoc(String associationId, String mofId) {
        AssociationsOfObject aoo = this.getRepositoryDBLayerM3().selectM3Assoc(this.connection, associationId, mofId);
        return aoo;
    }

    public Collection verifyObjects(Collection objects) {
        String method = "verifyObjects(Collection objects)";
        LinkedList colFailed = null;
        if (objects != null) {
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                RefBaseObject ro;
                Collection col;
                Object o = iter.next();
                if (!(o instanceof RefBaseObject) || (col = (ro = (RefBaseObject)o).refVerifyConstraints(false)) == null || col.size() <= 0) continue;
                if (colFailed == null) {
                    colFailed = new LinkedList();
                }
                colFailed.add(o);
                Iterator i2 = col.iterator();
                while (i2.hasNext()) {
                    JmiException e = (JmiException)i2.next();
                    RefObject e_ro = e.getElementInError();
                    Object e_o = e.getObjectInError();
                    String str = "";
                    if (e_ro != null) {
                        str = str + " " + MMRResourceAccessor.getInstance().getMessageText("2605", new Object[]{e_ro.toString()});
                    }
                    if (e_o != null) {
                        str = str + " " + MMRResourceAccessor.getInstance().getMessageText("2606", new Object[]{e_o});
                    }
                    Repository.getCategory().errorT(location, "verifyObjects(Collection objects)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0003"), new Object[]{e.toString() + ", " + str});
                }
            }
        }
        return colFailed;
    }

    public MofPackage selectMofPackageRootM2() {
        if (this.mofPackageRootM2 == null) {
            this.mofPackageRootM2 = this.getRepositoryServer().selectMofPackageRootM2(this.connection);
            if (this.mofPackageRootM2 != null) {
                ((IModelElement)this.mofPackageRootM2).setRepository(this.repository);
                LinkedList<MofPackage> list = new LinkedList<MofPackage>();
                list.add(this.mofPackageRootM2);
                this.insertM2Cache(list);
            }
        }
        return this.mofPackageRootM2;
    }

    public Collection resolveFilesM2(ModelElement modelElement) {
        Collection c = null;
        try {
            c = this.getRepositoryServer().resolveFilesM2(this.connection, modelElement);
        }
        catch (BaseRuntimeException e) {
            e.log();
            c = null;
        }
        catch (BaseException e) {
            e.log();
            c = null;
        }
        return c;
    }

    public Collection resolveFilesM1(RefObject ro) {
        Collection c = null;
        try {
            c = this.getRepositoryServer().resolveFilesM1(this.connection, ro);
        }
        catch (BaseRuntimeException e) {
            e.log();
            c = null;
        }
        catch (BaseException e) {
            e.log();
            c = null;
        }
        return c;
    }

    public List queryM2(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        List l = null;
        try {
            l = this.getRepositoryServer().queryM2(this.connection, qualifiedNameOfType, filters, includeSubTypes);
        }
        catch (BaseRuntimeException e) {
            e.log();
            l = null;
        }
        catch (BaseException e) {
            e.log();
            l = null;
        }
        LinkedList found = new LinkedList();
        if (l != null && l.size() > 0) {
            LinkedList<String> mofIds = new LinkedList<String>();
            Iterator iter1 = l.iterator();
            while (iter1.hasNext()) {
                String mofId = (String)iter1.next();
                mofIds.clear();
                mofIds.add(mofId);
                Collection col = this.selectM2(mofIds, false);
                found.addAll(col);
            }
        }
        this.queryM2Memory(qualifiedNameOfType, filters, includeSubTypes, found);
        if (found != null) {
            Iterator iter = found.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof RefClass) && !(o instanceof RefPackage)) continue;
                iter.remove();
            }
        }
        return found;
    }

    public List queryM1(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        List l = null;
        try {
            l = this.getRepositoryServer().queryM1(this.connection, qualifiedNameOfType, filters, includeSubTypes);
        }
        catch (BaseRuntimeException e) {
            e.log();
            l = null;
        }
        catch (BaseException e) {
            e.log();
            l = null;
        }
        LinkedList found = new LinkedList();
        if (l != null && l.size() > 0) {
            LinkedList<String> mofIds = new LinkedList<String>();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                String mofId = (String)iter.next();
                mofIds.clear();
                mofIds.add(mofId);
                Collection col = this.selectM1(mofIds, false);
                if (col == null || col.size() <= 0) continue;
                found.addAll(col);
            }
        }
        this.queryM1Memory(qualifiedNameOfType, filters, includeSubTypes, found);
        if (found != null) {
            Iterator iter = found.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof RefClass) && !(o instanceof RefPackage)) continue;
                iter.remove();
            }
        }
        return found;
    }

    private void queryM1Memory(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes, List found) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = found.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof RefObject)) continue;
            map.put(((RefObject)o).refMofId(), o);
        }
        List c = AttributesValues.queryCollection(this.cacheM1.values(), qualifiedNameOfType, filters);
        if (c != null) {
            iter = c.iterator();
            while (iter.hasNext()) {
                IMMRObject mmri = (IMMRObject)iter.next();
                map.put(mmri.get___MofId(), mmri);
            }
        }
        found.clear();
        found.addAll(map.values());
    }

    private void queryM2Memory(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes, List found) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = found.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ModelElement)) continue;
            map.put(((ModelElement)o).refMofId(), o);
        }
        List c = AttributesValues.queryCollection(this.cacheM2.values(), qualifiedNameOfType, filters);
        if (c != null) {
            iter = c.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                map.put(me.refMofId(), me);
            }
        }
        found.clear();
        found.addAll(map.values());
    }

    public Hierarchy createHierarchy(int mofLayer, String name) {
        Hierarchy h = this.getHierarchyByName(mofLayer, name);
        if (h == null) {
            h = new Hierarchy(null, mofLayer, name);
        }
        if (h != null) {
            ((HashMap)this.cacheHierarchy.get(mofLayer)).put(h.getMofId(), h);
        }
        return h;
    }

    public Hierarchy getHierarchy(int mofLayer, String mofId) {
        Hierarchy h = null;
        try {
            switch (mofLayer) {
                case 1: {
                    h = this.getRepositoryServer().getHierarchyM1(this.connection, mofId);
                    break;
                }
                case 0: {
                    h = this.getRepositoryServer().getHierarchyM0(this.connection, mofId);
                    break;
                }
                default: {
                    h = null;
                    break;
                }
            }
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        if (h != null) {
            ((HashMap)this.cacheHierarchy.get(mofLayer)).put(h.getMofId(), h);
            h.setChanged(false, true);
        }
        return h;
    }

    public Hierarchy getHierarchyByName(int mofLayer, String name) {
        Hierarchy h = null;
        try {
            switch (mofLayer) {
                case 1: {
                    h = this.getRepositoryServer().getHierarchyM1ByName(this.connection, name);
                    break;
                }
                case 0: {
                    h = this.getRepositoryServer().getHierarchyM0ByName(this.connection, name);
                    break;
                }
                default: {
                    h = null;
                    break;
                }
            }
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        if (h != null) {
            ((HashMap)this.cacheHierarchy.get(mofLayer)).put(h.getMofId(), h);
            h.setChanged(false, true);
        }
        return h;
    }

    public boolean runTask(String classNameOfTask, Map properties) {
        Collection col;
        if (this.modelElementsForTask != null && this.modelElementsForTask.size() > 0) {
            if (properties.containsKey("collectionM2")) {
                col = (Collection)properties.get("collectionM2");
                col.addAll(this.modelElementsForTask);
            } else {
                properties.put("collectionM2", this.modelElementsForTask);
            }
        }
        if (this.objectsForTask != null && this.objectsForTask.size() > 0) {
            if (properties.containsKey("collectionM1")) {
                col = (Collection)properties.get("collectionM1");
                col.addAll(this.objectsForTask);
            } else {
                properties.put("collectionM1", this.objectsForTask);
            }
        }
        if (this.modelElementsDeletedForTask != null && this.modelElementsDeletedForTask.size() > 0) {
            if (properties.containsKey("collectionM2Deleted")) {
                col = (Collection)properties.get("collectionM2Deleted");
                col.addAll(this.modelElementsDeletedForTask);
            } else {
                properties.put("collectionM2Deleted", this.modelElementsDeletedForTask);
            }
        }
        if (this.objectsDeletedForTask != null && this.objectsDeletedForTask.size() > 0) {
            if (properties.containsKey("collectionM1Deleted")) {
                col = (Collection)properties.get("collectionM1Deleted");
                col.addAll(this.objectsDeletedForTask);
            } else {
                properties.put("collectionM1Deleted", this.objectsDeletedForTask);
            }
        }
        return this.getRepositoryServer().runTask(this.connection, classNameOfTask, properties);
    }

    private ModelElement isValidQualifiedName(String qualifiedName) {
        Object me;
        block6: {
            me = this.cacheQualifiedName.get(qualifiedName);
            if (me == null) {
                try {
                    List qn = Utilities.getUtilities().decodeQualifiedName(qualifiedName);
                    me = this.selectMofPackageRootM2().resolveQualifiedName(qn);
                    if (me == null) {
                        this.cacheQualifiedName.put(qualifiedName, qualifiedName);
                        break block6;
                    }
                    this.cacheQualifiedName.put(qualifiedName, me);
                }
                catch (NameNotResolvedException e1) {
                    this.cacheQualifiedName.put(qualifiedName, qualifiedName);
                }
            } else if (me instanceof String) {
                me = null;
            }
        }
        return (ModelElement)me;
    }

    public RefPackage refPackageM1(String packageName) {
        ModelElement me = this.isValidQualifiedName(packageName);
        if (me == null || !(me instanceof MofPackage)) {
            return null;
        }
        RefPackageImpl rp = null;
        String javaName = null;
        try {
            javaName = GeneratorPackage.getJavaInterfaceNameQualified((MofPackage)me);
            rp = (RefPackage)Instantiator.getInstantiator().createInstance(this.repository, javaName, null, true);
        }
        catch (Exception e) {
            rp = null;
        }
        if (rp == null) {
            rp = new RefPackageImpl(this.repository);
        }
        if (rp != null) {
            if (rp instanceof IMMRObject) {
                try {
                    MofPackage mp = (MofPackage)this.selectMofPackageRootM2().resolveQualifiedName(Utilities.getUtilities().decodeQualifiedName(packageName));
                    Namespace container = mp.getContainer();
                    RefPackage ip = null;
                    if (container == null || container.equals(this.selectMofPackageRootM2())) {
                        ip = null;
                    } else {
                        String immediatePackage = Utilities.getUtilities().encodeQualifiedName(container.getQualifiedName());
                        ip = this.refPackageM1(immediatePackage);
                    }
                    ((IMMRObject)rp).set___QualifiedName(packageName);
                    ((IMMRObject)rp).set___ImmediatePackage(ip);
                }
                catch (NameNotResolvedException e) {
                    Repository.category.errorT(location, e.toString());
                }
            }
            LinkedList<RefPackageImpl> l = new LinkedList<RefPackageImpl>();
            l.add(rp);
            this.insertM1(l);
        }
        return rp;
    }

    public void refDeleteM1(RefPackage refPackage) {
        LinkedList<Object> colDelete = new LinkedList<Object>();
        Iterator ic = refPackage.refAllClasses().iterator();
        while (ic.hasNext()) {
            RefClass rc = (RefClass)ic.next();
            ((IRefClass)rc).deleteInstances();
            colDelete.add(rc);
        }
        Iterator ia = refPackage.refAllAssociations().iterator();
        while (ia.hasNext()) {
            RefAssociation ra = (RefAssociation)ia.next();
            colDelete.add(ra);
        }
        Iterator ip = refPackage.refAllPackages().iterator();
        while (ip.hasNext()) {
            RefPackage rp = (RefPackage)ip.next();
            this.refDeleteM1(rp);
        }
        colDelete.add(refPackage);
        this.deleteM1(colDelete);
    }

    public RefAssociation refAssociationM1(String associationName) {
        RefAssociation ra = null;
        ModelElement me = this.isValidQualifiedName(associationName);
        if (me == null || !(me instanceof Association)) {
            return null;
        }
        try {
            String javaName = GeneratorAssociation.getJavaInterfaceNameQualified((Association)me);
            ra = (RefAssociation)Instantiator.getInstantiator().createInstance(this.repository, javaName, null, true);
            if (ra == null) {
                ra = new RefAssociationImpl(this.repository);
                ((RefAssociationImpl)ra).setMofLayer(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ra = null;
        }
        if (ra != null) {
            if (ra instanceof IMMRObject) {
                try {
                    Association assoc = (Association)this.selectMofPackageRootM2().resolveQualifiedName(Utilities.getUtilities().decodeQualifiedName(associationName));
                    Namespace container = assoc.getContainer();
                    RefPackage ip = null;
                    if (container == null || container.equals(this.selectMofPackageRootM2())) {
                        ip = null;
                    } else {
                        String immediatePackage = Utilities.getUtilities().encodeQualifiedName(container.getQualifiedName());
                        ip = this.refPackageM1(immediatePackage);
                    }
                    ((IMMRObject)ra).set___QualifiedName(associationName);
                    ((IMMRObject)ra).set___ImmediatePackage(ip);
                }
                catch (NameNotResolvedException e) {
                    Repository.category.errorT(location, e.toString());
                }
            }
            LinkedList<RefAssociation> l = new LinkedList<RefAssociation>();
            l.add(ra);
            this.repository.insertM1(l);
        }
        return ra;
    }

    public RefClass refClassM1(String typeName) {
        RefClass rc = null;
        ModelElement me = this.isValidQualifiedName(typeName);
        if (me == null || !(me instanceof MofClass)) {
            return null;
        }
        try {
            String javaName = GeneratorClass.getJavaInterfaceNameQualified((MofClass)me);
            rc = (RefClass)Instantiator.getInstantiator().createInstance(this.repository, javaName, null, true);
            if (rc == null) {
                rc = new MMRClass(this.repository, typeName);
            }
        }
        catch (Exception e) {
            rc = null;
        }
        if (rc != null) {
            if (rc instanceof IMMRObject) {
                try {
                    MofClass assoc = (MofClass)this.selectMofPackageRootM2().resolveQualifiedName(Utilities.getUtilities().decodeQualifiedName(typeName));
                    Namespace container = assoc.getContainer();
                    RefPackage ip = null;
                    if (container == null || container.equals(this.selectMofPackageRootM2())) {
                        ip = null;
                    } else {
                        String immediatePackage = Utilities.getUtilities().encodeQualifiedName(container.getQualifiedName());
                        ip = this.refPackageM1(immediatePackage);
                    }
                    ((IMMRObject)rc).set___QualifiedName(typeName);
                    ((IMMRObject)rc).set___ImmediatePackage(ip);
                }
                catch (NameNotResolvedException e) {
                    Repository.category.errorT(location, e.toString());
                }
            }
            LinkedList<RefClass> l = new LinkedList<RefClass>();
            l.add(rc);
            this.repository.insertM1(l);
        }
        return rc;
    }

    public RefStruct refCreateStructM1(String structName, List params) throws TypeMismatchException {
        int n;
        ModelElement meStruct = this.isValidQualifiedName(structName);
        RefStruct rs = null;
        String javaName = null;
        try {
            javaName = meStruct == null ? Generator.correctQualifiedName(structName) : GeneratorStructureType.getJavaInterfaceNameQualified((StructureType)meStruct);
            rs = (RefStruct)Instantiator.getInstantiator().createInstance(this.repository, javaName, params, true);
        }
        catch (Exception e) {
            rs = null;
        }
        if (rs == null && (n = structName.lastIndexOf(46)) > 0) {
            String clName = structName.substring(0, n);
            List qn = Utilities.getUtilities().decodeQualifiedName(clName);
            try {
                ModelElement me = this.selectMofPackageRootM2().resolveQualifiedName(qn);
                if (me instanceof MofClass) {
                    int n1 = clName.lastIndexOf(46);
                    String sName = clName;
                    if (n1 > 0) {
                        sName = clName.substring(0, n1) + '.' + structName.substring(n + 1);
                    }
                    if ((rs = this.refCreateStructM1(sName, params)) != null) {
                        return rs;
                    }
                }
            }
            catch (NameNotResolvedException e1) {
                rs = null;
            }
        }
        if (rs == null) {
            String s = "[";
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o != null) {
                    s = s + "(";
                    s = s + o.getClass().getName();
                    s = s + ")";
                    s = s + o.toString();
                } else {
                    s = s + "null";
                }
                if (!iter.hasNext()) continue;
                s = s + ",";
            }
            s = s + "]";
            throw new TypeMismatchException(null, (Object)structName, null);
        }
        LinkedList<RefStruct> l = new LinkedList<RefStruct>();
        l.add(rs);
        this.repository.insertM1(l);
        return rs;
    }

    public byte[] loadJavaClass(String className) {
        return this.getRepositoryServer().loadJavaClass(className);
    }

    public byte[] loadJavaClass(String className, Set workspaces) {
        return this.getRepositoryServer().loadJavaClass(className, workspaces);
    }

    public Collection synchronizeWorkspaces(IConnection conSource, IRepositoryConst.SynchronizationMode mode) {
        int COMMIT_AT = 10;
        LinkedList<InstanceAndProperties> colCopied = new LinkedList<InstanceAndProperties>();
        try {
            this.getRepositoryServer().transactionBegin(conSource);
            this.getRepositoryServer().transactionBegin(this.connection);
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        if (mode == IRepositoryConst.SynchronizationMode.MODE_COPY) {
            this.getRepositoryServer().deleteM1All(this.connection);
            try {
                this.getRepositoryServer().transactionCommit(this.connection);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        Collection types = null;
        try {
            types = this.getRepositoryServer().selectM1AllClasses(conSource);
        }
        catch (BaseRuntimeException e1) {
            e1.log();
        }
        catch (BaseException e1) {
            e1.log();
        }
        if (types != null) {
            IProgressMonitor pmOverall = conSource.getConnectionSpec().getPmOverall();
            if (pmOverall != null) {
                pmOverall.setMinimum(0);
                pmOverall.setMaximum(types.size());
            }
            int nTypes = 0;
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                IProgressMonitor pm;
                String type = (String)iter.next();
                ArrayList<RefBaseObject> listUpdateSource = new ArrayList<RefBaseObject>();
                ArrayList<RefBaseObject> listUpdateTarget = new ArrayList<RefBaseObject>();
                LinkedList<String> mofIds = new LinkedList<String>();
                if (pmOverall != null) {
                    pmOverall.setProgress(++nTypes);
                }
                if (mode == IRepositoryConst.SynchronizationMode.MODE_COPY) {
                    if (pmOverall != null) {
                        pmOverall.setNote("Select all instances of: " + type);
                    }
                    try {
                        Collection col = this.getRepositoryServer().selectM1AllOfClass(conSource, Utilities.getUtilities().decodeQualifiedName(type));
                        if (col != null) {
                            listUpdateTarget.addAll(col);
                        }
                    }
                    catch (BaseRuntimeException e) {
                        e.log();
                    }
                    catch (BaseException e) {
                        e.log();
                    }
                } else {
                    try {
                        Collection col;
                        String tsTarget;
                        String tsSource;
                        Collection col2;
                        int index;
                        IProgressMonitor pm2;
                        if (pmOverall != null) {
                            pmOverall.setNote("Get list of instances in target of: " + type);
                        }
                        ListInstanceInfo liiTarget = this.getRepositoryServer().selectM1InstanceInfos(this.connection, Utilities.getUtilities().decodeQualifiedName(type), "*");
                        Iterator i = liiTarget.iterator();
                        while (i.hasNext()) {
                            String qn;
                            ListInstanceInfo.InstanceInfo ii = (ListInstanceInfo.InstanceInfo)i.next();
                            if (ii.getInstance() == null || (qn = this.getRepositoryServer().getQualifiedNameM1(conSource, ii.getInstance())) == null) continue;
                            ii.setQualifiedName(qn);
                            conSource.putMofIdAndQualifiedName(ii.getMofId(), ii.getQualifiedName());
                        }
                        if (pmOverall != null) {
                            pmOverall.setNote("Get list of instances in source: " + type);
                        }
                        ListInstanceInfo liiSource = this.getRepositoryServer().selectM1InstanceInfos(conSource, Utilities.getUtilities().decodeQualifiedName(type), "*");
                        if (pmOverall != null) {
                            pmOverall.setNote("Determine differences source -> target: " + type);
                        }
                        if ((pm2 = conSource.getConnectionSpec().getPmDetail()) != null) {
                            pm2.setMinimum(0);
                            pm2.setMaximum(liiSource.size());
                        }
                        ListInstanceInfo.InstanceInfoComparator comparator = ListInstanceInfo.getInstanceInfoComparator();
                        Collections.sort(liiSource, comparator);
                        Collections.sort(liiTarget, comparator);
                        int n = 0;
                        Iterator i1 = liiSource.iterator();
                        while (i1.hasNext()) {
                            ListInstanceInfo.InstanceInfo iiTarget;
                            ListInstanceInfo.InstanceInfo iiSource = (ListInstanceInfo.InstanceInfo)i1.next();
                            if (pm2 != null) {
                                pm2.setNote("Process instance " + ++n + " of " + liiSource.size() + ": " + type);
                                pm2.setProgress(n);
                            }
                            if ((index = Collections.binarySearch(liiTarget, iiSource, comparator)) < 0) {
                                if (iiSource.getInstance() != null) {
                                    listUpdateTarget.add(iiSource.getInstance());
                                    continue;
                                }
                                mofIds.clear();
                                mofIds.add(iiSource.getMofId());
                                col2 = this.getRepositoryServer().selectM1(conSource, mofIds, false);
                                if (col2 == null) continue;
                                listUpdateTarget.addAll(col2);
                                continue;
                            }
                            tsSource = iiSource.getLastChangedAt();
                            if (tsSource.compareTo(tsTarget = (iiTarget = (ListInstanceInfo.InstanceInfo)liiTarget.get(index)).getLastChangedAt()) <= 0) continue;
                            if (iiSource.getInstance() != null) {
                                listUpdateTarget.add(iiSource.getInstance());
                                continue;
                            }
                            mofIds.clear();
                            mofIds.add(iiSource.getMofId());
                            col = this.getRepositoryServer().selectM1(conSource, mofIds, false);
                            if (col == null) continue;
                            listUpdateTarget.addAll(col);
                        }
                        if (mode == IRepositoryConst.SynchronizationMode.MODE_SYNCHRONIZE || mode == IRepositoryConst.SynchronizationMode.MODE_COMPARE) {
                            if (pmOverall != null) {
                                pmOverall.setNote("Determine differences target -> source: " + type);
                            }
                            if (pm2 != null) {
                                pm2.setMinimum(0);
                                pm2.setMaximum(liiTarget.size());
                            }
                            n = 0;
                            i1 = liiTarget.iterator();
                            while (i1.hasNext()) {
                                ListInstanceInfo.InstanceInfo iiTarget = (ListInstanceInfo.InstanceInfo)i1.next();
                                if (pm2 != null) {
                                    pm2.setNote("Process instance " + ++n + " of " + liiTarget.size() + ": " + type);
                                    pm2.setProgress(n);
                                }
                                if ((index = Collections.binarySearch(liiSource, iiTarget, comparator)) < 0) {
                                    if (iiTarget.getInstance() != null) {
                                        listUpdateSource.add(iiTarget.getInstance());
                                        continue;
                                    }
                                    mofIds.clear();
                                    mofIds.add(iiTarget.getMofId());
                                    col2 = this.getRepositoryServer().selectM1(this.connection, mofIds, false);
                                    if (col2 == null) continue;
                                    listUpdateSource.addAll(col2);
                                    continue;
                                }
                                tsSource = iiTarget.getLastChangedAt();
                                ListInstanceInfo.InstanceInfo iiSource = (ListInstanceInfo.InstanceInfo)liiSource.get(index);
                                tsTarget = iiSource.getLastChangedAt();
                                if (tsTarget.compareTo(tsSource) <= 0) continue;
                                if (iiTarget.getInstance() != null) {
                                    listUpdateSource.add(iiTarget.getInstance());
                                    continue;
                                }
                                mofIds.clear();
                                mofIds.add(iiTarget.getMofId());
                                col = this.getRepositoryServer().selectM1(this.connection, mofIds, false);
                                if (col == null) continue;
                                listUpdateSource.addAll(col);
                            }
                        }
                    }
                    catch (BaseRuntimeException e) {
                        e.log();
                    }
                    catch (BaseException e) {
                        e.log();
                    }
                }
                if (mode == IRepositoryConst.SynchronizationMode.MODE_COMPARE) continue;
                if (listUpdateTarget.size() > 0) {
                    if (pmOverall != null) {
                        pmOverall.setNote("Read Associations & write into target workspace: " + type);
                    }
                    if ((pm = conSource.getConnectionSpec().getPmDetail()) != null) {
                        pm.setMinimum(0);
                        pm.setMaximum(listUpdateTarget.size());
                    }
                    AssociationsOfObject aoo = null;
                    HashMap<String, AssociationsOfObject> aoos = new HashMap<String, AssociationsOfObject>();
                    LinkedList<RefObject> list = new LinkedList<RefObject>();
                    int n = 0;
                    Iterator i = listUpdateTarget.iterator();
                    while (i.hasNext()) {
                        RefObject ro = (RefObject)i.next();
                        String mofId = ro.refMofId();
                        if (pm != null) {
                            pm.setNote("Process instance " + ++n + " of " + listUpdateTarget.size() + ": " + type);
                            pm.setProgress(n);
                        }
                        try {
                            aoo = this.getRepositoryServer().selectM1Assoc(conSource, null, mofId);
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                        }
                        catch (BaseException e) {
                            e.log();
                        }
                        list.clear();
                        list.add(ro);
                        try {
                            this.getRepositoryServer().insertM1(this.connection, list);
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                        }
                        catch (BaseException e) {
                            e.log();
                        }
                        aoos.clear();
                        if (aoo != null) {
                            aoos.put(aoo.getMofId(), aoo);
                            try {
                                this.getRepositoryServer().insertM1Assoc(this.connection, aoos);
                            }
                            catch (BaseRuntimeException e) {
                                e.log();
                            }
                            catch (BaseException e) {
                                e.log();
                            }
                        }
                        if (n % 10 == 0) {
                            try {
                                this.getRepositoryServer().transactionCommit(this.connection);
                            }
                            catch (BaseRuntimeException e) {
                                e.log();
                            }
                            catch (BaseException e) {
                                e.log();
                            }
                        }
                        InstanceAndProperties iap = new InstanceAndProperties(ro.refMofId(), null, null, SynchronizationState.STATE_EQUAL, (RefBaseObject)ro);
                        if (ro instanceof IMMRObject) {
                            iap.setLastChanged(((IMMRObject)ro).get___LastChangedAt());
                        }
                        colCopied.add(iap);
                    }
                }
                try {
                    this.getRepositoryServer().transactionCommit(this.connection);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
                if (listUpdateSource.size() <= 0) continue;
                if (pmOverall != null) {
                    pmOverall.setNote("Read Associations & write into source workspace: " + type);
                }
                if ((pm = this.connection.getConnectionSpec().getPmDetail()) != null) {
                    pm.setMinimum(0);
                    pm.setMaximum(listUpdateSource.size());
                }
                int n = 0;
                AssociationsOfObject aoo = null;
                HashMap<String, AssociationsOfObject> aoos = new HashMap<String, AssociationsOfObject>();
                Iterator i = listUpdateSource.iterator();
                while (i.hasNext()) {
                    RefObject ro = (RefObject)i.next();
                    String mofId = ro.refMofId();
                    if (pm != null) {
                        pm.setNote("Process instance " + ++n + " of " + listUpdateSource.size() + ": " + type);
                        pm.setProgress(n);
                    }
                    try {
                        aoo = this.getRepositoryServer().selectM1Assoc(this.connection, null, mofId);
                    }
                    catch (BaseRuntimeException e) {
                        e.log();
                    }
                    catch (BaseException e) {
                        e.log();
                    }
                    aoos.clear();
                    if (aoo != null) {
                        aoos.put(mofId, aoo);
                        try {
                            this.getRepositoryServer().insertM1Assoc(conSource, aoos);
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                        }
                        catch (BaseException e) {
                            e.log();
                        }
                    }
                    try {
                        this.getRepositoryServer().insertM1(conSource, listUpdateSource);
                    }
                    catch (BaseRuntimeException e) {
                        e.log();
                    }
                    catch (BaseException e) {
                        e.log();
                    }
                    if (n % 10 == 0) {
                        try {
                            this.getRepositoryServer().transactionCommit(conSource);
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                        }
                        catch (BaseException e) {
                            e.log();
                        }
                    }
                    InstanceAndProperties iap = new InstanceAndProperties(ro.refMofId(), null, null, SynchronizationState.STATE_EQUAL, (RefBaseObject)ro);
                    if (ro instanceof IMMRObject) {
                        iap.setLastChanged(((IMMRObject)ro).get___LastChangedAt());
                    }
                    colCopied.add(iap);
                }
            }
        }
        try {
            this.getRepositoryServer().transactionCommit(this.connection);
            this.getRepositoryServer().transactionCommit(conSource);
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        return colCopied;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModelElemenPairCopy {
        public IModelElement me1;
        public IModelElement me2;

        public ModelElemenPairCopy(IModelElement me1, IModelElement me2) {
            this.me1 = me1;
            this.me2 = me2;
        }
    }

    protected class ModelElementQualifiedName
    implements Comparable {
        public List qualifiedName;
        public String qualifiedNameString;
        public ModelElementImpl modelElement;

        public ModelElementQualifiedName(ModelElementImpl modelElement) {
            this.modelElement = modelElement;
            this.initialize();
        }

        private void initialize() {
            this.qualifiedName = this.modelElement.getQualifiedName();
            this.qualifiedNameString = Utilities.getUtilities().encodeQualifiedName(this.qualifiedName);
        }

        public String getQualifiedName() {
            return this.qualifiedNameString;
        }

        public int getQualifiedNameLength() {
            return this.qualifiedName.size();
        }

        public int compareTo(Object o) {
            int res = 0;
            if (o instanceof ModelElementQualifiedName) {
                int l2;
                int l1 = this.getQualifiedNameLength();
                res = l1 < (l2 = ((ModelElementQualifiedName)o).getQualifiedNameLength()) ? -1 : (l1 > l2 ? 1 : this.getQualifiedName().compareTo(((ModelElementQualifiedName)o).getQualifiedName()));
            }
            return res;
        }
    }

    protected class ObjectWithQualifiedName
    implements Comparable {
        public String qualifiedName;
        public Object object;

        protected ObjectWithQualifiedName() {
        }

        public int compareTo(Object o) {
            int res = 0;
            if (o instanceof ObjectWithQualifiedName) {
                res = this.qualifiedName.compareTo(((ObjectWithQualifiedName)o).qualifiedName);
            }
            return res;
        }
    }
}

