/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.applications;

import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.applications.IProgressMonitor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressMonitorDefault
implements IProgressMonitor {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$applications$ProgressMonitorDefault == null ? (class$com$sap$ip$mmr$applications$ProgressMonitorDefault = ProgressMonitorDefault.class$("com.sap.ip.mmr.applications.ProgressMonitorDefault")) : class$com$sap$ip$mmr$applications$ProgressMonitorDefault);
    private int minimum = 0;
    private int maximum = 100;
    private int progress = this.minimum;
    private long timeStart;
    private long timeProgress;
    private String note = "";
    private OutputStream os = null;
    static final int OUTPUT_MIN = 0;
    static final int OUTPUT_MAX = 50;
    private int outputLastProgress = -1;
    private int lastProgress = -1;
    static /* synthetic */ Class class$com$sap$ip$mmr$applications$ProgressMonitorDefault;

    public ProgressMonitorDefault() {
        this.os = null;
    }

    public ProgressMonitorDefault(OutputStream os) {
        this.os = os;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public String getNote() {
        return this.note;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        if (this.maximum <= this.minimum) {
            this.maximum = this.minimum + 1;
        }
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.timeStart = System.currentTimeMillis();
        this.timeProgress = System.currentTimeMillis();
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setProgress(int progress) {
        if (progress >= this.minimum && progress <= this.maximum) {
            this.progress = progress;
            if (progress == this.minimum) {
                this.timeStart = System.currentTimeMillis();
            }
            this.timeProgress = System.currentTimeMillis();
            this.writeProgress();
        }
    }

    public String getTimeElapsedFormatted() {
        return Utilities.getUtilities().getTimeFormated(this.getTimeElapsed() / 1000L);
    }

    public long getTimeElapsed() {
        return this.timeProgress - this.timeStart;
    }

    public String getTimeLeftFormatted() {
        return Utilities.getUtilities().getTimeFormated(this.getTimeLeft() / 1000L);
    }

    public long getTimeLeft() {
        long t = 0L;
        if (this.progress > this.minimum) {
            t = (long)((float)(this.timeProgress - this.timeStart) * (float)(this.maximum - this.progress) / (float)(this.progress - this.minimum));
        }
        return t;
    }

    public String getTimeInformation() {
        return "time, elapsed: " + this.getTimeElapsedFormatted() + "    time, left (estd): " + this.getTimeLeftFormatted();
    }

    private void writeProgress() {
        if (this.os == null) {
            return;
        }
        int p = (int)((float)this.progress * 50.0f / (float)(this.maximum - this.minimum));
        if (p != this.outputLastProgress || this.progress == this.lastProgress) {
            this.writeProgressBar(0, 50, p);
            this.outputLastProgress = p;
        }
        this.lastProgress = this.progress;
    }

    private void writeProgressBar(int min, int max, int p) {
        if (this.os == null) {
            return;
        }
        try {
            this.os.write(this.getProgressBar(min, max, p).getBytes());
        }
        catch (IOException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    private String getProgressBar(int min, int max, int p) {
        StringBuffer sb = new StringBuffer(max + 2);
        sb.append('|');
        for (int i = min; i < max; ++i) {
            if (i < p) {
                sb.append('+');
                continue;
            }
            if (i == p) {
                sb.append('*');
                continue;
            }
            sb.append('-');
        }
        sb.append('|');
        sb.append(Utilities.SystemLineSeparator);
        sb.append(this.getTimeInformation());
        sb.append(Utilities.SystemLineSeparator);
        sb.append(this.note);
        sb.append(Utilities.SystemLineSeparator);
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

