/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr;

import com.sap.exception.BaseException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.dbmemory.RepositoryDBMemory;
import com.sap.ip.mmr.foundation.AssociationsContainer;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.FilterTypes;
import com.sap.ip.mmr.foundation.HashMapBidirectional;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.Instantiator;
import com.sap.ip.mmr.m1layer.TopLevelPackage;
import com.sap.ip.mmr.m2layer.Collector;
import com.sap.ip.mmr.m2layer.model.ModelPackageImpl;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.ip.mmr.xmi.XmiReader;
import com.sap.ip.mmr.xmi.XmiWriter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.model.NameNotResolvedException;
import javax.jmi.model.Namespace;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.TypeMismatchException;
import javax.jmi.xmi.MalformedXMIException;

public class Repository
implements IRepository {
    public static final String MOF_PACKAGE_M3_ROOT = "MOF_PACKAGE_M3_ROOT";
    public static final String MOF_PACKAGE_M2_ROOT = "MOF_PACKAGE_M2_ROOT";
    public static final String MOF_PACKAGE_M1_ROOT = "MOF_PACKAGE_M1_ROOT";
    public static final Category category = Category.getCategory((Category)Category.APPLICATIONS, (String)"/MMR");
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$Repository == null ? (class$com$sap$ip$mmr$Repository = Repository.class$("com.sap.ip.mmr.Repository")) : class$com$sap$ip$mmr$Repository);
    private static Map connections = new HashMap();
    private IConnection connection = null;
    private IRepositoryServer repositoryServer = null;
    private RepositoryDBMemory repDBmem = null;
    private RefPackage packageTopLevel = null;
    private ModelPackageImpl modelPackageM2 = null;
    private ModelPackageImpl modelPackageM3 = null;
    private String mofPackageRootM2ID = null;
    private String mofPackageRootM1ID = null;
    private boolean contentsOfRootPackageRead = false;
    private static HashMapBidirectional mofIdsQnM1 = new HashMapBidirectional();
    private AssociationsContainer associationsContainerM1 = null;
    private AssociationsContainer associationsContainerM2 = null;
    private AssociationsContainer associationsContainerM3 = null;
    static /* synthetic */ Class class$com$sap$ip$mmr$Repository;

    public static IRepository createInstance(IConnection connection) {
        Repository rep = new Repository(connection);
        if (connection != null) {
            connections.put(connection.getConnectionId(), rep);
        }
        return rep;
    }

    public static IRepository getInstance(IConnection connection) {
        IRepository rep = null;
        if (connection != null) {
            rep = (IRepository)connections.get(connection.getConnectionId());
        }
        if (rep == null) {
            rep = Repository.createInstance(connection);
        }
        return rep;
    }

    public static Category getCategory() {
        return category;
    }

    public static void writeExceptionToCategory(String method, Exception e) {
        category.errorT(location, method, e.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        category.errorT(location, method, baos.toString());
    }

    private Repository(IConnection connection) {
        String method = "Repository(IConnection connection)";
        location.entering("Repository(IConnection connection)");
        this.connection = connection;
        if (connection != null) {
            category.removeLogs();
            category.setEffectiveSeverity(400);
            location.setEffectiveSeverity(400);
            Log log = connection.getConnectionSpec().getLog();
            if (log != null) {
                Repository.getCategory().addLog(log);
            }
        }
        location.exiting("Repository(IConnection connection)");
    }

    private RepositoryDBMemory getRepositoryDBMemory() {
        if (this.repDBmem == null) {
            this.repDBmem = new RepositoryDBMemory(this, this.getRepositoryServer(), this.connection);
        }
        return this.repDBmem;
    }

    public void deleteAllM1() {
        this.packageTopLevel = null;
        this.mofPackageRootM1ID = null;
        this.getRepositoryDBMemory().deleteAllM1();
    }

    public void deleteAllM2() {
        this.modelPackageM2 = null;
        this.mofPackageRootM2ID = null;
        this.getRepositoryDBMemory().deleteAllM2();
    }

    public ModelPackage getTopLevelPackageM2() {
        if (this.modelPackageM2 == null) {
            this.modelPackageM2 = new ModelPackageImpl(this);
        }
        return this.modelPackageM2;
    }

    public ModelPackage getTopLevelPackageM3() {
        if (this.modelPackageM3 == null) {
            this.modelPackageM3 = new com.sap.ip.mmr.m3layer.model.ModelPackageImpl(this);
        }
        return this.modelPackageM3;
    }

    public RefPackage getTopLevelPackageM1() {
        if (this.packageTopLevel == null) {
            this.packageTopLevel = new TopLevelPackage(this);
            ((TopLevelPackage)this.packageTopLevel).set___Repository(this);
        }
        return this.packageTopLevel;
    }

    public MofPackage getMofPackageRootM2() {
        MofPackage mp = this.getRepositoryDBMemory().selectMofPackageRootM2();
        return mp;
    }

    public Collection insertM1(Collection objects) {
        String method = "insertM1(Collection objects)";
        Collection colFailed = null;
        if (objects != null) {
            colFailed = this.getRepositoryDBMemory().insertM1(objects);
        }
        if (colFailed != null) {
            category.errorT(location, "insertM1(Collection objects)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0010"), new Object[]{new Integer(colFailed.size())});
            return colFailed;
        }
        return colFailed;
    }

    public Collection insertM2(Collection modelElements) {
        String method = "insertM2(Collection modelElements)";
        Collection colFailed = null;
        colFailed = this.getRepositoryDBMemory().insertM2(modelElements);
        if (colFailed != null) {
            category.errorT(location, "insertM2(Collection modelElements)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0011"), new Object[]{new Integer(colFailed.size())});
        }
        return colFailed;
    }

    protected void addContent(ModelElement modelElement, Set newMEs) {
        if (modelElement == null) {
            return;
        }
        if (newMEs.contains(modelElement)) {
            return;
        }
        newMEs.add(modelElement);
        if (modelElement instanceof Namespace) {
            Namespace ns = (Namespace)modelElement;
            Iterator iter = ns.getContents().iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                this.addContent(me, newMEs);
            }
        }
        if (modelElement instanceof TypedElement) {
            TypedElement te = (TypedElement)modelElement;
            this.addContent((ModelElement)te.getType(), newMEs);
        }
    }

    public Collection deleteM2(Collection objects, boolean deleteContainedElements) {
        Collection colFailed = null;
        if (objects != null) {
            colFailed = this.getRepositoryDBMemory().deleteM2(objects, deleteContainedElements);
        }
        return colFailed;
    }

    public ModelElement selectM2(String mofId, boolean forUpdate) {
        ModelElement me = null;
        ArrayList<String> mofIds = new ArrayList<String>(1);
        mofIds.add(mofId);
        Collection colFound = this.selectM2(mofIds, forUpdate);
        if (colFound != null) {
            Iterator iter = colFound.iterator();
            while (iter.hasNext() && me == null) {
                me = (ModelElement)iter.next();
            }
        }
        return me;
    }

    public Collection selectM2(Collection mofIds, boolean forUpdate) {
        Collection col = null;
        if (mofIds == null) {
            return null;
        }
        col = this.getRepositoryDBMemory().selectM2(mofIds, forUpdate);
        return col;
    }

    public Collection selectM2AllOfClass(List qualifiedName) {
        Collection col = this.getRepositoryDBMemory().selectM2AllOfClass(qualifiedName);
        return col;
    }

    public ModelElement selectM2(MofPackage mofPackage, String name, boolean forUpdate) {
        String method = "selectM2(MofPackage mofPackage,String name,boolean forUpdate";
        ModelElement me = null;
        try {
            List list = Utilities.getUtilities().decodeQualifiedName(name);
            me = this.getMofPackageRootM2().resolveQualifiedName(list);
        }
        catch (NameNotResolvedException e) {
            category.errorT(location, "selectM2(MofPackage mofPackage,String name,boolean forUpdate", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0014"), new Object[]{name});
            me = null;
        }
        return me;
    }

    public List queryAssociationsM2(String mofId, String associationId, int depth) {
        if (mofId == null) {
            return new LinkedList();
        }
        return this.getRepositoryDBMemory().queryAssociationsM2(mofId, associationId, depth);
    }

    public Collection read(InputStream stream, String URI2, RefPackage extent) throws IOException, MalformedXMIException {
        String method = "read(InputStream stream,String URI,javax.jmi.reflect.RefPackage extent))";
        if (stream == null) {
            category.errorT(location, "read(InputStream stream,String URI,javax.jmi.reflect.RefPackage extent))", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0012"));
            return null;
        }
        XmiReader xmiReader = new XmiReader(this);
        Collection col = null;
        if (extent != null) {
            col = xmiReader.read(stream, this.enhanceURI(URI2), extent);
        }
        return col;
    }

    public Collection read(String URI2, RefPackage extent) throws IOException, MalformedXMIException {
        String method = "read(String URI, javax.jmi.reflect.RefPackage extent)";
        XmiReader xmiReader = new XmiReader(this);
        if (URI2 == null) {
            category.errorT(location, "read(String URI, javax.jmi.reflect.RefPackage extent)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0013"));
            return null;
        }
        Collection col = null;
        if (extent != null) {
            col = xmiReader.read(this.enhanceURI(URI2), extent);
        }
        return col;
    }

    public void write(OutputStream stream, RefPackage extent, String xmiVersion) throws IOException {
        XmiWriter xmiWriter = new XmiWriter(this.connection);
        xmiWriter.write(stream, extent, xmiVersion);
    }

    public void write(OutputStream stream, Collection objects, String xmiVersion) throws IOException {
        XmiWriter xmiWriter = new XmiWriter(this.connection);
        xmiWriter.write(stream, objects, xmiVersion);
    }

    private String enhanceURI(String URI2) {
        if (URI2 == null) {
            return null;
        }
        String uri = URI2;
        if (URI2.indexOf("http") != 0 && URI2.indexOf("jar") != 0) {
            uri = "file:" + URI2;
        }
        return uri;
    }

    public static String createMofId() {
        return Utilities.getUtilities().getGUID().substring(0, 32);
    }

    public boolean beginTransaction(boolean writeAccess) {
        this.getMofPackageRootM2();
        return this.getRepositoryDBMemory().transactionBegin();
    }

    public boolean endTransaction(boolean rollback) {
        boolean flag = true;
        if (rollback) {
            flag = this.getRepositoryDBMemory().rollback();
            if (this.associationsContainerM1 != null) {
                this.associationsContainerM1.rollback();
            }
            if (this.associationsContainerM2 != null) {
                this.associationsContainerM2.rollback();
            }
        } else {
            flag = this.getRepositoryDBMemory().commit();
            if (this.associationsContainerM1 != null) {
                this.associationsContainerM1.commit();
            }
            if (this.associationsContainerM2 != null) {
                this.associationsContainerM2.commit();
            }
        }
        return flag;
    }

    public boolean endTransaction(Collection collection, boolean rollback) {
        boolean flag = true;
        if (rollback) {
            Collection col = this.getRepositoryDBMemory().rollback(collection);
            if (col != null) {
                flag = false;
            }
            if (this.associationsContainerM1 != null) {
                this.associationsContainerM1.rollback();
            }
            if (this.associationsContainerM2 != null) {
                this.associationsContainerM2.rollback();
            }
        } else {
            Collection col = this.getRepositoryDBMemory().commit(collection);
            if (col != null) {
                flag = false;
            }
            if (this.associationsContainerM1 != null) {
                this.associationsContainerM1.commit();
            }
            if (this.associationsContainerM2 != null) {
                this.associationsContainerM2.commit();
            }
        }
        return flag;
    }

    public List queryElementsM2(Collection elementSearch, String associationId, FilterTypes filterTypes, int searchDepth, boolean sortResult, Set treeResult) {
        Collector collector = new Collector(this);
        if (!this.contentsOfRootPackageRead) {
            this.getMofPackageRootM2().getContents();
            this.contentsOfRootPackageRead = true;
        }
        return collector.queryElements(elementSearch, associationId, filterTypes, searchDepth, sortResult, treeResult);
    }

    public Collection deleteM1(Collection objects) {
        Collection colFailed = null;
        if (objects != null) {
            colFailed = this.getRepositoryDBMemory().deleteM1(objects);
        }
        return colFailed;
    }

    public Collection selectM1(Collection mofIdsOrObjects, boolean forUpdate) {
        Collection col = this.getRepositoryDBMemory().selectM1(mofIdsOrObjects, forUpdate);
        return col;
    }

    public RefBaseObject selectM1(String mofId, boolean forUpdate) {
        ArrayList<String> mofIds = new ArrayList<String>(1);
        mofIds.add(mofId);
        Collection col = this.selectM1(mofIds, forUpdate);
        RefObject ro = null;
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext() && ro == null) {
                ro = (RefObject)iter.next();
            }
        }
        return ro;
    }

    public IMMRObject selectM1ByName(String type, List args, List instantiators, boolean forUpdate) {
        return this.getRepositoryDBMemory().selectM1ByName(type, args, instantiators, forUpdate);
    }

    public Collection selectM1AllOfClass(List qualifiedName) {
        Collection col = this.getRepositoryDBMemory().selectM1AllOfClass(qualifiedName);
        return col;
    }

    public RefBaseObject select(int mofLayer, String mofId, boolean forUpdate) {
        RefObject ro = null;
        switch (mofLayer) {
            case 0: {
                break;
            }
            case 1: {
                ro = this.selectM1(mofId, forUpdate);
                break;
            }
            case 2: {
                ro = this.selectM2(mofId, forUpdate);
                break;
            }
            default: {
                ro = this.selectM3(mofId);
            }
        }
        return ro;
    }

    public Object createInstanceM1(String nameClass, List args, boolean noMessage) {
        IMMRObject o = (IMMRObject)Instantiator.getInstantiator().createInstance(this, nameClass, args, noMessage);
        o.set___CreatedBy(this.getConnection().getConnectionSpec().getUserName());
        o.set___CreatedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
        o.set___LastChangedBy(this.getConnection().getConnectionSpec().getUserName());
        o.set___LastChangedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
        o.set___Repository(this);
        o.set___State(StateEnum.STATE_NEW);
        return o;
    }

    public void finalizer() {
        String method = "finalizer()";
        if (this.connection != null) {
            try {
                category.removeLog(this.connection.getConnectionSpec().getLog());
            }
            catch (Exception e) {
                if (e instanceof BaseException) {
                    ((BaseException)((Object)e)).log();
                }
                category.error(location, "finalizer()", (Object)MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
            }
        }
        this.getRepositoryDBMemory().finalizer();
        connections.remove(this.connection.getConnectionId());
        this.connection = null;
        this.repositoryServer = null;
        this.repDBmem = null;
        this.packageTopLevel = null;
        this.modelPackageM2 = null;
        this.mofPackageRootM2ID = null;
        this.mofPackageRootM1ID = null;
        mofIdsQnM1.clear();
    }

    public RefObject selectM3(String mofId) {
        return this.getRepositoryDBMemory().selectM3(mofId);
    }

    public AssociationsOfObject selectAssoc(int mofLayer, String associationId, String mofId) {
        String method = "AssociationsOfObject selectAssoc(int mofLayer,String associationId,String mofId)";
        AssociationsOfObject aoo = null;
        switch (mofLayer) {
            case 3: {
                aoo = this.selectM3Assoc(associationId, mofId);
                break;
            }
            case 2: {
                aoo = this.selectM2Assoc(associationId, mofId);
                break;
            }
            case 1: {
                aoo = this.selectM1Assoc(associationId, mofId);
                break;
            }
            default: {
                category.errorT(location, "AssociationsOfObject selectAssoc(int mofLayer,String associationId,String mofId)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0020"), new Object[]{new Integer(mofLayer)});
            }
        }
        return aoo;
    }

    public AssociationsOfObject selectM3Assoc(String associationId, String mofId) {
        return this.getRepositoryDBMemory().selectM3Assoc(associationId, mofId);
    }

    public AssociationsOfObject selectM2Assoc(String associationId, String mofId) {
        return this.getRepositoryDBMemory().selectM2Assoc(associationId, mofId);
    }

    public AssociationsOfObject selectM1Assoc(String associationId, String mofId) {
        return this.getRepositoryDBMemory().selectM1Assoc(associationId, mofId);
    }

    public RefBaseObject selectByName(int mofLayer, String qualifiedName, boolean forUpdate) {
        String method = "selectByName(int mofLayer,String qualifiedName,boolean forUpdate)";
        RefObject ro = null;
        switch (mofLayer) {
            case 0: {
                break;
            }
            case 1: {
                category.errorT(location, "selectByName(int mofLayer,String qualifiedName,boolean forUpdate)", MMRResourceAccessor.getInstance().getMessageText(this.connection, "0001"));
                ro = null;
                break;
            }
            case 2: {
                ro = this.selectM2ByName(qualifiedName, forUpdate);
                break;
            }
            case 3: {
                ro = this.selectM3ByName(qualifiedName);
                break;
            }
            default: {
                ro = this.selectM3ByName(qualifiedName);
            }
        }
        return ro;
    }

    public ModelElement selectM2ByName(String qualifiedName, boolean forUpdate) {
        ModelElement me = this.getRepositoryDBMemory().selectM2ByName(qualifiedName, forUpdate);
        return me;
    }

    public RefObject selectM3ByName(String qualifiedName) {
        return this.getRepositoryDBMemory().selectM3ByName(qualifiedName);
    }

    public IRepositoryServer getRepositoryServer() {
        if (this.repositoryServer == null) {
            this.repositoryServer = RepositoryServer.getRepositoryServer();
        }
        return this.repositoryServer;
    }

    public List getWorkspacesAvailableM1() {
        List l = this.getRepositoryServer().getWorkspacesAvailableM1(this.connection);
        return l;
    }

    public List getWorkspacesAvailableM2() {
        List l = this.getRepositoryServer().getWorkspacesAvailableM2(this.connection);
        return l;
    }

    public List queryM2(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        List l = this.getRepositoryDBMemory().queryM2(qualifiedNameOfType, filters, includeSubTypes);
        return l;
    }

    public List queryM1(List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        List l = this.getRepositoryDBMemory().queryM1(qualifiedNameOfType, filters, includeSubTypes);
        return l;
    }

    public Hierarchy createHierarchy(int mofLayer, String name) {
        Hierarchy h = this.getRepositoryDBMemory().createHierarchy(mofLayer, name);
        if (h != null) {
            h.setRepository(this);
        }
        return h;
    }

    public Hierarchy getHierarchy(int mofLayer, String mofId) {
        Hierarchy h = this.getRepositoryDBMemory().getHierarchy(mofLayer, mofId);
        if (h != null) {
            h.setRepository(this);
        }
        return h;
    }

    public Hierarchy getHierarchyByName(int mofLayer, String name) {
        Hierarchy h = this.getRepositoryDBMemory().getHierarchyByName(mofLayer, name);
        if (h != null) {
            h.setRepository(this);
        }
        return h;
    }

    public Collection resolveFilesM2(ModelElement modelElement) {
        return this.getRepositoryDBMemory().resolveFilesM2(modelElement);
    }

    public Collection resolveFilesM1(RefObject ro) {
        return this.getRepositoryDBMemory().resolveFilesM1(ro);
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public ModelElement resolveQualifiedNameM2(List qualifiedName) {
        return this.getRepositoryDBMemory().resolveQualifiedNameM2(qualifiedName);
    }

    public Collection selectM2TopLevelPackages() {
        Collection col = this.getRepositoryDBMemory().selectM2TopLevelPackages();
        return col;
    }

    public boolean runTask(String classNameOfTask, Map properties) {
        return this.getRepositoryDBMemory().runTask(classNameOfTask, properties);
    }

    public boolean isNewInstance(int mofLayer, String mofId) {
        return this.getRepositoryDBMemory().isNewInstance(mofLayer, mofId);
    }

    public RefPackage refPackageM1(String packageName) {
        return this.getRepositoryDBMemory().refPackageM1(packageName);
    }

    public RefAssociation refAssociationM1(String associationName) {
        return this.getRepositoryDBMemory().refAssociationM1(associationName);
    }

    public RefClass refClassM1(String typeName) {
        return this.getRepositoryDBMemory().refClassM1(typeName);
    }

    public RefStruct refCreateStructM1(String structureName, List args) throws TypeMismatchException {
        return this.getRepositoryDBMemory().refCreateStructM1(structureName, args);
    }

    public void refDeleteM1(RefPackage refPackage) {
        this.getRepositoryDBMemory().refDeleteM1(refPackage);
    }

    public byte[] loadJavaClass(String className) {
        return this.getRepositoryDBMemory().loadJavaClass(className);
    }

    public byte[] loadJavaClass(String className, Set workspaces) {
        return this.getRepositoryDBMemory().loadJavaClass(className, workspaces);
    }

    public Set getWorkspaces() {
        Set set = this.connection.getConnectionSpec().getWorkspacesM1();
        return set;
    }

    public Collection synchronizeWorkspaces(IConnection conSource, IRepositoryConst.SynchronizationMode mode) {
        Collection col = this.getRepositoryDBMemory().synchronizeWorkspaces(conSource, mode);
        return col;
    }

    public void removeAllLinksM1(RefObject refObject) {
        ((IMMRObject)this.getTopLevelPackageM1()).get___AssociationsContainer().removeAllLinks(refObject);
    }

    public HashMapBidirectional getMappingMofIdsQnM1() {
        return mofIdsQnM1;
    }

    public AssociationsContainer getAssociationsContainer(int mofLayer) {
        AssociationsContainer ac = null;
        switch (mofLayer) {
            case 0: {
                ac = null;
                break;
            }
            case 1: {
                if (this.associationsContainerM1 == null) {
                    this.associationsContainerM1 = new AssociationsContainer(this);
                    this.associationsContainerM1.setMofLayer(mofLayer);
                }
                ac = this.associationsContainerM1;
                break;
            }
            case 2: {
                if (this.associationsContainerM2 == null) {
                    this.associationsContainerM2 = new AssociationsContainer(this);
                    this.associationsContainerM2.setMofLayer(mofLayer);
                }
                ac = this.associationsContainerM2;
                break;
            }
            default: {
                if (this.associationsContainerM3 == null) {
                    this.associationsContainerM3 = new AssociationsContainer(this);
                    this.associationsContainerM3.setMofLayer(mofLayer);
                }
                ac = this.associationsContainerM3;
            }
        }
        return ac;
    }

    public long getTimeLastDeployment() {
        return this.getRepositoryServer().getTimeLastDeployment();
    }

    public void workspaceContentHasChanged(Workspace workspace) {
        this.getRepositoryServer().workspaceContentHasChanged(this.connection, workspace);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

