/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api.umap;

import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class Credentials
implements Cloneable {
    private static final String M_CRED_CLONE = "Credentials.Element.clone()";
    private static final Location _trace = Location.getLocation((String)"com.sap.security.api");
    public static final String P_ALIAS = "Alias";
    public static final String P_INDEX = "Index";
    public static final String P_TYPE = "Type";
    public static final String P_DEFAULT = "Default";
    public static final String P_PROMPT = "Prompt";
    public static final String P_CHOICES = "Choices";
    public static final String P_OBSOLETE = "Obsolete";
    private String mID;
    private HashMap mAttributes;
    private Element[] mElements;
    private static final String[] KNOWN_TYPES = new String[]{"choice", "text", "password"};

    public Credentials(String id, Properties configuration, String namespace) throws IllegalArgumentException {
        this.mID = id;
        this.mAttributes = new HashMap();
        this.mElements = ConfParser.getElements(configuration, namespace);
    }

    String getID() {
        return this.mID;
    }

    public Object getAttribute(String key) {
        return this.mAttributes.get(key);
    }

    public boolean setAttribute(String key, Object value) {
        if (this.mAttributes.get(key) == null) {
            this.mAttributes.put(key, value);
            return true;
        }
        return false;
    }

    public Element[] getElements() {
        return this.mElements;
    }

    public Element getElement(String name) {
        int i = 0;
        while (i < this.mElements.length) {
            if (this.mElements[i].name.equals(name)) {
                return this.mElements[i];
            }
            ++i;
        }
        return null;
    }

    public Object clone() {
        Credentials o = null;
        try {
            o = (Credentials)super.clone();
            o.mElements = new Element[this.mElements.length];
            int i = 0;
            while (i < this.mElements.length) {
                o.mElements[i] = (Element)this.mElements[i].clone();
                ++i;
            }
            o.mAttributes.clear();
        }
        catch (CloneNotSupportedException e) {
            _trace.traceThrowableT(300, "Credentials.Element can't clone", (Throwable)e);
        }
        return o;
    }

    public void clear() {
        int i = 0;
        while (i < this.mElements.length) {
            this.mElements[i].value = null;
            ++i;
        }
        this.mAttributes.clear();
    }

    private static class ConfParser {
        private ConfParser() {
        }

        static Element[] getElements(Properties p, String ns) throws IllegalArgumentException {
            Element el;
            HashMap elementMap = new HashMap();
            ArrayList<Element> elementList = new ArrayList<Element>();
            if (!ns.equals("") && !ns.endsWith(".")) {
                ns = ns + ".";
            }
            int nsLen = ns.length();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                StringTokenizer st;
                String key = (String)e.nextElement();
                if (!key.startsWith(ns) || (st = new StringTokenizer(key.substring(nsLen), ".")).countTokens() != 2) continue;
                String name = st.nextToken();
                String suffix = st.nextToken();
                el = ConfParser.createOrGetExisting(elementMap, name);
                String val = p.getProperty(key);
                if (suffix.equals(Credentials.P_TYPE)) {
                    boolean isKnown = false;
                    int i = 0;
                    while (i < KNOWN_TYPES.length) {
                        if (KNOWN_TYPES[i].equalsIgnoreCase(val)) {
                            isKnown = true;
                            el.type = val;
                            break;
                        }
                        ++i;
                    }
                    if (isKnown) continue;
                    throw new IllegalArgumentException("Unknown type: " + val);
                }
                if (suffix.equals(Credentials.P_DEFAULT)) {
                    el.defaultVal = val;
                    continue;
                }
                if (suffix.equals(Credentials.P_PROMPT)) {
                    el.prompt = val;
                    continue;
                }
                if (suffix.equals(Credentials.P_CHOICES)) {
                    Element.access$602(el, ConfParser.csListToArray(val));
                    continue;
                }
                if (suffix.equals(Credentials.P_OBSOLETE)) {
                    el.isObsolete = true;
                    continue;
                }
                if (suffix.equals(Credentials.P_ALIAS)) {
                    el.alias = val;
                    continue;
                }
                if (!suffix.equals(Credentials.P_INDEX)) continue;
                try {
                    el.index = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(key + ": must be numeric");
                }
            }
            HashSet<String> allAliases = new HashSet<String>();
            Set allNames = elementMap.keySet();
            Iterator iter = allNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                el = (Element)elementMap.get(name);
                if (el.isObsolete) {
                    iter.remove();
                    continue;
                }
                if (el.type == null) {
                    iter.remove();
                    continue;
                }
                if (el.defaultVal != null && el.choices != null) {
                    boolean isValid = false;
                    int i = 0;
                    while (i < el.choices.length) {
                        if (el.choices[i].equals(el.defaultVal)) {
                            isValid = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isValid) {
                        throw new IllegalArgumentException("Element " + name + ": Default value (" + el.defaultVal + ") is not an allowed choice");
                    }
                }
                if (el.type.equals("choice") && el.choices == null) {
                    throw new IllegalArgumentException("Element " + name + ": Type " + "choice" + " must have choices");
                }
                if (el.choices != null && !el.type.equals("choice")) {
                    throw new IllegalArgumentException("Element " + name + ": must have type " + "choice" + " since it has choices");
                }
                if (el.alias != null) {
                    if (allNames.contains(el.alias) || allAliases.contains(el.alias)) {
                        throw new IllegalArgumentException("Element " + name + ": ambiguous alias (" + el.alias + ")");
                    }
                    allAliases.add(el.alias);
                }
                elementList.add(el);
            }
            Collections.sort(elementList, new ElementComparator());
            return elementList.toArray(new Element[0]);
        }

        private static Element createOrGetExisting(Map elementMap, String name) {
            Element el = null;
            if (elementMap.containsKey(name)) {
                el = (Element)elementMap.get(name);
            } else {
                el = new Element();
                el.name = name;
                elementMap.put(name, el);
            }
            return el;
        }

        private static String[] csListToArray(String csList) {
            StringTokenizer st = new StringTokenizer(csList, ",");
            String[] ar = new String[st.countTokens()];
            int i = 0;
            while (i < ar.length) {
                ar[i] = st.nextToken();
                ++i;
            }
            return ar;
        }
    }

    private static class ElementComparator
    implements Comparator {
        private ElementComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Element)o1).index - ((Element)o2).index;
        }
    }

    public static class Element
    implements Cloneable {
        public static final String T_CHOICE = "choice";
        public static final String T_TEXT = "text";
        public static final String T_PASSWORD = "password";
        private String name;
        private String alias;
        private String type;
        private String value;
        private String defaultVal;
        private String prompt;
        private String[] choices;
        private boolean isObsolete = false;
        private int index = 0;

        private Element() {
        }

        public Object clone() {
            Object o = null;
            try {
                o = super.clone();
                this.value = null;
            }
            catch (CloneNotSupportedException e) {
                _trace.traceThrowableT(300, "Credentials.Element can't clone", (Throwable)e);
            }
            return o;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias != null ? this.alias : this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value != null ? this.value : this.defaultVal;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public String[] getChoices() {
            return this.choices;
        }

        public boolean setValue(String value) {
            if (this.choices != null) {
                int i = 0;
                while (i < this.choices.length) {
                    if (this.choices[i].equals(value)) {
                        this.value = value;
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            this.value = value;
            return true;
        }

        static /* synthetic */ String[] access$602(Element x0, String[] x1) {
            x0.choices = x1;
            return x1;
        }
    }
}

