/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api.ticket;

import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSParsingException;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class TicketVerifier {
    protected static final int STATE_START = 0;
    protected static final int STATE_INITIALIZED = 1;
    protected static final int STATE_VERIFIED = 2;
    public static final int KEYTYPE_IKS = 0;
    public static final int KEYTYPE_SUN = 2;
    public static final int KEYTYPE_PSE = 3;
    public static final int KEYTYPE_P12 = 1;
    public static final int KEYTYPE_DER = 4;
    public static final int KEYTYPE_P7C = 5;
    protected int state = 0;
    private boolean _enforceVerify = true;

    public abstract void setTicket(String var1) throws Exception;

    public abstract void setTicket(byte[] var1) throws Exception;

    public abstract String getCodepage();

    public abstract String getTicket() throws TicketException;

    public abstract String getUser() throws TicketException;

    public abstract String getSystemID() throws TicketException;

    public abstract String getSystemClient() throws TicketException;

    public abstract InfoUnit getInfoUnit(int var1) throws TicketException;

    public abstract Enumeration getInfoUnits() throws TicketException;

    public String toString() {
        StringBuffer s = new StringBuffer("Ticket ");
        if (this.state == 0) {
            s.append("[not initialized]\n");
        } else if (this.state == 1) {
            s.append("[initialized]\n");
        } else if (this.state == 2) {
            s.append("[verified]\n");
            try {
                s.append("  User = " + this.getUser() + "\n");
                s.append("  Issuing System ID     = " + this.getSystemID() + "\n");
                s.append("  Issuing System Client = " + this.getSystemClient() + "\n");
                Enumeration e = this.getInfoUnits();
                while (e.hasMoreElements()) {
                    InfoUnit unit = (InfoUnit)e.nextElement();
                    s.append("InfoUnit " + unit.getID() + ", length=" + unit.getContent().length);
                }
            }
            catch (TicketException ticketException) {}
        } else {
            s.append("[???]\n");
        }
        return s.toString();
    }

    public abstract void setCertificates(java.security.cert.X509Certificate[] var1);

    public abstract void setCertificates(String var1, char[] var2) throws Exception;

    public abstract X509Certificate getSignerCertificate() throws TicketException;

    protected java.security.cert.X509Certificate[] getCertsFromKeyStore(KeyStore store) throws KeyStoreException {
        Vector<Certificate> certs = new Vector<Certificate>();
        Enumeration<String> enumeration = store.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            if (store.isCertificateEntry(alias)) {
                certs.add(store.getCertificate(alias));
            }
            if (!store.isKeyEntry(alias)) continue;
            Certificate[] certs__ = store.getCertificateChain(alias);
            int i = 0;
            while (i < certs__.length) {
                certs.add(certs__[i]);
                ++i;
            }
        }
        return certs.toArray(new java.security.cert.X509Certificate[0]);
    }

    public boolean isValid() {
        try {
            this.verify();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public abstract void verify() throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, PKCSParsingException, TicketException, Exception;

    public void setEnforceVerify(boolean val) {
        this._enforceVerify = val;
    }

    public boolean isEnforceVerify() {
        return this._enforceVerify;
    }

    public static X509Certificate findCert(X509Certificate[] certs, Name issuer, BigInteger serial) {
        if (certs == null) {
            return null;
        }
        int i = 0;
        while (i < certs.length) {
            if (certs[i].getIssuerDN().equals(issuer) && certs[i].getSerialNumber().equals(serial)) {
                return certs[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean verifyCertificate(X509Certificate[] certs, X509Certificate test, boolean verifyChain) {
        try {
            test.verify();
            test.checkValidity();
            int i = 0;
            while (i < certs.length) {
                if (test.equals(certs[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (certs != null) {
            int i = 0;
            while (i < certs.length) {
                block11: {
                    if (certs[i].getSubjectDN().equals(test.getIssuerDN())) {
                        try {
                            test.verify(certs[i].getPublicKey());
                            test.checkValidity();
                            if (verifyChain) {
                                if (TicketVerifier.verifyCertificate(certs, certs[i], true)) {
                                    return true;
                                }
                                break block11;
                            }
                            return true;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static Name newName(String country, String loc, String org, String orgUnit, String commonName) {
        Name name = new Name();
        if (country != null) {
            name.addRDN(ObjectID.country, (Object)country);
        }
        if (loc != null) {
            name.addRDN(ObjectID.locality, (Object)loc);
        }
        if (org != null) {
            name.addRDN(ObjectID.organization, (Object)org);
        }
        if (orgUnit != null) {
            name.addRDN(ObjectID.organizationalUnit, (Object)orgUnit);
        }
        if (commonName != null) {
            name.addRDN(ObjectID.commonName, (Object)commonName);
        }
        return name;
    }
}

