/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.api;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.api.GenericDummyImplFactory;
import com.sap.security.api.IAuthentication;
import com.sap.security.api.IConfigurable;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IPrincipalFactory;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.ISecurityPolicy;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.acl.IAclManager;
import com.sap.security.api.logon.IAnonymousUserFactory;
import com.sap.security.api.logon.ILogonAuthentication;
import com.sap.security.api.logon.ISecurityPolicyFactory;
import com.sap.security.api.srvUser.IServiceUserFactory;
import com.sap.security.api.ticket.TicketVerifier;
import com.sap.security.api.umap.IUserMapping;
import com.sap.security.api.umap.system.ISystemLandscapeWrapper;
import com.sap.security.api.util.IUMFileIO;
import com.sap.security.api.util.IUMParameters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class UMFactory {
    private static Location loc = Location.getLocation((Class)(class$com$sap$security$api$UMFactory == null ? (class$com$sap$security$api$UMFactory = UMFactory.class$("com.sap.security.api.UMFactory")) : class$com$sap$security$api$UMFactory));
    private static Category cat = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"Usermanagement");
    private static final String PROPFILENAME = "sapum.properties";
    private static final String CFGPATH = "ume.cfg.path";
    private static final String EMPTY_IMPL = "empty";
    private static boolean is_initialized = false;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_api/java/com/sap/security/api/UMFactory.java#6 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static UMFactory _instance;
    private static IUMFileIO _fileio;
    private IAuthentication _authfactory = null;
    private ILogonAuthentication _logonAuthfactory = null;
    private IGroupFactory _groupFactory = null;
    private IUMParameters _properties = null;
    private IRoleFactory _roleFactory = null;
    private IUserAccountFactory _userAccountFactory = null;
    private IUserFactory _userFactory = null;
    private IPrincipalFactory _principalFactory = null;
    private HashMap _aclManagers = new HashMap();
    private IUserMapping _umap = null;
    private IServiceUserFactory _serviceUserFactory = null;
    private IAnonymousUserFactory _anonymousUserFactory = null;
    private ISecurityPolicyFactory _securityPolicyFactory = null;
    private String _databaseVendor = null;
    private boolean _ticketVerifierInitialized = false;
    private ArrayList _systemLandscapeWrappers = null;
    static final Class[] _interfacesForDummy;
    private static SecurityManager _securitymanager;
    private static Object pcdRoleDataSourceClass;
    private static Object pcdLoggerClass;
    static /* synthetic */ Class class$com$sap$security$api$UMFactory;
    static /* synthetic */ Class class$com$sap$security$api$logon$ILogonAuthentication;
    static /* synthetic */ Class class$com$sap$security$api$IGroupFactory;
    static /* synthetic */ Class class$com$sap$security$api$IRoleFactory;
    static /* synthetic */ Class class$com$sap$security$api$IUserAccountFactory;
    static /* synthetic */ Class class$com$sap$security$api$IUserFactory;
    static /* synthetic */ Class class$com$sap$security$api$IPrincipalFactory;
    static /* synthetic */ Class class$com$sap$security$api$srvUser$IServiceUserFactory;
    static /* synthetic */ Class class$com$sap$security$api$logon$IAnonymousUserFactory;
    static /* synthetic */ Class class$com$sap$security$api$logon$ISecurityPolicyFactory;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;

    private UMFactory(Properties prop, HashMap fileset, IUMFileIO fileio) {
        try {
            Class<?> myClass = Class.forName("com.sap.security.core.util.imp.UMParameters", true, UMFactory.getmyClassLoader());
            IUMParameters params = (IUMParameters)myClass.newInstance();
            params.init(prop, fileset);
            this._properties = params;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("initUMFactory failed.");
        }
        _fileio = fileio;
        is_initialized = true;
    }

    public static synchronized ILogonAuthentication getLogonAuthenticator() {
        if (UMFactory.getInstance()._authfactory == null && UMFactory.getInstance()._logonAuthfactory == null) {
            String className = UMFactory.getInstance()._properties.get("ume.logonAuthenticationFactory", "com.sap.security.core.logon.imp.JUMAuthenticator");
            UMFactory.getInstance()._logonAuthfactory = (ILogonAuthentication)UMFactory.initializeClass(className);
            UMFactory.getInstance()._authfactory = UMFactory.getInstance()._logonAuthfactory;
        }
        return UMFactory.getInstance()._logonAuthfactory;
    }

    public static synchronized IAuthentication getAuthenticator() {
        if (UMFactory.getInstance()._authfactory == null && UMFactory.getInstance()._logonAuthfactory == null) {
            String className = UMFactory.getInstance()._properties.get("ume.authenticationFactory", "com.sap.security.core.logon.imp.JUMAuthenticator");
            UMFactory.getInstance()._authfactory = (IAuthentication)UMFactory.initializeClass(className);
            UMFactory.getInstance()._logonAuthfactory = (ILogonAuthentication)UMFactory.getInstance()._authfactory;
        }
        return UMFactory.getInstance()._authfactory;
    }

    public static synchronized void setClassLoader(ClassLoader loader) {
    }

    private static final ClassLoader getmyClassLoader() {
        return (class$com$sap$security$api$UMFactory == null ? (class$com$sap$security$api$UMFactory = UMFactory.class$("com.sap.security.api.UMFactory")) : class$com$sap$security$api$UMFactory).getClassLoader();
    }

    public static synchronized void setSecurityManager(SecurityManager securitymanager) {
        if (_securitymanager != null) {
            throw new IllegalStateException("securitymanager already set!");
        }
        _securitymanager = securitymanager;
    }

    public static SecurityManager getSecurityManager() {
        return _securitymanager;
    }

    public static IUserFactory getDefaultFactory() {
        return UMFactory.getUserFactory();
    }

    public static synchronized IUserMapping getUserMapping() {
        if (UMFactory.getInstance()._umap == null) {
            String className = UMFactory.getInstance()._properties.get("userMapping", "com.sap.security.core.umap.imp.UserMapping");
            UMFactory.getInstance()._umap = (IUserMapping)UMFactory.instantiateClass(className);
        }
        return UMFactory.getInstance()._umap;
    }

    public static synchronized IGroupFactory getGroupFactory() {
        if (UMFactory.getInstance()._groupFactory == null) {
            String className = UMFactory.getInstance()._properties.get("groupFactory", "com.sap.security.core.imp.GroupFactory");
            UMFactory.getInstance()._groupFactory = (IGroupFactory)UMFactory.initializeClass(className);
        }
        return UMFactory.getInstance()._groupFactory;
    }

    public static IUMFileIO getUMFileIO() {
        return _fileio;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getByteArray(InputStream tmp) {
        byte[] ret;
        String mn = "getByteArray(InputStream tmp)";
        if (tmp == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int val;
            while ((val = tmp.read()) != -1) {
                void var4_3;
                bout.write((int)var4_3);
            }
            tmp.close();
            ret = bout.toByteArray();
            bout.close();
        }
        catch (IOException e) {
            LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e);
            ret = null;
        }
        return ret;
    }

    private static String[] scandir() {
        NoBak filter = new NoBak();
        File dir = new File(System.getProperty(CFGPATH));
        return dir.list(filter);
    }

    private static UMFactory loadPropAndFiles() {
        String mn = "loadPropAndFiles()";
        Properties props = new Properties();
        String path = System.getProperty(CFGPATH);
        String filename = path + File.separator + PROPFILENAME;
        try {
            FileInputStream f = new FileInputStream(filename);
            if (f != null) {
                props.load(f);
                f.close();
            }
        }
        catch (FileNotFoundException e) {
            LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e);
            System.err.println("No property file at: " + path);
            return null;
        }
        catch (IOException e) {
            LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e);
            System.err.println("No property file at: " + path);
            return null;
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        String[] xmlnames = UMFactory.scandir();
        int i = 0;
        while (i < xmlnames.length) {
            if (!xmlnames[i].equals(PROPFILENAME)) {
                File orig = new File(path + File.separator + xmlnames[i]);
                try {
                    FileInputStream tmp = new FileInputStream(orig);
                    if (tmp != null) {
                        files.put(xmlnames[i], UMFactory.getByteArray(tmp));
                        ((InputStream)tmp).close();
                    }
                }
                catch (FileNotFoundException e) {
                    LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e);
                }
                catch (IOException e2) {
                    LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e2);
                }
            }
            ++i;
        }
        return new UMFactory(props, files, new FileSystemIO(path));
    }

    public static UMFactory getInstance() {
        if (_instance == null) {
            String path = System.getProperty(CFGPATH);
            if (path == null || path.equals("")) {
                throw new IllegalStateException("Could not initialize UMFactory! Please set property 'ume.cfg.path' or call UMFactory.initialize() first");
            }
            _instance = UMFactory.loadPropAndFiles();
            if (_instance == null) {
                throw new IllegalStateException("Could not initialize UMFactory! Please set property 'ume.cfg.path' or call UMFactory.initialize() first");
            }
        }
        return _instance;
    }

    public static synchronized IUMParameters getProperties() {
        return UMFactory.getInstance()._properties;
    }

    public static synchronized IRoleFactory getRoleFactory() {
        if (UMFactory.getInstance()._roleFactory == null) {
            String className = UMFactory.getInstance()._properties.get("roleFactory", "com.sap.security.core.imp.RoleFactory");
            UMFactory.getInstance()._roleFactory = (IRoleFactory)UMFactory.initializeClass(className);
        }
        return UMFactory.getInstance()._roleFactory;
    }

    public static synchronized IUserAccountFactory getUserAccountFactory() {
        if (UMFactory.getInstance()._userAccountFactory == null) {
            String className = UMFactory.getInstance()._properties.get("userAccountFactory", "com.sap.security.core.imp.UserAccountFactory");
            UMFactory.getInstance()._userAccountFactory = (IUserAccountFactory)UMFactory.initializeClass(className);
        }
        return UMFactory.getInstance()._userAccountFactory;
    }

    public static synchronized IPrincipalFactory getPrincipalFactory() {
        if (UMFactory.getInstance()._principalFactory == null) {
            String className = UMFactory.getInstance()._properties.get("principalFactory", "com.sap.security.core.imp.PrincipalFactory");
            UMFactory.getInstance()._principalFactory = (IPrincipalFactory)UMFactory.initializeClass(className);
        }
        return UMFactory.getInstance()._principalFactory;
    }

    public static synchronized IUserFactory getUserFactory() {
        if (UMFactory.getInstance()._userFactory == null) {
            String className = UMFactory.getInstance()._properties.get("userFactory", "com.sap.security.core.imp.UserFactory");
            UMFactory.getInstance()._userFactory = (IUserFactory)UMFactory.initializeClass(className);
        }
        return UMFactory.getInstance()._userFactory;
    }

    public static synchronized IServiceUserFactory getServiceUserFactory() {
        if (UMFactory.getInstance()._serviceUserFactory == null) {
            String className = UMFactory.getInstance()._properties.get("serviceUserFactory", "com.sap.security.core.srvUser.imp.ServiceUserFactory");
            UMFactory.getInstance()._serviceUserFactory = (IServiceUserFactory)UMFactory.initializeClass(className);
        }
        return UMFactory.getInstance()._serviceUserFactory;
    }

    public static synchronized IAclManager getAclManager() {
        return UMFactory.getAclManager("default");
    }

    public static synchronized IAclManager getAclManager(String applicationId) {
        IAclManager aclManager = (IAclManager)UMFactory.getInstance()._aclManagers.get(applicationId);
        if (aclManager == null) {
            String className = UMFactory.getInstance()._properties.get("ume.acl.manager", "com.sap.security.core.acl.imp.AclManager");
            aclManager = (IAclManager)UMFactory.initializeClass(className);
            try {
                Method gsm = aclManager.getClass().getMethod("init", Class.forName("java.lang.String"));
                gsm.invoke((Object)aclManager, applicationId);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(" Unable to init class: " + className);
                throw new RuntimeException(" Unable to init class: " + className + e);
            }
            UMFactory.getInstance()._aclManagers.put(applicationId, aclManager);
        }
        return aclManager;
    }

    public static synchronized String[] getAllAclManagers() {
        int size = UMFactory.getInstance()._aclManagers.size();
        String[] aclManagerIDs = new String[size];
        if (size > 0) {
            Iterator it = UMFactory.getInstance()._aclManagers.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                aclManagerIDs[i++] = (String)it.next();
            }
        }
        return aclManagerIDs;
    }

    public static synchronized void initialize(String umeCfgPath) {
        if (_instance == null) {
            String path = umeCfgPath;
            if (path == null || path.equals("")) {
                throw new IllegalArgumentException("Can not initialize UMFactory! Given path is not correct");
            }
            _instance = UMFactory.loadPropAndFiles(path);
            if (_instance == null) {
                throw new IllegalStateException("Can not initialize UMFactory! Given path is not correct");
            }
        }
    }

    private static UMFactory loadPropAndFiles(String umeCfgPath) {
        String mn = "loadPropAndFiles(String umeCfgPath)";
        Properties props = new Properties();
        String path = umeCfgPath;
        String filename = path + File.separator + PROPFILENAME;
        try {
            FileInputStream f = new FileInputStream(filename);
            if (f != null) {
                props.load(f);
                f.close();
            }
        }
        catch (FileNotFoundException e) {
            LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e);
            System.err.println("No property file at: " + path);
            return null;
        }
        catch (IOException e) {
            LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e);
            System.err.println("No property file at: " + path);
            return null;
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        String[] xmlnames = UMFactory.scandir(umeCfgPath);
        int i = 0;
        while (i < xmlnames.length) {
            if (!xmlnames[i].equals(PROPFILENAME)) {
                File orig = new File(path + File.separator + xmlnames[i]);
                try {
                    FileInputStream tmp = new FileInputStream(orig);
                    if (tmp != null) {
                        files.put(xmlnames[i], UMFactory.getByteArray(tmp));
                        ((InputStream)tmp).close();
                    }
                }
                catch (FileNotFoundException e) {
                    LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e);
                }
                catch (IOException e2) {
                    LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)e2);
                }
            }
            ++i;
        }
        return new UMFactory(props, files, new FileSystemIO(path));
    }

    private static String[] scandir(String umeCfgPath) {
        NoBak filter = new NoBak();
        File dir = new File(umeCfgPath);
        return dir.list(filter);
    }

    public static synchronized void initialize(Properties prop, HashMap files, IUMFileIO fileio) {
        if (_instance == null) {
            Class clazz = class$com$sap$security$api$UMFactory == null ? (class$com$sap$security$api$UMFactory = UMFactory.class$("com.sap.security.api.UMFactory")) : class$com$sap$security$api$UMFactory;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new UMFactory(prop, files, fileio);
                    _instance.initializeSecurityManager();
                    _instance.initializeSecStore();
                }
            }
        } else if (prop != null) {
            UMFactory.reinitialize(prop);
        }
    }

    private static void reinitialize(Properties props) {
        if (props != null && ((Hashtable)props).size() > 0) {
            IUMParameters params = UMFactory.getProperties();
            Enumeration newKeys = ((Hashtable)props).keys();
            while (newKeys.hasMoreElements() && params != null) {
                String key = (String)newKeys.nextElement();
                params.changeProperty(key, props.getProperty(key));
            }
        }
    }

    public static synchronized String getDatabaseVendor() {
        String mn = "getDatabaseVendor()";
        if (UMFactory.getInstance()._databaseVendor == null) {
            String vendor = null;
            Object o = UMFactory.instantiateClass("com.sap.security.core.InternalUMFactory");
            if (o != null) {
                try {
                    Class<?> oClass = o.getClass();
                    Method oMethod = null;
                    if (oClass != null) {
                        oMethod = oClass.getDeclaredMethod("getDatabaseVendor", null);
                    }
                    if (oMethod != null) {
                        vendor = (String)oMethod.invoke(null, null);
                    }
                }
                catch (Exception e) {
                    LoggingHelper.traceThrowable((int)400, (Location)loc, (String)mn, (Throwable)e);
                }
            }
            UMFactory.getInstance()._databaseVendor = vendor == null ? "Not accessible" : vendor;
        }
        return UMFactory.getInstance()._databaseVendor;
    }

    private void initializeSecurityManager() {
        block3: {
            String mn = "initializeSecurityManager()";
            _securitymanager = System.getSecurityManager();
            if (_securitymanager == null) {
                try {
                    class DoGetSecurityManagerFromFactory
                    implements PrivilegedExceptionAction {
                        private final /* synthetic */ UMFactory this$0;

                        DoGetSecurityManagerFromFactory(UMFactory this$0) {
                            this.this$0 = this$0;
                        }

                        public Object run() throws Exception {
                            Class<?> smf = Class.forName("com.sap.security.core.codesecurity.securitymanager.SecurityManagerFactory");
                            Method gsm = smf.getMethod("getSecurityManager", null);
                            return gsm.invoke(null, null);
                        }
                    }
                    _securitymanager = (SecurityManager)AccessController.doPrivileged(new DoGetSecurityManagerFromFactory(this));
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)pae);
                    if (e instanceof ClassNotFoundException) break block3;
                    e.printStackTrace();
                    throw new RuntimeException("error installing security manager");
                }
            }
        }
    }

    private void initializeTicket() {
        String mn = "initializeTicket()";
        IUMParameters conf = this._properties;
        String strIss = conf.get("login.ticket_issuer", "");
        String strClient = conf.get("login.ticket_client", "000");
        String strValid = conf.get("login.ticket_lifetime");
        int iValid = 0;
        int iValidMin = 0;
        boolean ticketSecureFlag = conf.getBoolean("ume.logon.security.enforce_secure_cookie", false);
        if (strValid == null) {
            strValid = "60";
        }
        int idx = strValid.indexOf(58);
        try {
            if (idx > 0) {
                iValid = Integer.parseInt(strValid.substring(0, idx));
                iValidMin = Integer.parseInt(strValid.substring(idx + 1));
            } else {
                iValid = Integer.parseInt(strValid);
            }
        }
        catch (NumberFormatException nfe) {
            LoggingHelper.traceThrowable((int)100, (Location)loc, (String)mn, (Throwable)nfe);
            iValid = 60;
        }
        boolean bStandalone = conf.getBoolean("login.ticket_standalone", false);
        char[] d = new char[]{'o'};
        Class[] args_clazz = null;
        String keystore = null;
        String password = null;
        String alias = null;
        if (bStandalone) {
            keystore = conf.get("login.ticket_keystore", "ticketKeyStore");
            password = conf.get("login.ticket_keystore_pw", "");
            alias = conf.get("login.ticket_keyalias", "testkey");
            args_clazz = new Class[]{class$java$io$InputStream == null ? (class$java$io$InputStream = UMFactory.class$("java.io.InputStream")) : class$java$io$InputStream, d.getClass(), class$java$lang$String == null ? (class$java$lang$String = UMFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UMFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UMFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UMFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE, Boolean.TYPE};
        } else {
            args_clazz = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UMFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UMFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE, Boolean.TYPE};
        }
        try {
            Class<?> clazz = Class.forName("com.sap.security.core.ticket.imp.BufferingTicket", false, UMFactory.getmyClassLoader());
            Method init = clazz.getMethod("init", args_clazz);
            Object[] args = null;
            if (bStandalone) {
                char[] cArray;
                Object[] objectArray = new Object[9];
                objectArray[0] = UMFactory.getProperties().getInputStream(keystore);
                if (password.length() == 0) {
                    char[] cArray2 = new char[4];
                    cArray2[0] = 116;
                    cArray2[1] = 101;
                    cArray2[2] = 115;
                    cArray = cArray2;
                    cArray2[3] = 116;
                } else {
                    cArray = password.toCharArray();
                }
                objectArray[1] = cArray;
                objectArray[2] = alias;
                objectArray[3] = null;
                objectArray[4] = strIss;
                objectArray[5] = strClient;
                objectArray[6] = new Integer(iValid);
                objectArray[7] = new Integer(iValidMin);
                objectArray[8] = new Boolean(ticketSecureFlag);
                args = objectArray;
            } else {
                args = new Object[]{strIss, strClient, new Integer(iValid), new Integer(iValidMin), new Boolean(ticketSecureFlag)};
            }
            init.invoke(null, args);
        }
        catch (Exception e) {
            System.out.println("Unable to initialize ticket: ");
            e.printStackTrace();
            throw new RuntimeException("Initialization failed.");
        }
    }

    private void initializeSecStore() {
    }

    private static Object initializeClass(String className) {
        Object obj = null;
        try {
            obj = UMFactory.instantiateClass(className);
            IConfigurable conf = (IConfigurable)obj;
            conf.initialize(UMFactory.getInstance()._properties.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" Unable to initialize class: " + className + e);
            throw new UMRuntimeException(e, " Unable to initialize class: " + className + e);
        }
        return obj;
    }

    private static Object instantiateClass(String className) {
        Object obj = null;
        try {
            if (className.equals(EMPTY_IMPL)) {
                return GenericDummyImplFactory.getDummyInstance(_interfacesForDummy, UMFactory.getmyClassLoader());
            }
            Class<?> c = Class.forName(className, true, UMFactory.getmyClassLoader());
            obj = c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" Unable to instantiate class: " + className + e);
            throw new UMRuntimeException(e, " Unable to instantiate class: " + className + e);
        }
        return obj;
    }

    public TicketVerifier getTicketVerifier() {
        String mn = "getTicketVerifier()";
        UMFactory uMFactory = this;
        synchronized (uMFactory) {
            if (!this._ticketVerifierInitialized) {
                this.initializeTicket();
                this._ticketVerifierInitialized = true;
            }
        }
        String className = UMFactory.getInstance()._properties.get("TicketVerifier", "com.sap.security.core.ticket.imp.BufferingTicket");
        TicketVerifier tv = (TicketVerifier)UMFactory.instantiateClass(className);
        try {
            Method m = tv.getClass().getMethod("setMode", Integer.TYPE);
            Field f = tv.getClass().getField("MODE_VERIFY");
            m.invoke((Object)tv, f.get(tv));
            m = tv.getClass().getMethod("setEnforceVerify", Boolean.TYPE);
            m.invoke((Object)tv, new Boolean(false));
        }
        catch (Exception e) {
            LoggingHelper.traceThrowable((int)500, (Location)loc, (String)mn, (Throwable)e);
            e.printStackTrace();
        }
        return tv;
    }

    public static synchronized void addSystemLandscapeWrapper(ISystemLandscapeWrapper slw) {
        if (null == UMFactory.getInstance()._systemLandscapeWrappers) {
            UMFactory.getInstance()._systemLandscapeWrappers = new ArrayList();
        }
        UMFactory.getInstance()._systemLandscapeWrappers.add(slw);
    }

    public static synchronized ArrayList getSystemLandscapeWrappers() {
        ArrayList copy = new ArrayList();
        if (UMFactory.getInstance()._systemLandscapeWrappers != null) {
            copy.addAll(UMFactory.getInstance()._systemLandscapeWrappers);
        }
        return copy;
    }

    public static synchronized void removeSystemLandscapeWrapper(ISystemLandscapeWrapper slw) {
        ArrayList al = UMFactory.getInstance()._systemLandscapeWrappers;
        if (al != null) {
            int i = 0;
            while (i < al.size()) {
                if (al.get(i).equals(slw)) {
                    al.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public static synchronized IAnonymousUserFactory getAnonymousUserFactory() {
        if (UMFactory.getInstance()._anonymousUserFactory == null) {
            try {
                Class<?> c = Class.forName("com.sap.security.core.logon.imp.AnonymousUser", true, UMFactory.getmyClassLoader());
                Class[] args = new Class[]{};
                Method m = c.getMethod("getInstance", args);
                UMFactory.getInstance()._anonymousUserFactory = (IAnonymousUserFactory)m.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }
        return UMFactory.getInstance()._anonymousUserFactory;
    }

    public static synchronized ISecurityPolicy getSecurityPolicy() {
        if (UMFactory.getInstance()._securityPolicyFactory == null) {
            try {
                Class<?> c = Class.forName("com.sap.security.core.logon.imp.SecurityPolicyFactory", true, UMFactory.getmyClassLoader());
                Class[] args = new Class[]{};
                Method m = c.getMethod("getInstance", args);
                UMFactory.getInstance()._securityPolicyFactory = (ISecurityPolicyFactory)m.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }
        return UMFactory.getInstance()._securityPolicyFactory.getSecurityPolicy();
    }

    public static synchronized void setDataSourceClass(Object dataSourceClass) {
        pcdRoleDataSourceClass = dataSourceClass;
    }

    public static synchronized Object getDataSourceClass() {
        return pcdRoleDataSourceClass;
    }

    public static void setLoggerClass(Object loggerClass) {
        pcdLoggerClass = loggerClass;
    }

    public static Object getLoggerClass() {
        return pcdLoggerClass;
    }

    public static boolean isInitialized() {
        return is_initialized;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _fileio = null;
        _interfacesForDummy = new Class[]{class$com$sap$security$api$logon$ILogonAuthentication == null ? (class$com$sap$security$api$logon$ILogonAuthentication = UMFactory.class$("com.sap.security.api.logon.ILogonAuthentication")) : class$com$sap$security$api$logon$ILogonAuthentication, class$com$sap$security$api$IGroupFactory == null ? (class$com$sap$security$api$IGroupFactory = UMFactory.class$("com.sap.security.api.IGroupFactory")) : class$com$sap$security$api$IGroupFactory, class$com$sap$security$api$IRoleFactory == null ? (class$com$sap$security$api$IRoleFactory = UMFactory.class$("com.sap.security.api.IRoleFactory")) : class$com$sap$security$api$IRoleFactory, class$com$sap$security$api$IUserAccountFactory == null ? (class$com$sap$security$api$IUserAccountFactory = UMFactory.class$("com.sap.security.api.IUserAccountFactory")) : class$com$sap$security$api$IUserAccountFactory, class$com$sap$security$api$IUserFactory == null ? (class$com$sap$security$api$IUserFactory = UMFactory.class$("com.sap.security.api.IUserFactory")) : class$com$sap$security$api$IUserFactory, class$com$sap$security$api$IPrincipalFactory == null ? (class$com$sap$security$api$IPrincipalFactory = UMFactory.class$("com.sap.security.api.IPrincipalFactory")) : class$com$sap$security$api$IPrincipalFactory, class$com$sap$security$api$srvUser$IServiceUserFactory == null ? (class$com$sap$security$api$srvUser$IServiceUserFactory = UMFactory.class$("com.sap.security.api.srvUser.IServiceUserFactory")) : class$com$sap$security$api$srvUser$IServiceUserFactory, class$com$sap$security$api$logon$IAnonymousUserFactory == null ? (class$com$sap$security$api$logon$IAnonymousUserFactory = UMFactory.class$("com.sap.security.api.logon.IAnonymousUserFactory")) : class$com$sap$security$api$logon$IAnonymousUserFactory, class$com$sap$security$api$logon$ISecurityPolicyFactory == null ? (class$com$sap$security$api$logon$ISecurityPolicyFactory = UMFactory.class$("com.sap.security.api.logon.ISecurityPolicyFactory")) : class$com$sap$security$api$logon$ISecurityPolicyFactory};
        _securitymanager = null;
        pcdRoleDataSourceClass = null;
        pcdLoggerClass = null;
    }

    private static class FileSystemIO
    implements IUMFileIO {
        private String path = "";

        public FileSystemIO(String p) {
            if (p != null && !p.trim().equals("")) {
                this.path = p.trim() + File.separator;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void writeFile(String name, InputStream in) throws IOException {
            try {
                int val;
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                while ((val = in.read()) != -1) {
                    void var4_5;
                    tmp.write((int)var4_5);
                }
                FileOutputStream fo = new FileOutputStream(this.path + name);
                fo.write(tmp.toByteArray());
                fo.close();
                UMFactory.getProperties().addFile(name, tmp.toByteArray());
                tmp.close();
            }
            catch (FileNotFoundException e) {
                throw new IOException("File not found");
            }
        }

        public InputStream readFile(String name) throws IOException {
            try {
                return new FileInputStream(this.path + name);
            }
            catch (FileNotFoundException e) {
                throw new IOException("File not found");
            }
        }

        public String[] getFiles() throws IOException {
            File dir = new File(this.path);
            if (dir == null) {
                throw new IOException("Path " + this.path + " is wrong");
            }
            return dir.list();
        }

        public void deleteFile(String name) throws IOException {
            if (name == null) {
                throw new IOException("File could not be deleted");
            }
            File toDelete = new File(this.path + name);
            boolean deleted = toDelete.delete();
            if (!deleted) {
                throw new IOException("File could not be deleted");
            }
        }
    }

    private static class NoBak
    implements FilenameFilter {
        private NoBak() {
        }

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return !name.endsWith(".bak") && !f.isDirectory();
        }
    }
}

