/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ssl;

import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLClientContext;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLTransport;
import iaik.security.ssl.SecurityProvider;
import iaik.security.ssl.Utils;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class SSLServerContext
extends SSLClientContext
implements Cloneable {
    public static final CipherSuite[] anon;
    public static final CipherSuite[] dh_dss;
    public static final CipherSuite[] dh_rsa;
    public static final CipherSuite[] dhe_dss;
    public static final CipherSuite[] dhe_rsa;
    public static final CipherSuite[] rsa_export;
    public static final CipherSuite[] rsa;
    Principal[] f;
    byte[] e;
    private int[] g;
    private boolean c;
    private static Object[] a;
    private Object[] b;
    private KeyAndCert[] d;
    private static final int l = 4;
    private static final int k = 0;
    private static final String[] j;
    static final int m = 4;
    static final int o = 3;
    static final int n = 2;
    static final int i = 1;
    static final int h = 0;
    private static final int s = 4;
    private static final int r = 0;
    private static final int v = 4;
    private static final int u = 3;
    private static final int t = 2;
    private static final int q = 1;
    private static final int p = 0;
    private static final String ab = "ea9zl437khcwgmicelj0fwhslq3peca6wvdektn0yc25cspjuqzn9qo5psa2s6c3jgzarrel15wwodtpwqos2dqjs2ndyil06iufnousb6gjflwk5zw6hlzk63b7x8xawhannq1r6gstizkft5agiu8svsxl0tei74idyv16hw3st5di2vcdy525nc2s2useigytm2";
    private static final String y = "vjyxwyawcutef13zkgcsts7hkolgnmn5861w1cd9scjej51zqe3lfswg3n6qqe821lkx27pvoa8tkoglb928hex0s3jvepqx1q1bw4dubjagqtwpga0g2gmitt8f6r5h8tr1j62vavnyyaw2q2ow2gu9mmeuat2mcq9kryffc1em5xjn316z1yoaki3lj6kcfex2ah";
    private static final String z = "agapx2dmn89tcarxtghfhmpjwx7stcgv2iy0vgb8r8byqmxiw1w3u5ut72mh98vrxj1alw8l2lgnjsgfjrf552nemony9kblzjo";
    private static final String x = "kzyd2bb8x0kwy2z5hrvbn8joniex7clevyp14mijp8ne5uf9y9p5p2mstfl2nzy1rdaq88b1hnmz86uyyjsshxdnp3g6og5fxo7";
    private static final int w = 36;

    public void updateCipherSuites() {
        CipherSuiteList cipherSuiteList = this.getEnabledCipherSuiteList();
        if (this.d[0] == null) {
            cipherSuiteList.remove(CipherSuite.CS_RSA_EXPORT);
            cipherSuiteList.remove(CipherSuite.CS_RSA_EXPORT1024);
            cipherSuiteList.remove(CipherSuite.CS_DHE_RSA);
            cipherSuiteList.remove(CipherSuite.CS_DHE_RSA_EXPORT);
            if (this.d[1] == null) {
                cipherSuiteList.remove(CipherSuite.CS_RSA);
                cipherSuiteList.remove(CipherSuite.CS_RSA_WITH_NULL);
            }
        }
        if (this.d[2] == null) {
            cipherSuiteList.remove(CipherSuite.CS_DHE_DSS);
            cipherSuiteList.remove(CipherSuite.CS_DHE_DSS_EXPORT);
            cipherSuiteList.remove(CipherSuite.CS_DHE_DSS_EXPORT1024);
        }
        if (this.d[3] == null) {
            cipherSuiteList.remove(CipherSuite.CS_DH_RSA);
            cipherSuiteList.remove(CipherSuite.CS_DH_RSA_EXPORT);
        }
        if (this.d[4] == null) {
            cipherSuiteList.remove(CipherSuite.CS_DH_DSS);
            cipherSuiteList.remove(CipherSuite.CS_DH_DSS_EXPORT);
        }
        super.updateCipherSuites();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\nAvailable certificates:\n");
        boolean bl = false;
        int n2 = 0;
        while (n2 <= 4) {
            if (this.d[n2] != null) {
                bl = true;
                stringBuffer.append(this.d[n2]).toString();
            }
            ++n2;
        }
        if (!bl) {
            stringBuffer.append("None\n");
        }
        stringBuffer.append("\nTemporary Parameters:\n");
        int n3 = 0;
        while (n3 <= 4) {
            this.a(stringBuffer, n3);
            ++n3;
        }
        stringBuffer.append("\nRequest client certificate: ");
        stringBuffer.append(this.c ? "yes" : "no");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static int e(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 257: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    private void a(StringBuffer stringBuffer, int n2) {
        stringBuffer.append("  ");
        stringBuffer.append(j[n2]);
        stringBuffer.append(": ");
        stringBuffer.append(this.b[n2] != null ? "available" : "not set");
        stringBuffer.append("\n");
    }

    public void setRequireClientCertificate(byte[] byArray, Principal[] principalArray) {
        if (byArray == null && principalArray == null) {
            this.c = false;
            return;
        }
        this.c = true;
        this.e = byArray;
        this.f = principalArray;
    }

    public void setRequestClientCertificate(boolean bl) {
        this.c = bl;
    }

    public void setRSATempKeyPair(KeyPair keyPair) {
        this.addTemporaryParameter(keyPair);
    }

    public void setRSACertificate(Certificate[] certificateArray, PrivateKey privateKey) throws CertificateException {
        this.addServerCredentials(SSLContext.convertCertificateChain(certificateArray), privateKey);
    }

    public void setDSACertificate(Certificate[] certificateArray, PrivateKey privateKey) throws CertificateException {
        this.addServerCredentials(SSLContext.convertCertificateChain(certificateArray), privateKey);
    }

    public void setDHParameter(DHParameterSpec dHParameterSpec) {
        this.addTemporaryParameter(dHParameterSpec);
    }

    public void setDHCertificate(Certificate[] certificateArray, PrivateKey privateKey) throws CertificateException {
        this.addServerCredentials(SSLContext.convertCertificateChain(certificateArray), privateKey);
    }

    public void setAllowedProtocolVersions(int n2, int n3) {
        if (n2 == 2) {
            throw new IllegalArgumentException("SSL 2.0 not supported on the server side!");
        }
        super.setAllowedProtocolVersions(n2, n3);
    }

    public void setAllowedCertificateTypes(int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!SSLContext.b(nArray[n2])) {
                throw new IllegalArgumentException("Invalid certificate type: " + nArray[n2]);
            }
            ++n2;
        }
        this.g = nArray;
    }

    private static void c() {
        if (a != null) {
            return;
        }
        a = new Object[5];
        BigInteger bigInteger = new BigInteger(x, 36);
        BigInteger bigInteger2 = new BigInteger(z, 36);
        BigInteger bigInteger3 = new BigInteger(y, 36);
        BigInteger bigInteger4 = new BigInteger(ab, 36);
        DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2);
        DHParameterSpec dHParameterSpec2 = new DHParameterSpec(bigInteger3, bigInteger4);
        SSLServerContext.a[2] = dHParameterSpec;
        SSLServerContext.a[3] = dHParameterSpec2;
        SSLServerContext.a[4] = dHParameterSpec2;
    }

    synchronized Object a(SSLTransport sSLTransport, int n2) {
        if (this.b[n2] == null) {
            this.a(this.d[3]);
            this.a(this.d[4]);
            if (this.b[n2] != null) {
                sSLTransport.debug("Temporary " + j[n2] + " not set, using defaults from certificates.");
            } else {
                String string = j[n2];
                synchronized (string) {
                    sSLTransport.debug("Temporary " + j[n2] + " not set, using defaults.");
                    SSLServerContext.c();
                    if (a[n2] == null) {
                        int n3 = n2 == 0 ? 512 : 1024;
                        SSLServerContext.a[n2] = SSLServerContext.a(sSLTransport, n3, this);
                    }
                    this.b[n2] = a[n2];
                }
            }
        }
        return this.b[n2];
    }

    public KeyAndCert getServerCredentials(int n2) {
        int n3 = SSLServerContext.e(n2);
        if (n3 < 0) {
            throw new IllegalArgumentException("Unknown certificate type: " + n2);
        }
        KeyAndCert keyAndCert = this.d[n3];
        if (keyAndCert == null) {
            throw new NullPointerException("Required " + Utils.certTypeToString(n2) + " credentials not available!");
        }
        return keyAndCert;
    }

    public boolean getRequireClientCertificate() {
        return this.getRequestClientCertificate();
    }

    public boolean getRequestClientCertificate() {
        return this.c;
    }

    PrivateKey d(int n2) {
        return this.getServerCredentials(n2).getPrivateKey();
    }

    static DHParameterSpec b() {
        SSLServerContext.c();
        return (DHParameterSpec)a[2];
    }

    X509Certificate[] c(int n2) {
        return this.getServerCredentials(n2).getCertificateChain();
    }

    public int[] getAllowedCertificateTypes() {
        return this.g;
    }

    private static KeyPair a(SSLTransport sSLTransport, int n2, SSLContext sSLContext) {
        try {
            if (sSLTransport != null) {
                sSLTransport.debug("Generating " + n2 + " bit temporary RSA keypair...");
            }
            SecureRandom secureRandom = sSLContext.getRandomGenerator();
            SecurityProvider securityProvider = SecurityProvider.getSecurityProvider();
            KeyPairGenerator keyPairGenerator = securityProvider.getKeyPairGenerator("RSA");
            keyPairGenerator.initialize(n2, secureRandom);
            return Utils.generateKeyPair(keyPairGenerator);
        }
        catch (Exception exception) {
            throw new NullPointerException("Error generating temporary RSA keypair: " + exception.toString());
        }
    }

    void a(SSLServerContext sSLServerContext) {
        super.a(sSLServerContext);
        this.d = (KeyAndCert[])sSLServerContext.d.clone();
        this.b = (Object[])sSLServerContext.b.clone();
        this.c = sSLServerContext.c;
        this.g = sSLServerContext.g;
        this.e = sSLServerContext.e;
        this.f = sSLServerContext.f;
    }

    public Object clone() {
        return new SSLServerContext(this);
    }

    public void clearServerCredentials() {
        int n2 = 0;
        while (n2 <= 4) {
            this.d[n2] = null;
            ++n2;
        }
    }

    public void addTemporaryParameter(DHParameterSpec dHParameterSpec, int n2) {
        if (n2 <= 512) {
            this.b[2] = dHParameterSpec;
            return;
        }
        if (n2 <= 1024) {
            this.b[3] = dHParameterSpec;
            if (this.b[4] == null) {
                this.b[4] = dHParameterSpec;
                return;
            }
        } else {
            this.b[4] = dHParameterSpec;
        }
    }

    public void addTemporaryParameter(DHParameterSpec dHParameterSpec) {
        int n2 = dHParameterSpec.getP().bitLength();
        this.addTemporaryParameter(dHParameterSpec, n2);
    }

    public void addTemporaryParameter(KeyPair keyPair) {
        int n2 = Utils.a(keyPair.getPublic());
        if (n2 <= 512) {
            this.b[0] = keyPair;
            return;
        }
        if (n2 <= 1024) {
            this.b[1] = keyPair;
            return;
        }
        throw new IllegalArgumentException("Temporary RSA keys should be 512 or 1024 bits long!");
    }

    public void addServerCredentials(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        this.addServerCredentials(new KeyAndCert(x509CertificateArray, privateKey));
    }

    public void addServerCredentials(KeyAndCert keyAndCert, int n2) {
        int n3 = SSLServerContext.e(n2);
        if (n3 < 0) {
            throw new IllegalArgumentException("Unknown certificate type!");
        }
        this.d[n3] = keyAndCert;
    }

    public void addServerCredentials(KeyAndCert keyAndCert) {
        int n2 = keyAndCert.getCertificateType();
        if (n2 == 1) {
            this.addServerCredentials(keyAndCert, 257);
        }
        this.addServerCredentials(keyAndCert, n2);
    }

    private void a(KeyAndCert keyAndCert) {
        if (keyAndCert == null) {
            return;
        }
        X509Certificate x509Certificate = keyAndCert.getCertificateChain()[0];
        this.addTemporaryParameter(((DHPublicKey)x509Certificate.getPublicKey()).getParams());
    }

    public SSLServerContext(SecureRandom secureRandom) {
        super(secureRandom);
        this.d = new KeyAndCert[5];
        this.b = new Object[5];
        this.g = new int[]{1, 2, 3, 4};
    }

    public SSLServerContext(SSLServerContext sSLServerContext) {
        this(0);
        this.a(sSLServerContext);
    }

    SSLServerContext(int n2) {
        super(n2);
    }

    public SSLServerContext() {
        this((SecureRandom)null);
    }

    static {
        j = new String[]{"512 bit RSA keypair", "1024 bit RSA keypair", "512 bit export DH parameters", "1024 bit export DH parameters", "domestic DH parameters"};
        rsa = CipherSuite.CS_RSA;
        rsa_export = CipherSuite.CS_RSA_EXPORT;
        dhe_rsa = CipherSuite.CS_DHE_RSA;
        dhe_dss = CipherSuite.CS_DHE_DSS;
        dh_rsa = CipherSuite.CS_DH_RSA;
        dh_dss = CipherSuite.CS_DH_DSS;
        anon = CipherSuite.CS_DH_ANON;
    }
}

