/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload.gui.tree;

import com.sap.engine.frame.core.load.gui.ComponentInfo;
import com.sap.engine.frame.core.load.gui.ItemInfo;
import com.sap.engine.services.classload.gui.ClassloadRuntimeView;
import com.sap.engine.services.classload.gui.tree.ComponentTreeNode;
import com.sap.engine.services.classload.gui.tree.ComponentTreeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ComponentTreePanel
extends JPanel
implements TreeSelectionListener {
    private ComponentInfo[] loaderWrappers;
    private ClassloadRuntimeView mainPanel;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private ComponentTreeNode interfacesNode;
    private ComponentTreeNode librariesNode;
    private ComponentTreeNode servicesNode;
    private ComponentTreeNode commonNode;
    private ComponentTreeNode applicationsNode;
    private ComponentTreeNode rootNode;

    public ComponentTreePanel(ClassloadRuntimeView classLoadingPanel) {
        super(new BorderLayout());
        this.mainPanel = classLoadingPanel;
        this.interfacesNode = new ComponentTreeNode("Interfaces", 32);
        this.librariesNode = new ComponentTreeNode("Libraries", 33);
        this.servicesNode = new ComponentTreeNode("Services", 34);
        this.commonNode = new ComponentTreeNode("Commons", 35);
        this.applicationsNode = new ComponentTreeNode("Applications", 36);
        this.rootNode = new ComponentTreeNode("Components", 31);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new ComponentTreeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(true);
        this.tree.setEditable(false);
        this.tree.addTreeSelectionListener(this);
        JScrollPane sp = new JScrollPane(this.tree);
        this.add((Component)sp, "Center");
    }

    public void refreshTree() {
        this.tree.removeAll();
        this.rootNode.removeAllChildren();
        this.interfacesNode.removeAllChildren();
        this.librariesNode.removeAllChildren();
        this.servicesNode.removeAllChildren();
        this.commonNode.removeAllChildren();
        this.applicationsNode.removeAllChildren();
        this.loaderWrappers = this.mainPanel.getComponentsInfo();
        int i = 0;
        while (i < this.loaderWrappers.length) {
            ComponentInfo componentInfo = this.loaderWrappers[i];
            ComponentTreeNode newNode = null;
            if (componentInfo.getComponentType() != 5) {
                newNode = new ComponentTreeNode(componentInfo);
            } else {
                String commonName = this.mainPanel.getFakeName(componentInfo.getFullName());
                newNode = new ComponentTreeNode(commonName, commonName, componentInfo);
            }
            ComponentTreeNode parentNode = this.getLogicalParent(componentInfo.getComponentType());
            this.insertSortedNode(parentNode, newNode);
            ++i;
        }
        if (this.interfacesNode.getChildCount() != 0) {
            this.rootNode.add(this.interfacesNode);
        }
        if (this.librariesNode.getChildCount() != 0) {
            this.rootNode.add(this.librariesNode);
        }
        if (this.servicesNode.getChildCount() != 0) {
            this.rootNode.add(this.servicesNode);
        }
        if (this.commonNode.getChildCount() != 0) {
            this.rootNode.add(this.commonNode);
        }
        if (this.applicationsNode.getChildCount() != 0) {
            this.rootNode.add(this.applicationsNode);
        }
        this.treeModel.setRoot(this.rootNode);
    }

    public void valueChanged(TreeSelectionEvent event) {
        if (event.getNewLeadSelectionPath() == null) {
            return;
        }
        TreePath path = event.getPath();
        ComponentTreeNode componentTreeNode = (ComponentTreeNode)path.getLastPathComponent();
        if (componentTreeNode.isComponentNode()) {
            TreePath treePath = this.addResourcesInNode(componentTreeNode);
            this.tree.expandPath(treePath);
            this.tree.setSelectionPath(treePath);
            this.mainPanel.drawComponent(componentTreeNode);
        } else if (componentTreeNode.isResource()) {
            this.mainPanel.popUpMessage(componentTreeNode.getFullName(), "Resource full name");
        }
    }

    public void expandComponent(ComponentTreeNode componentTreeNode) {
        this.collapseTree();
        ComponentInfo componentInfo = componentTreeNode.getComponentInfo();
        ComponentTreeNode tmpNode = this.getLogicalParent(componentInfo.getComponentType());
        if (tmpNode != null) {
            int childsCount = this.treeModel.getChildCount(tmpNode);
            int j = 0;
            while (j < childsCount) {
                ComponentTreeNode child = (ComponentTreeNode)this.treeModel.getChild(tmpNode, j);
                if (child.toString().equals(componentTreeNode.getShortName())) {
                    TreePath treePath = this.addResourcesInNode(child);
                    this.tree.expandPath(treePath);
                    this.tree.setSelectionPath(treePath);
                    this.tree.scrollRowToVisible(j);
                    break;
                }
                ++j;
            }
        }
    }

    private TreePath addResourcesInNode(ComponentTreeNode componentTreeNode) {
        ComponentInfo wrapper;
        if (componentTreeNode.getChildCount() == 0 && (wrapper = componentTreeNode.getComponentInfo()) != null) {
            if (!wrapper.isInitialized()) {
                componentTreeNode.add(new ComponentTreeNode("Loader not initialized ! ", 11));
            } else {
                ItemInfo[] resources = wrapper.getParsedResources();
                if (resources != null) {
                    int j = 0;
                    while (j < resources.length) {
                        if (resources[j] != null) {
                            componentTreeNode.add(new ComponentTreeNode(resources[j].getFullName(), resources[j].getShortName(), resources[j].getType()));
                        }
                        ++j;
                    }
                }
                if (wrapper.getComponentType() == 5) {
                    this.addSubloadersInCommonNode(componentTreeNode);
                }
            }
        }
        TreePath treePath = new TreePath(new Object[]{this.rootNode, componentTreeNode.getParent(), componentTreeNode});
        return treePath;
    }

    private void addSubloadersInCommonNode(ComponentTreeNode componentTreeNode) {
        ComponentInfo wrapper = componentTreeNode.getComponentInfo();
        ComponentTreeNode commonContainer = new ComponentTreeNode("Contains", 37);
        StringTokenizer tokenizer = new StringTokenizer(wrapper.getShortName(), ";", false);
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            this.insertSortedNode(commonContainer, new ComponentTreeNode(nextToken, 38));
        }
        this.treeModel.insertNodeInto(commonContainer, componentTreeNode, 0);
    }

    private ComponentTreeNode getLogicalParent(byte componentType) {
        if (componentType == 1) {
            return this.interfacesNode;
        }
        if (componentType == 2) {
            return this.librariesNode;
        }
        if (componentType == 3) {
            return this.servicesNode;
        }
        if (componentType == 5) {
            return this.commonNode;
        }
        if (componentType == 4) {
            return this.applicationsNode;
        }
        return null;
    }

    private void insertSortedNode(ComponentTreeNode parentNode, ComponentTreeNode newNode) {
        int childCount = parentNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            ComponentTreeNode child = (ComponentTreeNode)this.treeModel.getChild(parentNode, i);
            if (child.toString().compareToIgnoreCase(newNode.toString()) > 0) {
                this.treeModel.insertNodeInto(newNode, parentNode, i);
                return;
            }
            ++i;
        }
        parentNode.add(newNode);
    }

    private void collapseTree() {
        int maxCount;
        this.tree.setSelectionRow(0);
        int currentRowCount = maxCount = this.tree.getRowCount() - 2;
        while (currentRowCount > 0) {
            maxCount = this.tree.getRowCount() - 2;
            if (maxCount < currentRowCount) {
                currentRowCount = maxCount;
            }
            this.tree.collapseRow(currentRowCount);
            --currentRowCount;
        }
    }

    public String getNextFakeName() {
        return "common@ " + (this.commonNode.getChildCount() + 1);
    }
}

