/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload.gui.tree;

import com.sap.engine.frame.core.load.gui.ComponentInfo;
import com.sap.engine.services.classload.gui.ClassloadRuntimeLogical;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class ComponentTreeNode
extends DefaultMutableTreeNode {
    public static final byte ROOT = 31;
    public static final byte ROOT_INTERFACE = 32;
    public static final byte ROOT_LIBRARY = 33;
    public static final byte ROOT_SERVICE = 34;
    public static final byte ROOT_COMMON = 35;
    public static final byte ROOT_APPLICATION = 36;
    public static final byte COMMON_CONTAINER = 37;
    public static final byte COMMON_CONTAINER_ITEM = 38;
    public static final String ROOT_STRING = "Components";
    public static final String ROOT_INTERFACE_STRING = "Interfaces";
    public static final String ROOT_LIBRARIES_STRING = "Libraries";
    public static final String ROOT_SERVICES_STRING = "Services";
    public static final String ROOT_APPLICATIONS_STRING = "Applications";
    public static final String ROOT_COMMON_STRING = "Commons";
    public static final String COMMON_CONTAINER_STRING = "Contains";
    private static final ImageIcon ROOT_ICON = ClassloadRuntimeLogical.getIcon("root.gif");
    private static final ImageIcon ROOT_INTERFACE_ICON = ClassloadRuntimeLogical.getIcon("rootInterface.gif");
    private static final ImageIcon ROOT_LIBRARIES_ICON = ClassloadRuntimeLogical.getIcon("rootLibrary.gif");
    private static final ImageIcon ROOT_SERVICES_ICON = ClassloadRuntimeLogical.getIcon("rootService.gif");
    private static final ImageIcon ROOT_COMMON_ICON = ClassloadRuntimeLogical.getIcon("rootCommon.gif");
    private static final ImageIcon ROOT_APPLICATION_ICON = ClassloadRuntimeLogical.getIcon("rootApplication.gif");
    private static final ImageIcon RESOURCE_JAR_ICON = ClassloadRuntimeLogical.getIcon("resourceJar.gif");
    private static final ImageIcon RESOURCE_OTHER_ICON = ClassloadRuntimeLogical.getIcon("resourceOther.gif");
    private static final ImageIcon COMPONENT_ICON = ClassloadRuntimeLogical.getIcon("component.gif");
    private static final ImageIcon COMMON_CONTAINER_ITEM_ICON = ClassloadRuntimeLogical.getIcon("commonContainer.gif");
    private ComponentInfo componentInfo;
    private String fullName;
    private String shortName;
    private byte type;

    public ComponentTreeNode(ComponentInfo componentInfo) {
        this(componentInfo.getFullName(), componentInfo.getShortName(), componentInfo);
    }

    public ComponentTreeNode(String fullName, String shortName, ComponentInfo componentInfo) {
        this(fullName, shortName, componentInfo.getComponentType());
        this.componentInfo = componentInfo;
    }

    public ComponentTreeNode(String fullName, byte type) {
        this(fullName, fullName, type);
    }

    public ComponentTreeNode(String fullName, String shortName, byte type) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.type = type;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public byte getType() {
        return this.type;
    }

    public boolean isComponentNode() {
        return this.componentInfo != null;
    }

    public boolean isRoot() {
        return this.type == 31 || this.type == 32 || this.type == 33 || this.type == 34 || this.type == 35 || this.type == 36;
    }

    public boolean isResource() {
        return this.type == 10 || this.type == 11;
    }

    public Icon getIcon() {
        if (this.isComponentNode()) {
            switch (this.type) {
                case 1: {
                    return COMPONENT_ICON;
                }
                case 2: {
                    return COMPONENT_ICON;
                }
                case 3: {
                    return COMPONENT_ICON;
                }
                case 5: {
                    return COMPONENT_ICON;
                }
                case 4: {
                    return COMPONENT_ICON;
                }
            }
        }
        switch (this.type) {
            case 31: {
                return ROOT_ICON;
            }
            case 32: {
                return ROOT_INTERFACE_ICON;
            }
            case 33: {
                return ROOT_LIBRARIES_ICON;
            }
            case 34: {
                return ROOT_SERVICES_ICON;
            }
            case 35: {
                return ROOT_COMMON_ICON;
            }
            case 36: {
                return ROOT_APPLICATION_ICON;
            }
            case 10: {
                return RESOURCE_JAR_ICON;
            }
            case 11: {
                return RESOURCE_OTHER_ICON;
            }
            case 38: {
                return COMMON_CONTAINER_ITEM_ICON;
            }
            case 37: {
                return COMMON_CONTAINER_ITEM_ICON;
            }
        }
        return null;
    }

    public ComponentInfo getComponentInfo() {
        return this.componentInfo;
    }

    public String toString() {
        return this.shortName;
    }
}

