/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload.gui;

import com.sap.engine.frame.core.load.gui.ComponentInfo;
import com.sap.engine.services.classload.gui.ArrowView;
import com.sap.engine.services.classload.gui.ClassloadRuntimeView;
import com.sap.engine.services.classload.gui.ComponentView;
import com.sap.engine.services.classload.gui.tree.ComponentTreeNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;

public class DiagramPanel
extends JPanel
implements MouseListener,
ActionListener {
    private ClassloadRuntimeView mainPanel;
    private final Vector components = new Vector();
    private final Vector arrows = new Vector();
    private final Vector actionListeners = new Vector();
    private int marginX = 10;
    private int marginY = 20;
    private int componentWidth = 50;
    private int componentHeight = 20;
    private FontMetrics fontMetrics = null;
    private ComponentView selectionComponent = null;
    private Color selectionColor = new Color(92, 92, 255);
    private Color oldColor;

    public DiagramPanel(ClassloadRuntimeView classLoadingPanel) {
        this.setBackground(Color.white);
        this.mainPanel = classLoadingPanel;
        this.setPreferredSize(new Dimension(500, 500));
        this.addActionListener(this);
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void clearPanel() {
        this.removeAll();
    }

    public void removeAll() {
        this.components.clear();
        this.arrows.clear();
        this.reloadModel();
    }

    public void addComponent(String name, int position, boolean sorted) {
        ComponentView newComponent = new ComponentView(name, position);
        if (sorted) {
            boolean inserted = false;
            int i = 0;
            while (i < this.components.size()) {
                ComponentView nextComponent = (ComponentView)this.components.get(i);
                if (nextComponent.toString().compareToIgnoreCase(name) > 0) {
                    this.components.add(i, newComponent);
                    inserted = true;
                    break;
                }
                ++i;
            }
            if (!inserted) {
                this.components.add(newComponent);
            }
        } else {
            this.components.add(newComponent);
        }
        this.reloadModel();
    }

    public void addArrow(String from, String to, int type) {
        this.arrows.add(new ArrowView(from, to, type));
        this.reloadModel();
    }

    public void removeComponent(String name) {
        ComponentView comp = this.getComponent(name);
        if (comp == null) {
            return;
        }
        this.components.remove(comp);
        this.reloadModel();
    }

    public void removeArrow(String from, String to) {
        ArrowView comp = this.getArrowView(from, to);
        if (comp == null) {
            return;
        }
        this.arrows.remove(comp);
        this.reloadModel();
    }

    public void setComponentColor(String name, Color color) {
        ComponentView comp = this.getComponent(name);
        if (comp == null) {
            return;
        }
        comp.setColor(color);
        this.repaint();
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    protected void fireActionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(i)).actionPerformed(e);
            ++i;
        }
    }

    protected ComponentView getComponent(String name) {
        int i = 0;
        while (i < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i);
            if (comp.toString().equals(name)) {
                return comp;
            }
            ++i;
        }
        return null;
    }

    protected ArrowView getArrowView(String from, String to) {
        int i = 0;
        while (i < this.components.size()) {
            ArrowView comp = (ArrowView)this.components.elementAt(i);
            if (comp.from.equals(from) && comp.to.equals(to)) {
                return comp;
            }
            ++i;
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        ComponentTreeNode componentTreeNode = this.mainPanel.getComponentTreeNode(cmd);
        if (componentTreeNode != null) {
            this.drawComponent(componentTreeNode);
            this.mainPanel.expandComponent(componentTreeNode);
        }
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int i = 0;
        while (i < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i);
            if (comp.isContain(x, y)) {
                if (this.selectionComponent != null) {
                    this.selectionComponent.setColor(this.oldColor);
                }
                this.selectionComponent = comp;
                this.oldColor = this.selectionComponent.getColor();
                this.selectionComponent.setColor(this.selectionColor);
                this.repaint();
                if (e.getClickCount() >= 2) {
                    ActionEvent event = new ActionEvent(comp, 1001, comp.toString());
                    this.fireActionPerformed(event);
                }
                return;
            }
            ++i;
        }
        if (this.selectionComponent != null) {
            this.selectionComponent.setColor(this.oldColor);
            this.repaint();
        }
        this.selectionComponent = null;
        this.oldColor = null;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void drawComponent(ComponentTreeNode componentTreeNode) {
        this.removeAll();
        ComponentInfo componentInfo = componentTreeNode.getComponentInfo();
        if (componentInfo != null) {
            String[] references;
            String[] referees;
            String componentName = componentTreeNode.getFullName();
            this.addComponent(componentName, 1, false);
            if (componentInfo.getParent() != null) {
                this.addComponent(componentInfo.getParent(), 0, false);
                this.addArrow(componentName, componentInfo.getParent(), 0);
            }
            if ((referees = componentInfo.getReferees()) != null) {
                int i = 0;
                while (i < referees.length) {
                    String refereeName = null;
                    refereeName = referees[i].startsWith("common:") ? this.mainPanel.getFakeName(referees[i]) : referees[i];
                    this.addComponent(refereeName, 2, true);
                    this.addArrow(refereeName, componentName, 2);
                    ++i;
                }
            }
            if ((references = componentInfo.getReferences()) != null) {
                int i = 0;
                while (i < references.length) {
                    String refrenceName = null;
                    refrenceName = references[i].startsWith("common:") ? this.mainPanel.getFakeName(references[i]) : references[i];
                    this.addComponent(refrenceName, 3, false);
                    this.addArrow(componentName, refrenceName, 1);
                    ++i;
                }
            }
        }
        this.repaint();
        this.validate();
        this.updateUI();
    }

    protected int before(String name1, String name2) {
        int i = 0;
        while (i < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i);
            if (comp.toString().equals(name1)) {
                return 1;
            }
            if (comp.toString().equals(name2)) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private int sign(int value) {
        if (value == 0) {
            return 0;
        }
        if (value < 0) {
            return -1;
        }
        return 1;
    }

    protected void calculateFontMetrics() {
        if (this.fontMetrics == null) {
            return;
        }
        int width = 0;
        int i = 0;
        while (i < this.components.size()) {
            String name = this.components.elementAt(i).toString();
            if (width < this.fontMetrics.stringWidth(name)) {
                width = this.fontMetrics.stringWidth(name);
            }
            ++i;
        }
        this.componentWidth = width + 10;
        this.componentHeight = this.fontMetrics.getHeight() + 4;
        this.marginX = this.fontMetrics.stringWidth("m");
        this.marginY = this.fontMetrics.getHeight();
        ComponentView.w = this.componentWidth;
        ComponentView.h = this.componentHeight;
    }

    public void setFont(Font font) {
        this.fontMetrics = null;
        super.setFont(font);
        this.repaint();
    }

    protected void reloadModel() {
        int rightDown;
        int up = 0;
        int left = 0;
        int right = 0;
        int down = 0;
        int center = 0;
        this.calculateFontMetrics();
        int x = this.getHeight() / 2;
        int y = this.marginY;
        int i = 0;
        while (i < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i);
            if (comp.position == 0) {
                ++up;
                comp.y = y;
                y += this.marginY + this.componentHeight;
            }
            ++i;
        }
        int upDown = y;
        int i2 = 0;
        while (i2 < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i2);
            if (comp.position == 2) {
                ++left;
                comp.y = y;
                y += this.marginY + this.componentHeight;
            }
            ++i2;
        }
        int leftDown = y;
        y = upDown;
        int i3 = 0;
        while (i3 < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i3);
            if (comp.position == 3) {
                ++right;
                comp.y = y;
                y += this.marginY + this.componentHeight;
            }
            ++i3;
        }
        if (left == 0 && right == 0) {
            y += this.marginY + this.componentHeight;
        }
        y = (rightDown = y) < leftDown ? leftDown : rightDown;
        y = (y - upDown) / 2 + upDown - this.componentHeight;
        int i4 = 0;
        while (i4 < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i4);
            if (comp.position == 1) {
                ++center;
                comp.y = y;
            }
            ++i4;
        }
        y = rightDown < leftDown ? leftDown : rightDown;
        int i5 = 0;
        while (i5 < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i5);
            if (comp.position == 4) {
                ++down;
                comp.y = y;
            }
            ++i5;
        }
        if (down == 0) {
            down = 1;
        }
        y += this.marginY + this.componentHeight;
        int deltaX = 0;
        if (down < 2) {
            deltaX = this.componentWidth / 2;
        }
        int prefX = (this.sign(left + 1) + this.sign(center + up) + this.sign(right + 1)) * (this.marginX + this.componentWidth) + down * (this.marginX + this.componentWidth) - this.componentWidth + 2 * deltaX;
        x = this.marginX + this.componentWidth + this.marginX + deltaX;
        int i6 = 0;
        while (i6 < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i6);
            if (comp.position == 0) {
                comp.x = (prefX - this.componentWidth) / 2;
            }
            if (comp.position == 2) {
                comp.x = this.marginX;
            }
            if (comp.position == 3) {
                comp.x = prefX - this.componentWidth - this.marginX;
            }
            if (comp.position == 1) {
                comp.x = (prefX - this.componentWidth) / 2;
            }
            if (comp.position == 4) {
                comp.x = x;
                x += this.marginX + this.componentWidth;
            }
            ++i6;
        }
        this.setPreferredSize(new Dimension(prefX, y));
        int i7 = 0;
        while (i7 < this.arrows.size()) {
            ArrowView arrow = (ArrowView)this.arrows.elementAt(i7);
            ComponentView from = this.getComponent(arrow.from);
            ComponentView to = this.getComponent(arrow.to);
            if (from != null && to != null) {
                Point p;
                if (from.position == 0 && to.position == 0) {
                    if (this.before(arrow.from, arrow.to) == 1) {
                        p = from.getDownPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getUpPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else {
                        p = to.getDownPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getUpPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    }
                } else if (from.position == 1) {
                    if (to.position == 0) {
                        p = to.getDownPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getUpPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    } else if (to.position == 2) {
                        p = to.getRightPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getLeftPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    } else if (to.position == 3) {
                        p = from.getRightPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getLeftPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else if (to.position == 4) {
                        p = from.getDownPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getUpPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    }
                } else if (to.position == 1) {
                    if (from.position == 0) {
                        p = from.getDownPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getUpPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else if (from.position == 2) {
                        p = from.getRightPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                        p = to.getLeftPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                    } else if (from.position == 3) {
                        p = to.getRightPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getLeftPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    } else if (from.position == 4) {
                        p = to.getDownPoint();
                        arrow.x2 = p.x;
                        arrow.y2 = p.y;
                        p = from.getUpPoint();
                        arrow.x1 = p.x;
                        arrow.y1 = p.y;
                    }
                } else if (from.position == 2 || to.position == 2 || from.position == 3 || to.position == 3 || from.position == 4 || from.position == 2) {
                    // empty if block
                }
            }
            ++i7;
        }
        this.repaint();
        this.validate();
    }

    public void paint(Graphics g) {
        g.setFont(this.getFont());
        if (this.fontMetrics == null) {
            this.fontMetrics = g.getFontMetrics();
            this.reloadModel();
        }
        int width = this.getHeight();
        int height = this.getWidth();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, height, width);
        int i = 0;
        while (i < this.components.size()) {
            ComponentView comp = (ComponentView)this.components.elementAt(i);
            comp.paint(g);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.arrows.size()) {
            ArrowView arrow = (ArrowView)this.arrows.elementAt(i2);
            arrow.paint(g);
            ++i2;
        }
    }
}

