/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class ComponentView {
    public String name;
    public int position;
    public int x = 0;
    public int y = 0;
    public static int w = 50;
    public static int h = 20;
    public Color color = Color.black;
    public static final int POSITION_TOP = 0;
    public static final int POSITION_CENTER = 1;
    public static final int POSITION_LEFT = 2;
    public static final int POSITION_RIGHT = 3;
    public static final int POSITION_BOTTOM = 4;

    public ComponentView(String name, int position) {
        this.name = name;
        this.position = position;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int w, int h) {
        ComponentView.w = w;
        ComponentView.h = h;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Point getLeftPoint() {
        Point p = new Point(this.x, this.y + h / 2);
        return p;
    }

    public Point getRightPoint() {
        Point p = new Point(this.x + w, this.y + h / 2);
        return p;
    }

    public Point getUpPoint() {
        Point p = new Point(this.x + w / 2, this.y);
        return p;
    }

    public Point getDownPoint() {
        Point p = new Point(this.x + w / 2, this.y + h);
        return p;
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        g.drawRoundRect(this.x, this.y, w, h, 5, 5);
        int stringSize = g.getFontMetrics().stringWidth(this.name);
        int textX = (w - stringSize) / 2 + this.x;
        int textY = this.y + h - 5;
        g.drawString(this.name, textX, textY);
    }

    public boolean isContain(int x0, int y0) {
        return x0 >= this.x && x0 <= this.x + w && y0 >= this.y && y0 <= this.y + h;
    }

    public String toString() {
        return this.name;
    }
}

