/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload.gui;

import com.sap.engine.frame.core.load.gui.ComponentInfo;
import com.sap.engine.services.classload.RemoteLoadContext;
import com.sap.engine.services.classload.gui.DiagramPanel;
import com.sap.engine.services.classload.gui.tree.ComponentTreeNode;
import com.sap.engine.services.classload.gui.tree.ComponentTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public abstract class ClassloadRuntimeView
extends JPanel {
    protected RemoteLoadContext remoteLoadContext;
    private ComponentInfo[] loaderWrappers;
    private ComponentTreePanel treePanel;
    private DiagramPanel diagramPanel;
    private Hashtable mapNames = new Hashtable();

    public ClassloadRuntimeView() {
        this.treePanel = new ComponentTreePanel(this);
        this.diagramPanel = new DiagramPanel(this);
        JScrollPane diagramScroll = new JScrollPane(this.diagramPanel);
        JSplitPane splitPane = new JSplitPane(1, this.treePanel, diagramScroll);
        splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    public void updateView(RemoteLoadContext remoteLoadContext) {
        this.remoteLoadContext = remoteLoadContext;
        try {
            this.loaderWrappers = remoteLoadContext.getLoaderWrappers();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            StringWriter buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            e.printStackTrace(out);
            this.popUpMessage(buffer.getBuffer().toString(), e.getClass().getName());
            this.loaderWrappers = new ComponentInfo[0];
        }
        this.treePanel.refreshTree();
        this.diagramPanel.clearPanel();
    }

    public ComponentInfo[] getComponentsInfo() {
        return this.loaderWrappers;
    }

    public ComponentTreeNode getComponentTreeNode(String componentName) {
        String fakeName = componentName;
        String realName = this.getRealName(fakeName);
        int i = 0;
        while (i < this.loaderWrappers.length) {
            if (this.loaderWrappers[i].getFullName().equals(realName)) {
                if (fakeName != realName) {
                    return new ComponentTreeNode(fakeName, fakeName, this.loaderWrappers[i]);
                }
                return new ComponentTreeNode(this.loaderWrappers[i]);
            }
            ++i;
        }
        return null;
    }

    public void drawComponent(ComponentTreeNode componentTreeNode) {
        this.diagramPanel.drawComponent(componentTreeNode);
    }

    public void expandComponent(ComponentTreeNode componentTreeNode) {
        this.treePanel.expandComponent(componentTreeNode);
    }

    public abstract void popUpMessage(String var1, String var2);

    public void registerNamePair(String fakeName, String realName) {
        this.mapNames.put(fakeName, realName);
        this.mapNames.put(realName, fakeName);
    }

    public String getRealName(String fakeName) {
        String realName = (String)this.mapNames.get(fakeName);
        if (realName != null) {
            return realName;
        }
        return fakeName;
    }

    public String getFakeName(String realName) {
        String fakeName = (String)this.mapNames.get(realName);
        if (fakeName == null) {
            fakeName = this.treePanel.getNextFakeName();
            this.registerNamePair(fakeName, realName);
        }
        return fakeName;
    }
}

