/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload.gui;

import java.awt.Color;
import java.awt.Graphics;

public class ArrowView {
    public String from;
    public String to;
    public int type;
    public Color color = Color.black;
    public int x1 = 0;
    public int y1 = 0;
    public int x2 = 0;
    public int y2 = 0;
    public static final byte ARROW_PARENT = 0;
    public static final byte ARROW_REFERENCES = 1;
    public static final byte ARROW_REFEREES = 2;
    public static final byte ARROW_COMMON = 3;
    public static final byte ARROW_OTHER = 4;
    public static final byte ARROW_BLADE_SIZE = 10;
    public static final byte ARROW_LENGTH_ARROW = 15;
    public static final double ARROW_BLADE_EANGLE = 0.3141592653589793;
    private static Color[] arrowColor = null;

    public ArrowView(String from, String to, int type) {
        this.from = from;
        this.to = to;
        this.type = type;
    }

    public void setPosition(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void paint(Graphics g) {
        g.setColor(ArrowView.getArrowColor(this.type));
        g.drawLine(this.x1, this.y1, this.x2, this.y2);
        this.drawBlade(g, this.x1, this.y1, this.x2, this.y2);
    }

    protected void drawBlade(Graphics g, int x1, int y1, int x2, int y2) {
        double eangle = 1.5707963267948966 - Math.atan2(x2 - x1, y2 - y1);
        int x = x2 - (int)(Math.cos(eangle + 0.3141592653589793) * 10.0);
        int y = y2 - (int)(Math.sin(eangle + 0.3141592653589793) * 10.0);
        g.drawLine(x2, y2, x, y);
        x = x2 - (int)(Math.cos(eangle - 0.3141592653589793) * 10.0);
        y = y2 - (int)(Math.sin(eangle - 0.3141592653589793) * 10.0);
        g.drawLine(x2, y2, x, y);
    }

    public static void setArrowColor(int type, Color color) {
        if (type >= 0 && type < arrowColor.length) {
            ArrowView.arrowColor[type] = color;
        }
    }

    public static Color getArrowColor(int type) {
        if (type >= 0 && type < arrowColor.length) {
            return arrowColor[type];
        }
        return arrowColor[4];
    }

    static {
        arrowColor = new Color[5];
        ArrowView.setArrowColor(0, Color.blue);
        ArrowView.setArrowColor(1, Color.red);
        ArrowView.setArrowColor(2, Color.green);
        ArrowView.setArrowColor(3, Color.gray);
        ArrowView.setArrowColor(4, Color.black);
    }
}

