/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload;

import com.sap.engine.frame.RuntimeProperties;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.gui.ComponentInfo;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.classload.RemoteLoadContext;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;

public final class RemoteLoadContextImpl
implements RemoteLoadContext {
    private LoadContext loadContext;
    private SecurityRole adminRole = null;
    private ThreadSystem threadSystem = null;

    RemoteLoadContextImpl(LoadContext loadContext, ThreadSystem threadSystem, SecurityRole adminRole) throws RemoteException {
        this.loadContext = loadContext;
        this.threadSystem = threadSystem;
        this.adminRole = adminRole;
    }

    public boolean register(ReferencedLoader loader) throws RemoteException, Exception {
        throw new UnsupportedOperationException();
    }

    public boolean unregister(ReferencedLoader loader) throws RemoteException, Exception {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader(String loaderName) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public Enumeration listLoaders() throws RemoteException {
        return this.loadContext.listLoaders();
    }

    public boolean registerReference(String fromLoader, String toLoader) throws RemoteException {
        this.checkIsAdmin();
        return this.loadContext.registerReference(fromLoader, toLoader);
    }

    public boolean unregisterReference(String fromLoader, String toLoader) throws RemoteException {
        this.checkIsAdmin();
        return this.loadContext.unregisterReference(fromLoader, toLoader);
    }

    public boolean isNewCycle(String from, String to) throws RemoteException {
        return this.loadContext.isNewCycle(from, to);
    }

    public String[] getReferences(String loaderName) throws RemoteException {
        return this.loadContext.getReferences(loaderName);
    }

    public String[] getReferencesFrom(String loaderName) throws RemoteException {
        return this.loadContext.getReferencesFrom(loaderName);
    }

    public String[] getResourceNames(String loaderName) throws RemoteException {
        return this.loadContext.getResourceNames(loaderName);
    }

    public void clearUnloadableContainer() throws RemoteException {
        this.loadContext.clearUnloadableContainer();
    }

    public void clearUnloadableContainer(String loaderName) throws RemoteException {
        this.loadContext.clearUnloadableContainer(loaderName);
    }

    public Enumeration findResources(String fileName) throws RemoteException, IOException {
        return this.loadContext.findResources(fileName);
    }

    public Enumeration findResources(String fileName, String loaderName) throws RemoteException, IOException {
        return this.loadContext.findResources(fileName, loaderName);
    }

    public ComponentInfo getLoaderWrapper(String loaderName) throws RemoteException {
        return this.loadContext.getLoaderWrapper(loaderName);
    }

    public ComponentInfo[] getLoaderWrappers() throws RemoteException {
        return this.loadContext.getLoaderWrappers();
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    void checkIsAdmin() {
        if (this.threadSystem.getThreadContext() != null) {
            if (this.adminRole == null) {
                throw new SecurityException(RuntimeProperties.get((int)2) + " not authorized. Administrator's role cannot be found on this cluster node!");
            }
            if (!this.adminRole.isCallerInRole()) {
                throw new SecurityException("User " + RuntimeProperties.get((int)2) + " not authorized, only administrators are allowed to perform remote operations with ClassLoaderManager");
            }
        }
    }

    static void dump(String s) {
        System.out.println("SECURITY_DUMP: " + s);
    }
}

