/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.classload;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.classload.RemoteLoadContextImpl;
import java.rmi.RemoteException;

public class ClassLoadServiceFrame
implements ApplicationServiceFrame,
CommunicationServiceFrame {
    private static final String SECURITY_SERVICE_NAME = "security";
    private ApplicationServiceContext serverContext;
    private CommunicationServiceContext dispatcherContext;
    private RemoteLoadContextImpl managementInterface;
    private LoadContext loadContext;
    private ThreadSystem threadSystem;

    public void start(CommunicationServiceContext dispatcherContext) throws ServiceException {
        this.dispatcherContext = dispatcherContext;
        this.loadContext = dispatcherContext.getCoreContext().getLoadContext();
        this.threadSystem = dispatcherContext.getCoreContext().getThreadSystem();
        try {
            this.initManagementInterface();
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        dispatcherContext.getServiceState().registerManagementInterface((ManagementInterface)this.managementInterface);
        dispatcherContext.getContainerContext().getObjectRegistry().registerInterface((Object)this.managementInterface);
    }

    public void start(ApplicationServiceContext serverContext) throws ServiceException {
        this.serverContext = serverContext;
        this.loadContext = serverContext.getCoreContext().getLoadContext();
        this.threadSystem = serverContext.getCoreContext().getThreadSystem();
        SecurityContext securityContext = (SecurityContext)serverContext.getContainerContext().getObjectRegistry().getServiceInterface(SECURITY_SERVICE_NAME);
        SecurityRole adminRole = securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole("administrators");
        try {
            this.initManagementInterface(adminRole);
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        serverContext.getServiceState().registerManagementInterface((ManagementInterface)this.managementInterface);
        serverContext.getContainerContext().getObjectRegistry().registerInterface((Object)this.managementInterface);
    }

    public void stop() throws ServiceRuntimeException {
        if (this.serverContext != null) {
            this.serverContext.getServiceState().unregisterManagementInterface();
            this.serverContext.getContainerContext().getObjectRegistry().unregisterInterface();
        } else if (this.dispatcherContext != null) {
            this.dispatcherContext.getServiceState().unregisterManagementInterface();
            this.dispatcherContext.getContainerContext().getObjectRegistry().unregisterInterface();
        }
        this.serverContext = null;
        this.dispatcherContext = null;
        this.loadContext = null;
        this.threadSystem = null;
        this.managementInterface = null;
    }

    public void initManagementInterface(SecurityRole adminRole) throws RemoteException {
        if (this.managementInterface == null) {
            this.managementInterface = new RemoteLoadContextImpl(this.loadContext, this.threadSystem, adminRole);
        }
    }

    public void initManagementInterface() throws RemoteException {
        if (this.managementInterface == null) {
            this.managementInterface = new RemoteLoadContextImpl(this.loadContext, this.threadSystem, null);
        }
    }
}

