/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.web;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.JlinUtils;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    File pluginRoot;
    DirsAndFiles daf;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$web$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$web$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.web.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$web$CreateBuildFileAction));
    int br = 0;
    String errMsg = "";
    private IBuildInfo buildInfo;
    JlinUtils jlinUtils;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$web$CreateBuildFileAction;

    CreateBuildFileAction(DirsAndFiles pdaf, File root, IBuildInfo buildInfo) {
        this.daf = pdaf;
        this.pluginRoot = root;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
        this.jlinUtils = new JlinUtils(buildInfo);
    }

    public BuildActionResult execute() {
        this.loc.infoT("Web Plugin starts creating the build file");
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        FileCreator fCreator = new FileCreator();
        fCreator.setDaf(this.daf);
        fCreator.setPluginRoot(this.pluginRoot);
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            fCreator.setListContext("dc_public_parts", pp.getList());
        }
        fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        try {
            fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        this.jlinUtils.insertJlinContext(fCreator);
        List dependDirs = this.daf.getDependDirs();
        HashMap<String, String> AntPropsDependDirs = new HashMap<String, String>();
        ArrayList<String> AntPropsDependJars = new ArrayList<String>();
        if (dependDirs != null) {
            Iterator it = dependDirs.iterator();
            int no = 0;
            while (it.hasNext()) {
                String dir = (String)it.next();
                AntPropsDependDirs.put("dependDir_" + ++no, dir);
                File dirFile = new File(dir);
                if (!dirFile.exists()) continue;
                String[] allFilesInFolder = dirFile.list();
                int i = 0;
                while (i < allFilesInFolder.length) {
                    String curFileName = dir + File.separator + allFilesInFolder[i];
                    if (curFileName.endsWith(".jar") || curFileName.endsWith(".zip")) {
                        AntPropsDependJars.add(curFileName);
                    }
                    ++i;
                }
            }
        }
        fCreator.setHashMapContext("dc_depend_compileDirs", AntPropsDependDirs);
        fCreator.setListContext("dc_depend_compileArchives", AntPropsDependJars);
        List packageDirs = this.daf.getPackageDirs();
        fCreator.setListContext("dc_packageDirs", packageDirs);
        List sourceDirs = this.daf.getSourceDirs();
        fCreator.setListContext("dc_sourceDirs", sourceDirs);
        fCreator.setStrContext("dc_gen_classesDir", this.daf.getClassesDir());
        fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        List assDep = this.daf.getAssemblyDirs();
        fCreator.setListContext("dc_ass_dep", assDep);
        fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        fCreator.setStrContext("dc_gen_logDir", this.daf.getLogDir());
        fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        HashMap buildOptions = this.daf.getBuildOptions();
        fCreator.setHashMapContext("dc_build_options", buildOptions);
        fCreator.setHashMapContext("dc_jdo_files", this.daf.getJdoMap());
        if (this.daf.hasSQLJ()) {
            fCreator.setStrContext("sqlj_exist", "true");
        } else {
            fCreator.setStrContext("sqlj_exist", "false");
        }
        if (this.br != 2 && this.br != 3) {
            fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

