/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.http;

import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.http.FilePart;
import com.sapportals.portal.prt.util.http.ParamPart;
import com.sapportals.portal.prt.util.http.Part;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class MultiPartParser {
    private static final String SEMI_COMMA_STRING = ";";
    private static final String COMMA_SPACE_STRING = ": ";
    private BufferedInputStream mm_in = null;
    private PartInputStream mm_partIn = null;
    private byte[] mm_boundary = null;
    private boolean mm_end = false;
    private boolean mm_init = true;
    private Hashtable mm_header = new Hashtable();
    private final int MAXCHUNKSIZE = 4096;
    private Hashtable mm_parameterParts = null;
    private Hashtable mm_fileParts = null;
    private boolean mm_partParsed = false;
    private RecyclableStringBuffer mm_buffer = new RecyclableStringBuffer();
    private static final String QUOT_CHARACTER_STRING = "\"";
    private static final char QUOT_CHARACTER = '\"';
    private static final String EQUALS_CHARACTER_STRING = "=\"";
    private static final char SPACE_STRING = ' ';
    private static final String EMPTY_STRING = "";
    private static final char CHAR_EQUALS_CHAR = '=';
    private static final int CHAR_EQUALS = 61;

    public MultiPartParser(InputStream in, String boundary) throws IOException {
        this.mm_boundary = boundary.getBytes();
        int limit = this.mm_boundary.length + 2 + 4 + 4096 - 1;
        this.mm_in = new BufferedInputStream(in, limit);
        this.mm_partIn = new PartInputStream(this.mm_in, this.mm_boundary, limit);
        this.proceedToNextPart();
    }

    public boolean onValidPart() {
        return !this.mm_end;
    }

    public void proceedToNextPart() throws IOException {
        int c = 0;
        int found = -1;
        while (found < 0 && (c = this.mm_in.read()) != -1) {
            if (c == 13) {
                found = this.checkForBoundary(this.mm_in, this.mm_boundary, 1);
                continue;
            }
            if (c != 45 || !this.mm_init) continue;
            found = this.checkForBoundary(this.mm_in, this.mm_boundary, 3);
        }
        this.mm_init = false;
        boolean bl = this.mm_end = found < 0 || found == 2;
        if (!this.mm_end) {
            this.readHeader();
            this.mm_partIn.renew();
        }
    }

    public Enumeration getHeaderFields() {
        return this.mm_header.keys();
    }

    public String getHeaderValue(String header) {
        return (String)this.mm_header.get(header);
    }

    public InputStream getPartInputStream() {
        if (this.onValidPart()) {
            return this.mm_partIn;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void readHeader() throws IOException {
        int c;
        String value = null;
        String key = null;
        int char_delimiter = 58;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(128);
        while ((c = this.mm_in.read()) != -1) {
            void var4_5;
            if (var4_5 == 13) {
                if (buffer.size() <= 1) {
                    this.mm_in.read();
                    break;
                }
                String line = buffer.toString();
                int ind = line.indexOf(char_delimiter);
                if (ind != -1) {
                    key = line.substring(0, ind);
                    value = line.substring(ind + 1, line.length());
                    this.mm_header.put(key, value);
                }
                buffer.reset();
                continue;
            }
            if (var4_5 == 10) continue;
            buffer.write((int)var4_5);
        }
    }

    private int checkForBoundary(InputStream in, byte[] boundary, int initialState) throws IOException {
        int state = initialState;
        int c = 0;
        int bc = 0;
        while (state >= 0 && (c = in.read()) != -1) {
            switch (state) {
                case 0: {
                    if (c == 13) {
                        state = 1;
                        break;
                    }
                    if (c != 45) break;
                    state = 3;
                    break;
                }
                case 1: {
                    if (c == 10) {
                        state = 2;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (c == 45) {
                        state = 3;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    if (c == 45) {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 4: {
                    bc = 0;
                    state = 5;
                }
                case 5: {
                    if (c != boundary[bc++]) {
                        state = -1;
                        break;
                    }
                    if (bc != boundary.length) break;
                    state = 6;
                    break;
                }
                case 6: {
                    if (c == 13) {
                        state = 7;
                        break;
                    }
                    if (c == 45) {
                        state = 8;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 7: {
                    if (c == 10) {
                        state = -2;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 8: {
                    state = c == 45 ? -3 : -1;
                }
            }
        }
        switch (state) {
            case -2: {
                return 1;
            }
            case -3: {
                return 2;
            }
        }
        return -1;
    }

    public Hashtable getParameterParts() {
        if (!this.mm_partParsed) {
            this.parseParts();
        }
        return this.mm_parameterParts;
    }

    public Hashtable getFileParts() {
        if (!this.mm_partParsed) {
            this.parseParts();
        }
        return this.mm_fileParts;
    }

    /*
     * WARNING - void declaration
     */
    private void parseParts() {
        this.mm_parameterParts = new Hashtable(10);
        this.mm_fileParts = new Hashtable(10);
        if (this.onValidPart()) {
            while (this.onValidPart()) {
                String name = null;
                String filename = null;
                String partname = null;
                String contentType = "text/plain";
                Enumeration headers = this.getHeaderFields();
                if (headers != null) {
                    while (headers.hasMoreElements()) {
                        name = (String)headers.nextElement();
                        String value = this.getHeaderValue(name);
                        if (name.equalsIgnoreCase("content-disposition")) {
                            partname = this.getQuotedValue("name", value);
                            filename = this.getQuotedValue("filename", value);
                        }
                        if (!name.equalsIgnoreCase("content-type") || (contentType = this.getValue("Content-Type", value)).length() != 0) continue;
                        contentType = "text/plain";
                    }
                }
                Part part = null;
                InputStream partIn = this.getPartInputStream();
                if (partIn != null) {
                    if (contentType.equalsIgnoreCase("application/zip")) {
                        part = new FilePart(partname, filename, contentType, partIn);
                        this.mm_fileParts.put(partname, part);
                    } else if (filename != null && filename.length() > 0) {
                        part = new FilePart(partname, filename, contentType, partIn);
                        this.mm_fileParts.put(partname, part);
                    } else if (contentType.equalsIgnoreCase("application/octet-stream")) {
                        try {
                            this.mm_parameterParts.put(partname, this.loadPropertiesFast(partIn));
                        }
                        catch (Exception ex) {}
                    } else {
                        byte[] value;
                        try {
                            int read;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                            byte[] buf = new byte[128];
                            while ((read = partIn.read(buf)) != -1) {
                                void var11_14;
                                baos.write(buf, 0, (int)var11_14);
                            }
                            partIn.close();
                            baos.close();
                            value = baos.toByteArray();
                        }
                        catch (IOException ex) {
                            value = new byte[]{};
                        }
                        ParamPart ppart = new ParamPart(partname);
                        ppart.setValue(value);
                        part = ppart;
                        this.mm_parameterParts.put(partname, part);
                    }
                } else {
                    System.out.println("Failed to retrieve a part inputstream&lt;br&gt;");
                }
                try {
                    this.proceedToNextPart();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.mm_partParsed = true;
    }

    private Properties loadPropertiesFast(InputStream mm_in) throws UnsupportedEncodingException, IOException {
        Properties p = new Properties();
        BufferedReader in = new BufferedReader(new InputStreamReader(mm_in, "8859_1"), 8192);
        String line = null;
        int firstChar = 32;
        Object tokens = null;
        while ((line = in.readLine()) != null) {
            int ind;
            if (line.length() <= 1 || (firstChar = (int)line.charAt(0)) == 35 || firstChar == 33 || (ind = line.indexOf(61)) == 1) continue;
            ((Hashtable)p).put(line.substring(0, ind), line.substring(ind + 1));
        }
        return p;
    }

    private String getQuotedValue(String name, String line) {
        int end;
        this.mm_buffer.realloc(name.length() + 5);
        this.mm_buffer.getBuffer().append(' ');
        this.mm_buffer.getBuffer().append(name);
        this.mm_buffer.getBuffer().append(EQUALS_CHARACTER_STRING);
        String cmpString = this.mm_buffer.toString();
        int nameIndex = line.indexOf(cmpString);
        String nameString = EMPTY_STRING;
        if (nameIndex != -1 && (end = line.indexOf(34, nameIndex += cmpString.length())) != -1) {
            nameString = line.substring(nameIndex, end);
        }
        return nameString;
    }

    private String getValue(String name, String line) {
        this.mm_buffer.realloc(name.length() + 5);
        this.mm_buffer.getBuffer().append(name);
        this.mm_buffer.getBuffer().append(COMMA_SPACE_STRING);
        String cmpString = this.mm_buffer.toString();
        int nameIndex = line.indexOf(cmpString);
        String nameString = EMPTY_STRING;
        if (nameIndex != -1) {
            int endIndex = line.indexOf(SEMI_COMMA_STRING, nameIndex += cmpString.length());
            if (nameIndex != -1) {
                nameString = line.substring(nameIndex, endIndex);
            }
        } else {
            nameString = line;
            nameIndex = nameString.indexOf(SEMI_COMMA_STRING);
            if (nameIndex != -1) {
                nameString = nameString.substring(0, nameIndex);
            }
        }
        return nameString.trim();
    }

    private class PartInputStream
    extends InputStream {
        private BufferedInputStream mm_in = null;
        private int mm_bufferLimit = 0;
        private int mm_chunkSize = 0;
        private int mm_maxBoundarySpace = 0;
        private byte[] mm_boundary;
        private boolean mm_end = false;
        private int mm_count = 0;

        public PartInputStream(BufferedInputStream in, byte[] boundary, int limit) {
            this.mm_in = in;
            this.mm_boundary = boundary;
            this.mm_bufferLimit = limit;
            this.mm_maxBoundarySpace = boundary.length + 2 + 4;
            this.mm_chunkSize = limit - this.mm_maxBoundarySpace + 1;
            this.renew();
        }

        public void renew() {
            this.mm_end = false;
            this.mm_count = 0;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.mm_end) {
                return -1;
            }
            int act = off;
            while (!this.mm_end && len > 0) {
                int cur = len > this.mm_chunkSize ? this.mm_chunkSize : len;
                this.mm_in.mark(cur + this.mm_maxBoundarySpace - 1);
                int ret = this.mm_in.read(buf, act, cur);
                if (ret == -1) {
                    this.mm_end = true;
                    continue;
                }
                int cnt = act;
                int i = 0;
                while (i < ret) {
                    byte c;
                    if ((c = buf[cnt++]) == 13) {
                        this.mm_in.reset();
                        this.mm_in.skip(i + 1);
                        if (MultiPartParser.this.checkForBoundary(this.mm_in, this.mm_boundary, 1) >= 0) {
                            this.mm_in.reset();
                            this.mm_in.skip(i);
                            ret = i;
                            this.mm_end = true;
                        }
                    }
                    ++i;
                }
                if (!this.mm_end) {
                    this.mm_in.reset();
                    this.mm_in.skip(ret);
                }
                act += ret;
                len -= ret;
            }
            return act - off;
        }

        public int read() throws IOException {
            if (this.mm_end) {
                return -1;
            }
            this.mm_in.mark(this.mm_bufferLimit);
            int c = this.mm_in.read();
            if (c == -1) {
                this.mm_end = true;
            } else if (c == 13) {
                if (MultiPartParser.this.checkForBoundary(this.mm_in, this.mm_boundary, 1) >= 0) {
                    this.mm_in.reset();
                    this.mm_end = true;
                    c = -1;
                } else {
                    this.mm_in.reset();
                    this.mm_in.skip(1L);
                }
            }
            return c;
        }
    }
}

