/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlInlineScript;
import com.sapportals.portal.prt.util.html.HtmlSinglePartElement;
import com.sapportals.portal.prt.util.html.IHtmlEventListener;
import com.sapportals.portal.prt.util.html.IHtmlIdentifiable;
import com.sapportals.portal.prt.util.html.Stringable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

public class HtmlImage
extends HtmlSinglePartElement
implements IHtmlEventListener,
IHtmlIdentifiable {
    protected String m_src;
    protected ImageAlign m_alignment;
    protected String m_width;
    protected String m_height;
    protected String m_alt;
    protected String m_hSpace;
    protected String m_vSpace;
    protected String m_border;
    protected HtmlInlineScript m_onKeyPress;
    protected HtmlInlineScript m_onKeyDown;
    protected HtmlInlineScript m_onKeyUp;
    protected HtmlInlineScript m_onClick;
    protected HtmlInlineScript m_onMouseOver;

    public HtmlImage() {
        this.setTag("img");
        this.m_alt = null;
        this.m_attributes = new Hashtable();
    }

    public HtmlImage(String src) {
        this();
        if (src != null) {
            this.setSrc(src);
        }
    }

    public void outputAttributes(StringBuffer strbuf) {
        if (this.m_name != null) {
            strbuf.append(" NAME=\"").append(this.m_name).append("\" ");
        }
        if (this.m_src != null) {
            strbuf.append(" SRC=\"").append(this.m_src).append("\" ");
        }
        if (this.m_alignment != null) {
            strbuf.append(" ALIGN=").append(this.m_alignment).append(" ");
        }
        if (this.m_width != null) {
            strbuf.append(" WIDTH=\"").append(this.m_width).append("\" ");
        }
        if (this.m_height != null) {
            strbuf.append(" HEIGHT=\"").append(this.m_height).append("\" ");
        }
        if (this.m_alt != null) {
            strbuf.append(" ALT=\"").append(this.m_alt).append("\" ");
        }
        if (this.m_vSpace != null) {
            strbuf.append(" VSPACE=").append(this.m_vSpace).append(" ");
        }
        if (this.m_hSpace != null) {
            strbuf.append(" HSPACE=").append(this.m_hSpace).append(" ");
        }
        if (this.m_border != null) {
            strbuf.append(" BORDER=").append(this.m_border).append(" ");
        }
        if (this.m_onKeyPress != null) {
            strbuf.append(" onKeyPress=\"");
            this.m_onKeyPress.output(strbuf);
            strbuf.append("\" ");
        }
        if (this.m_onKeyUp != null) {
            strbuf.append(" onKeyUp=\"").append(this.m_onKeyUp).append("\" ");
        }
        if (this.m_onKeyDown != null) {
            strbuf.append(" onKeyDown=\"").append(this.m_onKeyDown).append("\" ");
        }
        if (this.m_onClick != null) {
            strbuf.append(" onClick=\"");
            this.m_onClick.output(strbuf);
            strbuf.append("\" ");
        }
        if (this.m_onMouseOver != null) {
            strbuf.append(" onMouseOver=\"");
            this.m_onMouseOver.output(strbuf);
            strbuf.append("\" ");
        }
        super.outputAttributes(strbuf);
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        StringBuffer buf = new StringBuffer(this.m_src.length() + 60);
        this.outputAttributes(buf);
        try {
            out.write(buf.toString());
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
    }

    public void setID(String id) {
        this.addAttribute("id", id);
    }

    public void setClass(String element_class) {
        this.addAttribute("class", element_class);
    }

    public String getSrc() {
        return this.m_src;
    }

    public HtmlImage setSrc(String v) {
        this.m_src = v;
        return this;
    }

    public ImageAlign getAlignment() {
        return this.m_alignment;
    }

    public HtmlImage setAlignment(ImageAlign v) {
        this.m_alignment = v;
        return this;
    }

    public String getWidth() {
        return this.m_width;
    }

    public HtmlImage setWidth(String v) {
        this.m_width = v;
        return this;
    }

    public String getHeight() {
        return this.m_height;
    }

    public HtmlImage setHeight(String v) {
        this.m_height = v;
        return this;
    }

    public String getAlt() {
        return this.m_alt;
    }

    public HtmlImage setAlt(String v) {
        this.m_alt = v;
        return this;
    }

    public String getHSpace() {
        return this.m_hSpace;
    }

    public HtmlImage setHSpace(String v) {
        this.m_hSpace = v;
        return this;
    }

    public String getVSpace() {
        return this.m_vSpace;
    }

    public HtmlImage setVSpace(String v) {
        this.m_vSpace = v;
        return this;
    }

    public String getBorder() {
        return this.m_border;
    }

    public HtmlImage setBorder(String v) {
        this.m_border = v;
        return this;
    }

    public HtmlImage setBorder(int v) {
        this.m_border = Integer.toString(v);
        return this;
    }

    public HtmlInlineScript getOnKeyPress() {
        return this.m_onKeyPress;
    }

    public IHtmlEventListener setOnKeyPress(HtmlInlineScript v) {
        this.m_onKeyPress = v;
        return this;
    }

    public HtmlInlineScript getOnKeyDown() {
        return this.m_onKeyDown;
    }

    public IHtmlEventListener setOnKeyDown(HtmlInlineScript v) {
        this.m_onKeyDown = v;
        return this;
    }

    public HtmlInlineScript getOnKeyUp() {
        return this.m_onKeyUp;
    }

    public IHtmlEventListener setOnKeyUp(HtmlInlineScript v) {
        this.m_onKeyUp = v;
        return this;
    }

    public HtmlInlineScript getOnClick() {
        return this.m_onClick;
    }

    public IHtmlEventListener setOnClick(HtmlInlineScript v) {
        this.m_onClick = v;
        return this;
    }

    public HtmlInlineScript getOnMouseOver() {
        return this.m_onMouseOver;
    }

    public IHtmlEventListener setOnMouseOver(HtmlInlineScript v) {
        this.m_onMouseOver = v;
        return this;
    }

    public void destroy() {
        super.destroy();
    }

    public static class ImageAlign
    extends Stringable {
        public static final ImageAlign TOP = new ImageAlign("TOP");
        public static final ImageAlign MIDDLE = new ImageAlign("MIDDLE");
        public static final ImageAlign ABSMIDDLE = new ImageAlign("ABSMIDDLE");
        public static final ImageAlign BOTTOM = new ImageAlign("BOTTOM");

        private ImageAlign(String string) {
            super(string);
        }
    }
}

