/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.AbstractPool;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import java.util.HashMap;

public class StringBufferPool
extends AbstractPool {
    protected static StringBufferPool m_corePoolFactory;
    protected static HashMap mm_namedPools;
    protected static final String DEFAULT_POOL_NAME = "com.sap.portal.runtime.pool.StringBufferPool";
    protected static final int STRINGBUFFER_INITIALCAPACITY = 16;
    protected static final int STRINGBUFFER_INITIALNBINSTANCES = 0;
    protected static final int STRINGBUFFER_MAX_POOLSIZE = 50;
    protected String mm_poolName;

    public static StringBufferPool getInstance() {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.getInstanceInternal(DEFAULT_POOL_NAME);
    }

    protected static void ensureInitialized() {
        if (m_corePoolFactory == null) {
            throw new IllegalStateException("StringBufferPool factory not initialized.");
        }
    }

    public static StringBufferPool getInstance(String poolName) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.getInstanceInternal(poolName);
    }

    public static StringBufferPool createInstance(String poolName, int intialCapacity) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.createInstanceInternal(poolName, intialCapacity, 0, 50);
    }

    public static StringBufferPool createInstance(String poolName, int intialCapacity, int initialNbInstances) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.createInstanceInternal(poolName, intialCapacity, initialNbInstances, 50);
    }

    public static StringBufferPool createInstance(String poolName, int intialCapacity, int initialNbInstances, int maxPoolSize) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.createInstanceInternal(poolName, intialCapacity, initialNbInstances, maxPoolSize);
    }

    public static synchronized void deleteInstance(String poolName) {
        StringBufferPool.ensureInitialized();
        mm_namedPools.remove(poolName);
    }

    protected StringBufferPool(int initialCapacity, int initialNbInstances, int maxSize) {
        super(initialCapacity, initialNbInstances, maxSize);
    }

    protected boolean validatePoolObject(Object o) {
        RecyclableStringBuffer strbuf = (RecyclableStringBuffer)o;
        strbuf.m_isReleasable = false;
        strbuf.getBuffer().m_shared = false;
        return true;
    }

    protected Object createPoolObject() throws Exception {
        return new RecyclableStringBuffer(this);
    }

    protected void expirePoolObject(Object o) {
    }

    public RecyclableStringBuffer get(int size) {
        try {
            RecyclableStringBuffer strbuf = (RecyclableStringBuffer)this.getPoolObject();
            strbuf.realloc(size);
            return strbuf;
        }
        catch (Exception e) {
            ILogger logger = PortalRuntime.getLogger("debug_logger");
            if (logger.isActive()) {
                PortalRuntimeException prException = new PortalRuntimeException(e);
                logger.warning(this, prException, "Error in get(" + size + ")");
            }
            RecyclableStringBuffer strbuf = null;
            try {
                strbuf = (RecyclableStringBuffer)this.createPoolObject();
            }
            catch (Exception e1) {
                throw new PortalRuntimeException("Cannot create RecyclableStringBuffer.", e1);
            }
            strbuf.realloc(size);
            return strbuf;
        }
    }

    public void release(RecyclableStringBuffer rStrBuf) {
        if (rStrBuf == null) {
            return;
        }
        rStrBuf.release();
        if (rStrBuf.isReleasable()) {
            rStrBuf.realloc(0);
            rStrBuf.m_isReleasable = false;
            this.releasePoolObject(rStrBuf);
        }
    }

    String getName() {
        return this.mm_poolName;
    }

    void setName(String name) {
        this.mm_poolName = name;
    }

    protected StringBufferPool createInstanceInternal(String poolName, int intialCapacity) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.createInstanceInternal(poolName, intialCapacity, 0, 50);
    }

    protected StringBufferPool createInstanceInternal(String poolName, int intialCapacity, int initialNbInstances) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.createInstanceInternal(poolName, intialCapacity, initialNbInstances, 50);
    }

    protected StringBufferPool createInstanceInternal(String poolName, int intialCapacity, int initialNbInstances, int maxPoolSize) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.createInstanceInternal(poolName, intialCapacity, initialNbInstances, maxPoolSize);
    }

    protected StringBufferPool getInstanceInternal() {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.getInstanceInternal();
    }

    protected StringBufferPool getInstanceInternal(String poolName) {
        StringBufferPool.ensureInitialized();
        return m_corePoolFactory.getInstanceInternal(poolName);
    }

    static {
        mm_namedPools = new HashMap();
    }
}

