/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.SharedString;
import com.sapportals.portal.prt.util.StringBufferPool;
import java.io.IOException;
import java.io.Writer;

public class SmartStringWriter
extends Writer {
    protected RecyclableStringBuffer m_buf;
    protected boolean m_closed;
    protected String m_poolName;

    public SmartStringWriter() {
        this.initBuffer(4096);
    }

    public SmartStringWriter(int initialSize) {
        try {
            this.initBuffer(initialSize);
            this.m_closed = false;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void initBuffer(int initialSize) {
        this.m_buf = this.getStringBufferPool().get(initialSize);
    }

    protected StringBufferPool getStringBufferPool() {
        return StringBufferPool.getInstance();
    }

    public void write(int c) throws IOException {
        if (this.m_closed) {
            throw new IOException("[SmartStringWriter] writer closed");
        }
        this.m_buf.getBuffer().append(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.m_closed) {
            throw new IOException("[SmartStringWriter] writer closed");
        }
        if (len == 0) {
            return;
        }
        this.m_buf.getBuffer().append(cbuf, off, len);
    }

    public void write(char[] parm1) throws IOException {
        if (this.m_closed) {
            throw new IOException("[SmartStringWriter] writer closed");
        }
        this.m_buf.getBuffer().append(parm1);
    }

    public void write(String str, int off, int len) throws IOException {
        if (str != null) {
            if (off == 0 && str.length() == len) {
                this.write(str);
            } else {
                char[] buf = str.toCharArray();
                this.write(buf, off, len);
            }
        }
    }

    public void write(String str) throws IOException {
        if (this.m_closed) {
            throw new IOException("[SmartStringWriter] writer closed");
        }
        this.m_buf.getBuffer().append(str);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (this.m_closed) {
            throw new IOException("[SmartStringWriter] writer already closed");
        }
        this.getStringBufferPool().release(this.m_buf);
        this.m_buf = null;
        this.m_closed = true;
    }

    public String toString() {
        if (this.m_buf != null) {
            return this.m_buf.getBuffer().toString();
        }
        return null;
    }

    public SharedString getSharedString() {
        if (this.m_buf != null) {
            return this.m_buf.getSharedString();
        }
        return null;
    }

    public void finalize() {
        if (this.m_buf != null) {
            this.getStringBufferPool().release(this.m_buf);
        }
    }

    public void realloc(int size) {
        this.m_buf.realloc(size);
    }
}

