/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

public class SmartBuffer {
    private int CAPACITY_THRESHOLD = 30720;
    private float CAPACITY_FACTOR = 1.2f;
    public boolean m_shared;
    private static final int INIT_SIZE = 32;
    protected char[] m_buff = null;
    protected int m_length = 0;

    SmartBuffer() {
        this.m_buff = new char[32];
        this.m_length = 0;
        this.m_shared = false;
    }

    SmartBuffer(int initialSize) {
        this.m_buff = new char[initialSize];
        this.m_length = 0;
        this.m_shared = false;
    }

    public final SmartBuffer append(char ch) {
        if (this.m_length == this.m_buff.length) {
            this.ensureCapacity(this.m_length + 1);
        }
        this.m_buff[this.m_length] = ch;
        ++this.m_length;
        return this;
    }

    public final SmartBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public final void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this.m_buff.length) {
            return;
        }
        this.ensureNotShared();
        int newCapacity = this.m_buff.length;
        newCapacity = newCapacity > this.CAPACITY_THRESHOLD ? (int)((float)this.m_buff.length * this.CAPACITY_FACTOR) : this.m_buff.length + 1 << 1;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.m_buff, 0, newValue, 0, this.m_length);
        this.m_buff = newValue;
        this.m_shared = false;
    }

    public SmartBuffer append(char[] str, int o, int len) {
        int newcount = this.m_length + len;
        if (newcount > this.m_buff.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(str, o, this.m_buff, this.m_length, len);
        this.m_length = newcount;
        return this;
    }

    public SmartBuffer append(char[] c) {
        return this.append(c, 0, c.length);
    }

    public SmartBuffer append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.m_length + (len = str.length())) > this.m_buff.length) {
            this.ensureCapacity(newcount);
        }
        str.getChars(0, len, this.m_buff, this.m_length);
        this.m_length = newcount;
        return this;
    }

    public char charAt(int index) {
        return this.m_buff[index];
    }

    public void setCharAt(int index, char ch) {
        this.m_buff[index] = ch;
    }

    public SmartBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public String toString() {
        return new String(this.m_buff, 0, this.m_length);
    }

    public final int length() {
        return this.m_length;
    }

    public final int capacity() {
        return this.m_buff.length;
    }

    public final void reset() {
        this.ensureNotShared();
        this.m_length = 0;
    }

    private void ensureNotShared() {
        if (this.m_shared) {
            throw new IllegalStateException();
        }
    }
}

