/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import java.io.Serializable;
import java.util.Random;

public class Guid
implements Serializable {
    static final int[] s_digitsForChar = new int[255];
    static final char[] s_digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static byte[] s_intbuffer = new byte[16];
    static Random s_rndm = new Random();
    protected long m_part1;
    protected long m_part2;
    private transient int m_hashCode;

    private static final void copyHexStringIntoBuffer(char[] buf, int offset, long l) {
        int charPos = offset + 16;
        int i = 0;
        while (i < 16) {
            buf[--charPos] = s_digits[(int)(l & 0xFL)];
            l >>>= 4;
            ++i;
        }
    }

    public static final String longToHexString(long l) {
        char[] buf = new char[16];
        Guid.copyHexStringIntoBuffer(buf, 0, l);
        return new String(buf);
    }

    public static final String longToHexString(Long l) {
        char[] buf = new char[16];
        Guid.copyHexStringIntoBuffer(buf, 0, l);
        return new String(buf);
    }

    private static final void copyBinaryStringIntoBuffer(char[] buf, int offset, long l) {
        buf[offset++] = (char)(l >>> 56 & 0xFFL);
        buf[offset++] = (char)(l >>> 48 & 0xFFL);
        buf[offset++] = (char)(l >>> 40 & 0xFFL);
        buf[offset++] = (char)(l >>> 32 & 0xFFL);
        buf[offset++] = (char)(l >>> 24 & 0xFFL);
        buf[offset++] = (char)(l >>> 16 & 0xFFL);
        buf[offset++] = (char)(l >>> 8 & 0xFFL);
        buf[offset] = (char)(l & 0xFFL);
    }

    private static final void copyBinaryStringIntoBuffer(byte[] buf, int offset, long l) {
        buf[offset++] = (byte)(l >>> 56 & 0xFFL);
        buf[offset++] = (byte)(l >>> 48 & 0xFFL);
        buf[offset++] = (byte)(l >>> 40 & 0xFFL);
        buf[offset++] = (byte)(l >>> 32 & 0xFFL);
        buf[offset++] = (byte)(l >>> 24 & 0xFFL);
        buf[offset++] = (byte)(l >>> 16 & 0xFFL);
        buf[offset++] = (byte)(l >>> 8 & 0xFFL);
        buf[offset] = (byte)(l & 0xFFL);
    }

    public static final void copyGuidIntoBuffer(char[] buf, int offset, Guid guid) {
        Guid.copyHexStringIntoBuffer(buf, offset, guid.m_part1);
        Guid.copyHexStringIntoBuffer(buf, offset + 16, guid.m_part2);
    }

    public static final void copyBinaryGuidIntoBuffer(char[] buf, int offset, Guid guid) {
        Guid.copyBinaryStringIntoBuffer(buf, offset, guid.m_part1);
        Guid.copyBinaryStringIntoBuffer(buf, offset + 8, guid.m_part2);
    }

    public static final void copyBinaryGuidIntoBuffer(byte[] buf, int offset, Guid guid) {
        Guid.copyBinaryStringIntoBuffer(buf, offset, guid.m_part1);
        Guid.copyBinaryStringIntoBuffer(buf, offset + 8, guid.m_part2);
    }

    private static final void copyBytesIntoBuffer(byte[] buf, int offset, long lll) {
        int bytePos = offset + 8;
        int i = 0;
        while (i < 8) {
            buf[--bytePos] = (byte)(lll & 0xFFL);
            lll >>>= 8;
            ++i;
        }
    }

    public static final Guid parseHexString(String s) {
        return new Guid(Guid.parseLongHex(s, 0), Guid.parseLongHex(s, 16));
    }

    public static final Guid parseHexCharArray(char[] s, int beginIndex, int endIndex) {
        return new Guid(Guid.parseLongHex(s, beginIndex), Guid.parseLongHex(s, beginIndex + 16));
    }

    public static final Guid parseHexByteArray(byte[] s, int beginIndex) {
        return new Guid(Guid.parseLongHex(s, beginIndex), Guid.parseLongHex(s, beginIndex + 16));
    }

    public static final Guid parseBinaryCharArray(char[] s, int beginIndex) {
        long x1 = 0L;
        x1 = Guid.parseBinaryLong(s, beginIndex);
        return new Guid(x1, Guid.parseBinaryLong(s, beginIndex + 8));
    }

    public static final Guid parseBinaryCharArray(byte[] s, int beginIndex) {
        long x1 = 0L;
        x1 = Guid.parseBinaryLong(s, beginIndex);
        return new Guid(x1, Guid.parseBinaryLong(s, beginIndex + 8));
    }

    public static long fillLongFromByteArray(byte[] array, int offset) {
        long l = 0L;
        int i = 0;
        while (i < 8) {
            int index = offset + i;
            l = index < array.length ? l << 8 | (long)array[index] & 0xFFL : l << 8 | 0L;
            ++i;
        }
        return l;
    }

    public Guid(long part1, long part2) {
        this.m_part1 = part1;
        this.m_part2 = part2;
    }

    private Guid(byte[] array, int offset) {
        this.fillFromByteArray(array, offset);
    }

    public static Guid readGuidFromBytes(byte[] array, int offset) {
        if (array == null) {
            return null;
        }
        return new Guid(array, offset);
    }

    public Guid() {
        this(s_rndm.nextLong(), (long)s_rndm.nextInt() << 40 | System.currentTimeMillis());
    }

    public Guid(int part1_high, int part1_low, int part2_high, int part2_low) {
        this((long)part1_high << 32 | (long)part1_low & 0xFFFFFFFFL, (long)part2_high << 32 | (long)part2_low & 0xFFFFFFFFL);
    }

    public final String toString() {
        return this.toHexString();
    }

    public final int hashCode() {
        if (this.m_hashCode == 0) {
            this.m_hashCode = (int)this.m_part1 ^ (int)(this.m_part1 >> 32) ^ (int)this.m_part2 ^ (int)(this.m_part2 >> 32);
        }
        return this.m_hashCode;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            Guid guid2 = (Guid)o;
            return guid2.m_part1 == this.m_part1 && guid2.m_part2 == this.m_part2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean equals(Guid guid2) {
        if (guid2 != null) {
            return guid2.m_part1 == this.m_part1 && guid2.m_part2 == this.m_part2;
        }
        return false;
    }

    public final int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        try {
            Guid guid2 = (Guid)o;
            return this.compareTo(guid2);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public final int compareTo(Guid guid2) {
        if (guid2 != null) {
            if (this.m_part1 < guid2.m_part1) {
                return -1;
            }
            if (this.m_part1 > guid2.m_part1) {
                return 1;
            }
            if (this.m_part2 == guid2.m_part2) {
                return 0;
            }
            if (this.m_part2 < guid2.m_part2) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public final String toHexString() {
        char[] buf = new char[32];
        Guid.copyHexStringIntoBuffer(buf, 0, this.m_part1);
        Guid.copyHexStringIntoBuffer(buf, 16, this.m_part2);
        return new String(buf);
    }

    public final byte[] toByteArray(byte[] buf, int offset) {
        Guid.copyBytesIntoBuffer(buf, offset, this.m_part1);
        Guid.copyBytesIntoBuffer(buf, offset + 8, this.m_part2);
        return buf;
    }

    public final byte[] toBytes() {
        byte[] buf = new byte[16];
        Guid.copyBytesIntoBuffer(buf, 0, this.m_part1);
        Guid.copyBytesIntoBuffer(buf, 8, this.m_part2);
        return buf;
    }

    private static long parseLongHex(String s, int beginIndex) {
        long result = 0L;
        int i = beginIndex;
        int max = i + 16;
        while (i < max) {
            result <<= 4;
            result |= (long)s_digitsForChar[s.charAt(i++)];
        }
        return result;
    }

    private static long parseLongHex(char[] s, int beginIndex) {
        long result = 0L;
        int i = beginIndex;
        int max = i + 16;
        while (i < max) {
            result <<= 4;
            result |= (long)s_digitsForChar[s[i++]];
        }
        return result;
    }

    private static long parseLongHex(byte[] s, int beginIndex) {
        long result = 0L;
        int i = beginIndex;
        int max = i + 16;
        while (i < max) {
            result <<= 4;
            result |= (long)s_digitsForChar[s[i++]];
        }
        return result;
    }

    private static long parseBinaryLong(char[] s, int beginIndex) {
        return (s[beginIndex] << 56) + (s[beginIndex + 1] << 48) + (s[beginIndex + 2] << 40) + (s[beginIndex + 3] << 32) + (s[beginIndex + 4] << 24) + (s[beginIndex + 5] << 16) + (s[beginIndex + 6] << 8) + s[beginIndex + 7];
    }

    private static long parseBinaryLong(byte[] s, int beginIndex) {
        return ((long)s[beginIndex] & 0xFFL) << 56 | ((long)s[beginIndex + 1] & 0xFFL) << 48 | ((long)s[beginIndex + 2] & 0xFFL) << 40 | ((long)s[beginIndex + 3] & 0xFFL) << 32 | ((long)s[beginIndex + 4] & 0xFFL) << 24 | ((long)s[beginIndex + 5] & 0xFFL) << 16 | ((long)s[beginIndex + 6] & 0xFFL) << 8 | (long)s[beginIndex + 7] & 0xFFL;
    }

    protected void fillFromByteArray(byte[] array, int offset) {
        this.m_part1 = Guid.fillLongFromByteArray(array, offset);
        this.m_part2 = Guid.fillLongFromByteArray(array, offset + 8);
    }

    public static void main(String[] args) {
        try {
            Guid g;
            int IL = 100;
            int JL = 1000;
            int GL = 32;
            long time = System.currentTimeMillis();
            char[] buf = new char[IL * JL * GL];
            int pos = 0;
            int i = 0;
            while (i < IL) {
                int j = 0;
                while (j < JL) {
                    g = new Guid(i, (long)j);
                    Guid.copyGuidIntoBuffer(buf, pos, g);
                    pos += GL;
                    ++j;
                }
                ++i;
            }
            int offset = 0;
            while (offset < buf.length) {
                g = Guid.parseHexCharArray(buf, offset, offset + GL);
                offset += GL;
            }
            System.out.println("TIME " + (System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (true) {
            // Infinite loop
        }
    }

    public long part1() {
        return this.m_part1;
    }

    public long part2() {
        return this.m_part2;
    }

    static {
        char i = '0';
        while (i <= '9') {
            Guid.s_digitsForChar[i] = Character.digit(i, 16);
            i = (char)(i + '\u0001');
        }
        char i2 = 'a';
        while (i2 <= 'f') {
            Guid.s_digitsForChar[i2] = Character.digit(i2, 16);
            i2 = (char)(i2 + '\u0001');
        }
        char i3 = 'A';
        while (i3 <= 'F') {
            Guid.s_digitsForChar[i3] = Character.digit(i3, 16);
            i3 = (char)(i3 + '\u0001');
        }
    }
}

