/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import java.util.LinkedList;
import java.util.List;

public abstract class AbstractPool {
    private static final int DEFAULT_MAX_POOLSIZE = 100;
    protected int mm_maxPoolSize = 0;
    protected List mm_unlocked;

    public AbstractPool(int initialCapacity) {
        this(initialCapacity, 0, 100);
    }

    public AbstractPool(int initialCapacity, int nbInitialInstance) {
        this(initialCapacity, nbInitialInstance, 100);
    }

    public AbstractPool(int initialCapacity, int nbInitialInstance, int maxNumberObjects) {
        this.mm_maxPoolSize = maxNumberObjects;
        this.mm_unlocked = new LinkedList();
        int nbInstances = Math.min(maxNumberObjects, nbInitialInstance);
        int i = 0;
        while (i < nbInstances) {
            try {
                Object poolObj = this.createPoolObject();
                this.releasePoolObject(poolObj);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
    }

    protected abstract Object createPoolObject() throws Exception;

    protected abstract boolean validatePoolObject(Object var1);

    protected abstract void expirePoolObject(Object var1);

    public Object getPoolObject() throws Exception {
        Object poolObj = null;
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            int size = this.mm_unlocked.size();
            if (size > 0) {
                poolObj = this.mm_unlocked.remove(0);
            }
        }
        if (poolObj != null) {
            if (this.validatePoolObject(poolObj)) {
                return poolObj;
            }
            this.expirePoolObject(poolObj);
            return this.getPoolObject();
        }
        poolObj = this.createPoolObject();
        return poolObj;
    }

    public void releasePoolObject(Object o) {
        if (o != null) {
            AbstractPool abstractPool = this;
            synchronized (abstractPool) {
                boolean canPutInPool;
                boolean bl = this.mm_maxPoolSize == -1 ? true : (canPutInPool = this.mm_unlocked.size() < this.mm_maxPoolSize);
                if (canPutInPool) {
                    this.mm_unlocked.add(o);
                    return;
                }
            }
            this.expirePoolObject(o);
        }
    }
}

