/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.pom;

import com.sapportals.portal.prt.component.IPortalComponent;
import com.sapportals.portal.prt.pom.EventType;
import com.sapportals.portal.prt.pom.IEvent;
import com.sapportals.portal.prt.pom.IEventFilter;
import com.sapportals.portal.prt.pom.IEventListener;
import com.sapportals.portal.prt.pom.IEventTarget;
import com.sapportals.portal.prt.pom.INode;
import com.sapportals.portal.prt.pom.INodeList;
import com.sapportals.portal.prt.pom.IPortalNode;
import com.sapportals.portal.prt.pom.NodeList;
import com.sapportals.portal.prt.pom.NodeMode;
import com.sapportals.portal.prt.pom.NodeType;
import com.sapportals.portal.prt.pom.PortalOMException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractNode
implements INode,
IEventTarget {
    protected String m_nodeName = null;
    private INode mm_parentNode = null;
    private boolean mm_isRootNode;
    private Hashtable mm_values = null;
    protected IPortalNode mm_portalNode = null;
    private boolean mm_markKnown = false;
    private Hashtable mm_eventFilterMap = new Hashtable();
    private String mm_mark = null;
    private IEvent mm_nodeReadyEvent = null;
    private IEvent mm_nodeRemoveEvent = null;
    private IEvent mm_beforeContentEvent = null;
    private IEvent mm_POMReadyEvent = null;
    private NodeList mm_childNodes = null;
    protected IPortalComponent m_portalComponent;
    protected NodeMode m_mode = null;
    private Vector mm_eventListeners = null;

    public AbstractNode(String nodeName) {
        this.m_nodeName = nodeName;
        this.mm_childNodes = new NodeList();
    }

    protected AbstractNode(String nodeName, IPortalComponent aComponent) {
        this(nodeName);
        this.m_portalComponent = aComponent;
    }

    public void setPortalNode(IPortalNode portalNode) {
        this.mm_portalNode = portalNode;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public IPortalComponent getComponent() {
        return this.m_portalComponent;
    }

    public void setNodeMode(NodeMode mode) {
        this.m_mode = mode;
    }

    public NodeMode getNodeMode() {
        if (this.m_mode != null) {
            return this.m_mode;
        }
        if (this.getParentNode() == null) {
            return NodeMode.DEFAULT_MODE;
        }
        this.setNodeMode(this.getPortalNode().getNodeMode(this));
        return this.m_mode;
    }

    public INodeList getChildNodes() {
        return this.mm_childNodes;
    }

    public INode getFirstChild() {
        INodeList childNodes = this.getChildNodes();
        if (childNodes.getLength() == 0) {
            return null;
        }
        return childNodes.item(0);
    }

    public INode getLastChild() {
        INodeList childNodes = this.getChildNodes();
        if (childNodes.getLength() == 0) {
            return null;
        }
        return childNodes.item(childNodes.getLength() - 1);
    }

    public INode getNextSibling() {
        INode parent = this.getParentNode();
        if (parent != null) {
            return parent.getNextSiblingOfChild(this);
        }
        return null;
    }

    public INode getPreviousSibling() {
        INode parent = this.getParentNode();
        if (parent != null) {
            return parent.getPreviousSiblingOfChild(this);
        }
        return null;
    }

    public INode getPreviousSiblingOfChild(INode childNode) {
        INodeList childNodes = this.getChildNodes();
        int index = childNodes.getNodeIndex(childNode);
        if (index > 0 && index < childNodes.getLength()) {
            return childNodes.item(index - 1);
        }
        return null;
    }

    public INode getNextSiblingOfChild(INode childNode) {
        INodeList childNodes = this.getChildNodes();
        int index = childNodes.getNodeIndex(childNode);
        if (index >= 0 && index < childNodes.getLength() - 1) {
            return childNodes.item(index + 1);
        }
        return null;
    }

    public INode addChildNode(INode node) throws PortalOMException {
        if (node == null) {
            throw new PortalOMException("null node cannot be added");
        }
        if (node.getParentNode() != null) {
            throw new PortalOMException("parent already exists. Release Node before adding!");
        }
        IPortalNode portalNode = this.getPortalNode();
        if (portalNode == null) {
            throw new PortalOMException("Corrupt POM detected on addChildNode in AbstractPortalNode: PortalNode not set!");
        }
        node.setParentNode(this);
        node.setPortalNode(portalNode);
        if (node.getValue("SUBNODE") == null) {
            NodeList childNodes = (NodeList)this.getChildNodes();
            childNodes.addNode(node);
        }
        if (this.mm_POMReadyEvent == null) {
            this.mm_POMReadyEvent = portalNode.createEvent(EventType.ON_POM_READY_EVENT, false);
        }
        portalNode.postEventForNode(this.mm_POMReadyEvent, node);
        if (this.mm_nodeReadyEvent == null) {
            this.mm_nodeReadyEvent = portalNode.createEvent(EventType.ON_NODE_READY_EVENT, false);
        }
        if (node.getValue("SUBNODE") == null) {
            portalNode.fireEventOnNode(this.mm_nodeReadyEvent, node);
        }
        if (this.mm_beforeContentEvent == null) {
            this.mm_beforeContentEvent = portalNode.createEvent(EventType.BEFORE_CONTENT_EVENT, false);
        }
        portalNode.postEventForNode(this.mm_beforeContentEvent, node);
        return this;
    }

    public void removeChildNode(INode node) throws PortalOMException {
        INodeList childNodes = this.getChildNodes();
        if (node != null && childNodes.getNodeIndex(node) >= 0) {
            if (this.mm_nodeRemoveEvent == null) {
                this.mm_nodeRemoveEvent = this.mm_portalNode.createEvent(EventType.ON_NODE_REMOVE_EVENT, false);
            }
            this.mm_portalNode.fireEventOnNode(this.mm_nodeRemoveEvent, node);
            this.mm_childNodes.removeNode(node);
            node.setParentNode(null);
            node.setPortalNode(null);
        }
    }

    public INode getParentNode() {
        return this.mm_parentNode;
    }

    public IPortalNode getPortalNode() {
        return this.mm_portalNode;
    }

    public void setParentNode(INode parentNode) {
        this.mm_parentNode = parentNode;
    }

    public boolean hasChildNodes() {
        return this.getChildNodes().getLength() > 0;
    }

    public boolean isRootNode() {
        return this.getParentNode() == null;
    }

    public INodeList getChildNodesByName(String name) {
        if (this.hasChildNodes()) {
            INodeList children = this.getChildNodes();
            NodeList selchildren = new NodeList();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeName().equals(name)) {
                    selchildren.addNode(children.item(i));
                }
                ++i;
            }
            if (selchildren.getLength() > 0) {
                return selchildren;
            }
        }
        return new NodeList();
    }

    private Vector _getAListener(EventType type) {
        Vector listeners = null;
        listeners = (Vector)this.mm_eventFilterMap.get(type);
        if (listeners == null) {
            listeners = new Vector();
            this.mm_eventFilterMap.put(type, listeners);
        }
        return listeners;
    }

    public void removeEventListener(EventType type, IEventListener listener) {
        this.removeEventListener(type, listener, null);
    }

    public void removeEventListener(EventType type, IEventListener listener, IEventFilter filter) {
        Vector allListeners = this._getAListener(type);
        Iterator it = allListeners.iterator();
        while (it.hasNext()) {
            AListener li = (AListener)it.next();
            if (li.listener != listener || li.filter != filter) continue;
            it.remove();
        }
    }

    public void addEventListener(EventType type, IEventListener listener, IEventFilter filter) throws PortalOMException {
        try {
            this.removeEventListener(type, listener, filter);
            Vector v = this._getAListener(type);
            v.add(new AListener(listener, false, filter));
        }
        catch (Throwable e) {
            throw new PortalOMException(e);
        }
    }

    public void addEventListener(EventType type, IEventListener listener) throws PortalOMException {
        this.addEventListener(type, listener, null);
    }

    public void dispatchEvent(IEvent evt) throws PortalOMException {
        EventType type = evt.getType();
        Vector allListeners = this._getAListener(type);
        try {
            Iterator it = allListeners.iterator();
            while (it.hasNext()) {
                AListener li = (AListener)it.next();
                if (li.filter != null) {
                    if (!li.filter.accept(evt)) continue;
                    li.listener.handleEvent(evt);
                    continue;
                }
                li.listener.handleEvent(evt);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void putValue(String name, Object value) {
        if (this.mm_values == null) {
            this.mm_values = new Hashtable();
        }
        if (name != null) {
            this.mm_values.put(name, value);
        }
    }

    public Object getValue(String name) {
        if (this.mm_values != null) {
            return this.mm_values.get(name);
        }
        return null;
    }

    public void removeValue(String name) {
        if (this.mm_values != null) {
            this.mm_values.remove(name);
        }
    }

    public void setNodeMark(String mark) {
        this.mm_mark = mark;
        this.mm_markKnown = true;
    }

    public String getNodeMark() {
        if (!this.mm_markKnown) {
            this.mm_mark = this.getPortalNode().getNodeMark(this);
            this.mm_markKnown = true;
        }
        return this.mm_mark;
    }

    public void release() {
        this.m_nodeName = null;
        this.mm_parentNode = null;
        if (this.mm_childNodes != null) {
            int nbChild = this.mm_childNodes.getLength();
            int i = 0;
            while (i < nbChild) {
                this.mm_childNodes.item(i).release();
                ++i;
            }
            this.mm_childNodes.removeAllNodes();
        }
        this.mm_isRootNode = false;
        if (this.mm_values != null) {
            this.mm_values.clear();
        }
        this.mm_portalNode = null;
        this.mm_markKnown = false;
        this.mm_mark = null;
        this.m_mode = NodeMode.DEFAULT_MODE;
        if (this.mm_eventListeners != null) {
            this.mm_eventListeners.removeAllElements();
        }
        this.m_portalComponent = null;
        this.mm_nodeReadyEvent = null;
        this.mm_nodeRemoveEvent = null;
        this.mm_beforeContentEvent = null;
        this.mm_POMReadyEvent = null;
    }

    public abstract NodeType getNodeType();

    class AListener {
        public IEventListener listener;
        public boolean useCapture;
        public IEventFilter filter;

        public AListener(IEventListener listener, boolean useCapture, IEventFilter aFilter) {
            this.listener = listener;
            this.useCapture = useCapture;
            this.filter = aFilter;
        }
    }
}

