/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

public class IntAllocator {
    private int[] IDs = null;
    private int activeIDs;
    private int freeIDs;

    public IntAllocator(int initialSize) {
        this.IDs = new int[initialSize];
        this.activeIDs = initialSize;
        this.freeIDs = initialSize;
        int i = 0;
        while (i < initialSize) {
            this.IDs[i] = initialSize - i - 1;
            ++i;
        }
    }

    public synchronized int getID() {
        if (this.freeIDs != 0) {
            return this.IDs[--this.freeIDs];
        }
        this.IDs = new int[++this.activeIDs];
        return this.activeIDs - 1;
    }

    public synchronized void releaseID(int id) {
        this.IDs[this.freeIDs++] = id;
    }
}

