/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load;

import com.sap.engine.boot.FileClassLoader;
import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.core.load.NegativeCache;
import com.sap.engine.frame.core.load.ReferencedLockMonitor;
import com.sap.engine.frame.core.load.SAPClassNotFoundException;
import com.sap.engine.frame.core.load.SAPLoadingIllegalArgumentException;
import com.sap.engine.frame.core.load.SAPNoClassDefFoundError;
import com.sap.engine.frame.core.load.res.CompoundEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;

public abstract class ReferencedLoader
extends SecureClassLoader {
    private String name;
    protected final ClassLoader parentLoader;
    protected ProtectionDomain domain;
    protected NegativeCache negativeCache;
    protected boolean useNegativeCache;
    private boolean isRegistered = false;
    private ReferencedLockMonitor loaderInfo;
    protected boolean debugMode;
    protected Vector classes;
    private static boolean strictResourceOrderInitialized = false;
    private static boolean strictResourceOrder = false;
    public static final ClassNotFoundException CLASS_NOT_FOUND_EXCEPTION = new ClassNotFoundException();
    public static final String DEBUG_PROPERTY = "classload.info";
    protected static boolean globalDebugMode;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static final void setStrictResourceOrder(boolean state) {
        if (!strictResourceOrderInitialized) {
            strictResourceOrderInitialized = true;
            strictResourceOrder = state;
        }
    }

    public static final boolean isStrictResourceOrder() {
        return strictResourceOrder;
    }

    public ReferencedLoader(ClassLoader parent) {
        this(null, parent, null);
    }

    public ReferencedLoader(String name, ClassLoader parent, ProtectionDomain domain) throws SAPLoadingIllegalArgumentException {
        super(parent != null ? parent : ClassLoader.getSystemClassLoader());
        this.name = name == null ? this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) : name;
        this.parentLoader = this.getParent();
        this.domain = domain;
        this.setUseNegativeCache(true, -1);
        this.setDebugMode(globalDebugMode);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public void setDebugMode(boolean state) {
        if (state && this.classes == null) {
            this.classes = new Vector();
        }
        this.debugMode = state;
    }

    public Vector getLoadedClasses(String prefix) throws UnsupportedOperationException {
        if (this.debugMode) {
            Vector<Class> array = new Vector<Class>();
            int i = 0;
            while (i < this.classes.size()) {
                Class cls = (Class)this.classes.get(i);
                if (cls.getName().startsWith(prefix)) {
                    array.add(cls);
                }
                ++i;
            }
            return array;
        }
        try {
            Class classLoaderClass = class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ReferencedLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
            Field f = classLoaderClass.getDeclaredField("classes");
            ((AccessibleObject)f).setAccessible(true);
            Vector array = (Vector)f.get(this);
            Vector<Class> result = new Vector<Class>();
            int i = 0;
            while (i < array.size()) {
                Class cls = (Class)array.get(i);
                if (cls.getName().startsWith(prefix)) {
                    result.add(cls);
                }
                ++i;
            }
            ((AccessibleObject)f).setAccessible(false);
            return result;
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedOperationException("Loader not in debug mode !" + e.getMessage());
        }
        catch (SecurityException e) {
            throw new UnsupportedOperationException("Loader not in debug mode !" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException("Loader not in debug mode !" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Loader not in debug mode !" + e.getMessage());
        }
    }

    public String getParentName() {
        ClassLoader parentLoader = this.getParentLoader();
        String parentLoaderName = null;
        parentLoaderName = parentLoader != null ? (parentLoader instanceof ReferencedLoader ? ((ReferencedLoader)parentLoader).getName() : (parentLoader instanceof FileClassLoader ? ((FileClassLoader)parentLoader).getName() : parentLoader.toString())) : "BOOTSRAP";
        return parentLoaderName;
    }

    public ClassLoader getParentLoader() {
        return this.parentLoader;
    }

    public final String getInfo() {
        StringBuffer buffer = new StringBuffer(228);
        buffer.append("\r\n------------------------- Loader Info -------------------------\r\nClassLoader name: [" + this.name + "]");
        buffer.append("\r\n Parent loader name: [" + this.getParentName() + "]");
        String[] references = null;
        references = !this.isRegistered ? new String[]{"not registered!"} : this.loaderInfo.getReferencesTo();
        if (references != null && references.length != 0) {
            buffer.append("\r\n References:");
            int i = 0;
            while (i < references.length) {
                buffer.append("\r\n   " + references[i]);
                ++i;
            }
        } else {
            buffer.append("\r\n No references !");
        }
        String[] resources = this.getResourceNames();
        if (resources != null && resources.length != 0) {
            buffer.append("\r\n Resources:");
            int i = 0;
            while (i < resources.length) {
                buffer.append("\r\n   " + resources[i]);
                ++i;
            }
        } else {
            buffer.append("\r\n No resources !");
        }
        String additionalInfo = this.getAdditionalInfo();
        if (additionalInfo != null) {
            buffer.append("\r\n " + additionalInfo);
        }
        buffer.append("\r\n---------------------------------------------------------------");
        return buffer.toString();
    }

    public String getAdditionalInfo() {
        return null;
    }

    public void prepareForRemove() {
    }

    public void setUseNegativeCache(boolean use, int cacheSize) {
        if (this.negativeCache == null) {
            this.negativeCache = new NegativeCache(cacheSize);
        } else if (use) {
            if (!this.useNegativeCache) {
                this.negativeCache.clearCache();
            }
            this.negativeCache.setCapacity(cacheSize);
        } else if (this.useNegativeCache) {
            this.negativeCache.clearCache();
        }
        this.useNegativeCache = use;
    }

    public boolean negativeCacheContains(String className) {
        if (this.useNegativeCache) {
            return this.negativeCache.contains(className);
        }
        return false;
    }

    protected final void definePackage(String packageName, Attributes attributes) {
        if (packageName != null) {
            try {
                if (attributes != null) {
                    String specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    String specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    String specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    String implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    String implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    String implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
                } else {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void clearNegativeCache() {
        if (this.useNegativeCache) {
            this.negativeCache.clearCache();
        }
    }

    public final void setLockMonitor(ReferencedLockMonitor lock) {
        this.loaderInfo = lock;
        this.isRegistered = this.loaderInfo != null;
    }

    public final void invalidate() {
        this.isRegistered = false;
    }

    public final String[] getReferencesTo() {
        if (this.isRegistered) {
            return this.loaderInfo.getReferencesTo();
        }
        return new String[0];
    }

    public final String[] getReferencesFrom() {
        if (this.isRegistered) {
            return this.loaderInfo.getReferencesFrom();
        }
        return new String[0];
    }

    public final void clearNegativeCacheInReferees() {
        if (this.isRegistered) {
            this.loaderInfo.clearNegativeCacheInReferees();
        }
    }

    protected final Class loadClassByReference(String className, String fileName) throws ClassNotFoundException, NoClassDefFoundError {
        if (this.isRegistered) {
            return this.loaderInfo.loadClassByReference(className, fileName);
        }
        throw CLASS_NOT_FOUND_EXCEPTION;
    }

    protected final URL getResourceByReference(String fileName) {
        if (this.isRegistered) {
            return this.loaderInfo.getResourceByReference(fileName);
        }
        return null;
    }

    protected final InputStream getResourceAsStreamByReference(String fileName) {
        if (this.isRegistered) {
            return this.loaderInfo.getResourceAsStreamByReference(fileName);
        }
        return null;
    }

    protected final Enumeration findResourcesByReference(String fileName) throws IOException {
        if (this.isRegistered) {
            return this.loaderInfo.findResourcesByReference(fileName);
        }
        return null;
    }

    public final Class loadClass(String className) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(className);
        if (result != null) {
            return result;
        }
        if (this.useNegativeCache && this.negativeCache.contains(className)) {
            String[] refs = null;
            refs = !this.isRegistered ? new String[]{"not registered!"} : this.loaderInfo.getReferencesTo();
            throw new SAPClassNotFoundException(className, this.name, this.getParentName(), refs, this.getResourceNames(), this.getAdditionalInfo(), true);
        }
        try {
            Class cls = this.loadClass(className, false);
            if (this.debugMode) {
                this.classes.add(cls);
            }
            return cls;
        }
        catch (ClassNotFoundException cnfException) {
            if (this.useNegativeCache) {
                this.negativeCache.add(className);
            }
            String[] refs = null;
            refs = !this.isRegistered ? new String[]{"not registered!"} : this.loaderInfo.getReferencesTo();
            throw new SAPClassNotFoundException(className, this.name, this.getParentName(), refs, this.getResourceNames(), this.getAdditionalInfo(), false);
        }
        catch (NoClassDefFoundError ncdfError) {
            String[] refs = null;
            refs = !this.isRegistered ? new String[]{"not registered!"} : this.loaderInfo.getReferencesTo();
            throw new SAPNoClassDefFoundError(ncdfError, this.name, this.getParentName(), refs, this.getResourceNames(), this.getAdditionalInfo(), className);
        }
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class result = null;
        try {
            result = this.parentLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String fileName = className.replace('.', '/') + ".class";
            try {
                result = this.loadClassByReference(className, fileName);
            }
            catch (ClassNotFoundException e1) {
                result = this.loadLocalClass(className, fileName);
            }
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        return this.loadLocalClass(className, className.replace('.', '/') + ".class");
    }

    public URL getResource(String fileName) {
        URL result = this.parentLoader.getResource(fileName);
        if (result != null) {
            return result;
        }
        result = this.getResourceByReference(fileName);
        if (result != null) {
            return result;
        }
        return this.getLocalResource(fileName);
    }

    public InputStream getResourceAsStream(String fileName) {
        InputStream result = this.parentLoader.getResourceAsStream(fileName);
        if (result != null) {
            return result;
        }
        result = this.getResourceAsStreamByReference(fileName);
        if (result != null) {
            return result;
        }
        return this.getLocalResourceAsStream(fileName);
    }

    protected Enumeration findResources(String fileName) throws IOException {
        CompoundEnumeration result = new CompoundEnumeration();
        result.add(this.findResourcesByReference(fileName));
        result.add(this.findLocalResources(fileName));
        return result;
    }

    public final Class loadRefClass(String className, String fileName) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(className);
        if (result != null) {
            if (result.getClassLoader() == this) {
                return result;
            }
        } else if (this.useNegativeCache && this.negativeCache.contains(className)) {
            throw CLASS_NOT_FOUND_EXCEPTION;
        }
        return this.loadLocalClass(className, fileName);
    }

    public final URL getRefResource(String fileName) {
        return this.getLocalResource(fileName);
    }

    public final InputStream getRefResourceAsStream(String fileName) {
        return this.getLocalResourceAsStream(fileName);
    }

    public final Enumeration findRefResources(String fileName) throws IOException {
        return this.findLocalResources(fileName);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "@" + this.getName();
    }

    protected abstract Class loadLocalClass(String var1, String var2) throws ClassNotFoundException;

    protected abstract URL getLocalResource(String var1);

    protected abstract InputStream getLocalResourceAsStream(String var1);

    protected abstract Enumeration findLocalResources(String var1) throws IOException;

    public abstract String[] getResourceNames();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String debug = SystemProperties.getProperty((String)DEBUG_PROPERTY);
        if (debug != null) {
            globalDebugMode = debug.equalsIgnoreCase("true");
        }
    }
}

