/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load;

public final class NegativeCache {
    public static final int MIN_CAPACITY = 11;
    private int size;
    private Entry[] table;
    private Entry headEntry;
    private Entry tailEntry;

    public NegativeCache() {
        this(-1);
    }

    public NegativeCache(int capacity) {
        if (capacity < 11) {
            capacity = 11;
        }
        this.table = new Entry[capacity];
        this.tailEntry = null;
        this.headEntry = null;
        this.size = 0;
    }

    public boolean contains(String name) {
        if (name != null) {
            Entry[] table = this.table;
            int hash = name.hashCode();
            int index = (hash & Integer.MAX_VALUE) % table.length;
            Entry entry = table[index];
            while (entry != null) {
                if (entry.hashcode == hash && name.equals(entry.name)) {
                    return true;
                }
                entry = entry.nextSameIndex;
            }
        }
        return false;
    }

    public synchronized void add(String name) {
        int hash = name.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        Entry newEntry = null;
        while (e != null) {
            if (e.hashcode == hash && name.equals(e.name)) {
                return;
            }
            e = e.nextSameIndex;
        }
        if (this.size == this.table.length) {
            newEntry = this.headEntry;
            this.headEntry = newEntry.nextAdded;
            int oldIndex = newEntry.tableIndex;
            Entry entry = this.table[oldIndex];
            Entry prev = null;
            while (entry != null) {
                if (entry == newEntry) {
                    if (prev != null) {
                        prev.nextSameIndex = entry.nextSameIndex;
                    } else {
                        this.table[oldIndex] = entry.nextSameIndex;
                    }
                }
                prev = entry;
                entry = entry.nextSameIndex;
            }
            newEntry.update(name, this.table[index], index);
        } else {
            ++this.size;
            newEntry = new Entry(name, this.table[index], index);
            if (this.tailEntry == null) {
                this.tailEntry = this.headEntry = newEntry;
                this.table[index] = newEntry;
                return;
            }
        }
        this.table[index] = newEntry;
        this.tailEntry.nextAdded = newEntry;
        this.tailEntry = newEntry;
    }

    public synchronized void setCapacity(int newCapacity) {
        if (newCapacity >= 11 && newCapacity != this.table.length) {
            Entry[] oldMap = this.table;
            this.size = 0;
            this.tailEntry = null;
            this.headEntry = null;
            this.table = new Entry[newCapacity];
            int i = 0;
            while (i < oldMap.length && this.size != this.table.length) {
                Entry oldEntry = oldMap[i];
                Entry nextOldEntry = null;
                while (oldEntry != null && this.size != this.table.length) {
                    ++this.size;
                    nextOldEntry = oldEntry.nextSameIndex;
                    int newIndex = (oldEntry.hashcode & Integer.MAX_VALUE) % this.table.length;
                    oldEntry.update(this.table[newIndex], newIndex);
                    this.table[newIndex] = oldEntry;
                    if (this.tailEntry == null) {
                        this.tailEntry = this.headEntry = oldEntry;
                    } else {
                        this.tailEntry.nextAdded = oldEntry;
                        this.tailEntry = oldEntry;
                    }
                    oldEntry = nextOldEntry;
                }
                ++i;
            }
        }
    }

    public synchronized void clearCache() {
        this.tailEntry = null;
        this.headEntry = null;
        this.size = 0;
        int i = 0;
        while (i < this.table.length) {
            this.table[i] = null;
            ++i;
        }
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized int getCapacity() {
        return this.table.length;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    private static class Entry {
        String name;
        int hashcode;
        int tableIndex;
        Entry nextSameIndex;
        Entry nextAdded;

        public Entry(String name, Entry nextSameIndex, int tableIndex) {
            this.update(name, nextSameIndex, tableIndex);
        }

        void update(String name, Entry nextSameIndex, int tableIndex) {
            this.name = name;
            this.hashcode = name.hashCode();
            this.nextSameIndex = nextSameIndex;
            this.nextAdded = null;
            this.tableIndex = tableIndex;
        }

        void update(Entry nextSameIndex, int tableIndex) {
            this.nextSameIndex = nextSameIndex;
            this.nextAdded = null;
            this.tableIndex = tableIndex;
        }
    }
}

