/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.configuration.admin;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import java.io.Serializable;

public class PropertySheetEntry
implements Serializable,
Comparable {
    private String _name;
    private Object _customValue;
    private Object _defaultValue;
    private String _description;
    private boolean _secure;

    public PropertySheetEntry(String name, Object customValue, Object defaultValue, String description, boolean isSecure) {
        if (name == null) {
            throw new NullPointerException("The name must not be null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("The default-value must not be null");
        }
        this._name = name;
        this._customValue = customValue;
        this._defaultValue = defaultValue;
        this._description = description;
        this._secure = isSecure;
    }

    public final String getName() {
        return this._name;
    }

    public final Object getCustomValue() {
        return this._customValue;
    }

    public final Object getDefaultValue() {
        return this._defaultValue;
    }

    public final String getDescription() {
        return this._description;
    }

    public final boolean isSecure() {
        return this._secure;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PropertySheetEntry)) {
            return false;
        }
        return ((PropertySheetEntry)o).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int compareTo(Object o) {
        if (!(o instanceof PropertySheetEntry)) {
            throw new ClassCastException("Can not compare objects of class " + this.getClass().getName() + " with objects of class " + o.getClass().getName());
        }
        return this.getName().compareTo(((PropertySheetEntry)o).getName());
    }

    public String toString() {
        return "PropertySheetEntry[" + this.getName() + ", " + this.getCustomValue() + ", " + this.getDefaultValue() + ", " + this.getDescription() + "]";
    }

    public static PropertySheetEntry[] createCopy(PropertyEntry[] entry) throws ConfigurationException {
        PropertySheetEntry[] result = new PropertySheetEntry[entry.length];
        int i = 0;
        while (i < entry.length) {
            result[i] = new PropertySheetEntry(entry[i].getName(), entry[i].getCustom(), entry[i].getDefault(), entry[i].getDescription(), entry[i].isSecure());
            ++i;
        }
        return result;
    }
}

