/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.configuration.admin;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.admin.OpenConfigInfo;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class OpenConfigInfoImpl
implements OpenConfigInfo,
Serializable {
    private String m_path;
    private int m_accessMode;
    private int m_clusterNode;
    private int m_numTransactions;
    private transient Configuration m_config;

    public OpenConfigInfoImpl() {
    }

    public OpenConfigInfoImpl(Configuration cfg, int accessMode, int clusterNode, int taNum) {
        this.m_accessMode = accessMode;
        this.m_clusterNode = clusterNode;
        this.m_numTransactions = taNum;
        this.m_config = cfg;
    }

    public String getPath() {
        if (this.m_config != null) {
            return this.m_config.getPath();
        }
        return this.m_path;
    }

    public int getAccessMode() {
        return this.m_accessMode;
    }

    public int getClusterNodeID() {
        return this.m_clusterNode;
    }

    public int getNumberOfAcessingTransactions() {
        return this.m_numTransactions;
    }

    public Configuration getConfiguration() {
        return this.m_config;
    }

    public static OpenConfigInfo[] readAllFromStream(ObjectInputStream in) throws Exception {
        boolean eof = false;
        Vector<OpenConfigInfoImpl> v = new Vector<OpenConfigInfoImpl>();
        while (!eof) {
            try {
                OpenConfigInfoImpl info = new OpenConfigInfoImpl();
                info.readObjectInternal(in);
                v.addElement(info);
            }
            catch (EOFException e) {
                eof = true;
            }
        }
        return v.toArray(new OpenConfigInfo[0]);
    }

    public void writeToStream(ObjectOutputStream out) throws IOException {
        this.writeObject(out);
    }

    protected void readObjectInternal(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_path = (String)in.readObject();
        this.m_accessMode = in.readInt();
        this.m_clusterNode = in.readInt();
        this.m_numTransactions = in.readInt();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readObjectInternal(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getPath());
        out.writeInt(this.m_accessMode);
        out.writeInt(this.m_clusterNode);
        out.writeInt(this.m_numTransactions);
    }
}

