/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.client;

import com.sap.engine.frame.client.ClientThreadContextFactory;
import com.sap.engine.frame.client.ContextObjectNameIteratorImpl;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.frame.core.thread.ContextObject;
import com.sap.engine.frame.core.thread.ContextObjectNameIterator;
import com.sap.engine.frame.core.thread.Transferable;
import com.sap.engine.lib.lang.Monitor;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;

public class ClientThreadContextImpl
extends InheritableThreadLocal
implements ClientThreadContext,
ClientThreadContextFactory {
    private ConcurrentHashMapObjectObject coHash = new ConcurrentHashMapObjectObject();
    private Monitor synch = new Monitor();
    private HashSet transferables = new HashSet();
    private static ClientThreadContextImpl current = new ClientThreadContextImpl();
    private static ConcurrentHashMapObjectObject staticCoHash = new ConcurrentHashMapObjectObject();

    public ContextObject getContextObject(String name) {
        ContextObject result = (ContextObject)this.coHash.get((Object)name);
        if (result == null) {
            ConcurrentHashMapObjectObject concurrentHashMapObjectObject = staticCoHash;
            synchronized (concurrentHashMapObjectObject) {
                result = (ContextObject)staticCoHash.get((Object)name);
                if (result != null) {
                    result = result.getInitialValue();
                    this.setContextObject(name, result);
                }
            }
        }
        return result;
    }

    public ContextObjectNameIterator getContextObjectNames() {
        return new ContextObjectNameIteratorImpl(this.coHash.getAllKeys());
    }

    public ContextObjectNameIterator getTransferableContextObjectNames() {
        return new ContextObjectNameIteratorImpl(((AbstractCollection)this.transferables).toArray());
    }

    public void setContextObject(String name, ContextObject object) {
        if (this.coHash.get((Object)name) == null && staticCoHash.get((Object)name) == null) {
            staticCoHash.put((Object)name, (Object)object.getInitialValue());
        }
        this.coHash.put((Object)name, (Object)object);
        if (object instanceof Transferable) {
            this.transferables.add(name);
        }
    }

    public void unregisterContextObject(String name) {
        Monitor monitor = this.synch;
        synchronized (monitor) {
            this.coHash.remove((Object)name);
            this.transferables.remove(name);
        }
    }

    protected Object initialValue() {
        return new ClientThreadContextImpl();
    }

    protected Object childValue(Object parentValue) {
        ClientThreadContextImpl child = new ClientThreadContextImpl();
        ClientThreadContextImpl parent = (ClientThreadContextImpl)parentValue;
        Monitor monitor = parent.synch;
        synchronized (monitor) {
            child.childCoHash(parent.coHash);
            child.transferables = (HashSet)parent.transferables.clone();
        }
        return child;
    }

    private void childCoHash(ConcurrentHashMapObjectObject pCoHash) {
        if (this.coHash != null) {
            this.coHash.clear();
        } else {
            this.coHash = new ConcurrentHashMapObjectObject(pCoHash.size());
        }
        Enumeration enumeration = pCoHash.keys();
        while (enumeration.hasMoreElements()) {
            String temp = (String)enumeration.nextElement();
            ContextObject tempCo = (ContextObject)pCoHash.get((Object)temp);
            ContextObject tempNew = null;
            if ((tempNew = tempCo.childValue(tempCo, tempNew)) == null) {
                Thread.dumpStack();
            }
            this.coHash.put((Object)temp, (Object)tempNew);
        }
    }

    public ClientThreadContext getThreadContext() {
        return (ClientThreadContext)current.get();
    }
}

