/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.transfer;

import com.sap.engine.core.configuration.impl.ReadAccessConfiguration;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.utilities.transfer.ConfigAttribute;
import com.sap.engine.core.configuration.impl.utilities.transfer.ConfigAttributes;
import com.sap.engine.core.configuration.impl.utilities.transfer.ConfigInputSource;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class ConfigParser
implements XMLReader {
    public static final String ELEM_CONFIGURATION = "configuration";
    public static final String ELEM_PATH = "path";
    public static final String ELEM_VERSION = "version";
    public static final String ELEM_SUBCONFIGURATIONS = "sub-configurations";
    public static final String ELEM_SUBCONFIGURATION = "sub-configuration";
    public static final String ELEM_MAP_NAME = "map-name";
    public static final String ELEM_VALUE = "value";
    public static final String ELEM_CONFIG_ENTRIES = "config-entries";
    public static final String ELEM_FILE_ENTRIES = "file-entries";
    public static final String ELEM_CONFIG_ENTRY = "config-entry";
    public static final String ELEM_FILE_ENTRY = "file-entry";
    public static final String ATT_NAME = "name";
    public static final String ATT_TYPE = "type";
    public static final String ATT_CACHEMODE = "cachemode";
    public static final String BYTE_VALUES_FILE = "bytevalues";
    public static final String EXPORT_VERSION = "630";
    private HashMap m_props = new HashMap();
    private HashMap m_lastSubConfigs = null;
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;
    private DeclHandler m_declHandler;

    public ConfigParser() {
        this.m_props.put("http://xml.org/sax/features/namespaces", new Boolean(true));
        this.m_props.put("http://xml.org/sax/features/namespaces-prefixes", new Boolean(false));
    }

    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public boolean getFeature(String key) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!this.m_props.containsKey(key)) {
            throw new SAXNotRecognizedException("feature " + key + " not recognized");
        }
        return (Boolean)this.m_props.get(key);
    }

    public Object getProperty(String arg0) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (!(inputSource instanceof ConfigInputSource)) {
            throw new SAXException("Need an InputSource of type ConfigInputSource.");
        }
        try {
            Configuration config = ((ConfigInputSource)inputSource).getConfiguration();
            String destPath = ((ConfigInputSource)inputSource).getDestinationPath();
            ZipOutputStream out = ((ConfigInputSource)inputSource).getOutputStream();
            ConfigMetaData metaData = config.getMetaData();
            this.m_contentHandler.startDocument();
            this.m_contentHandler.startElement("", ELEM_CONFIGURATION, ELEM_CONFIGURATION, this.getAttributesFromMetaData(metaData));
            this.m_contentHandler.startElement("", "", ELEM_PATH, new ConfigAttributes());
            this.m_contentHandler.characters(config.getPath().toCharArray(), 0, config.getPath().length());
            this.m_contentHandler.endElement("", "", ELEM_PATH);
            this.m_contentHandler.startElement("", "", ELEM_VERSION, new ConfigAttributes());
            this.m_contentHandler.characters(EXPORT_VERSION.toCharArray(), 0, EXPORT_VERSION.length());
            this.m_contentHandler.endElement("", "", ELEM_VERSION);
            ConfigMetaData[] subConfigs = config.getAllSubConfigurationMetaData();
            Map entries = ((ReadAccessConfiguration)config).getAllValueEntries();
            Map files = config.getAllFileEntries();
            this.parseSubConfigurations(subConfigs);
            this.parseConfigEntries(entries, destPath, out);
            this.parseFileEntries(files, destPath, out);
            this.m_contentHandler.endElement("", ELEM_CONFIGURATION, ELEM_CONFIGURATION);
            this.m_contentHandler.endDocument();
        }
        catch (ConfigurationException ce) {
            throw new SAXException((Exception)((Object)ce));
        }
    }

    private void parseSubConfigurations(ConfigMetaData[] subConfigs) throws ConfigurationException, SAXException, IOException {
        if (subConfigs.length == 0) {
            return;
        }
        this.m_lastSubConfigs = new HashMap();
        this.m_contentHandler.startElement("", "", ELEM_SUBCONFIGURATIONS, new ConfigAttributes());
        int i = 0;
        while (i < subConfigs.length) {
            this.m_contentHandler.startElement("", "", ELEM_SUBCONFIGURATION, this.getAttributesFromMetaData(subConfigs[i]));
            String mapName = Integer.toString(i);
            this.m_contentHandler.startElement("", "", ELEM_MAP_NAME, new ConfigAttributes());
            this.m_contentHandler.characters(mapName.toCharArray(), 0, mapName.length());
            this.m_contentHandler.endElement("", "", ELEM_MAP_NAME);
            this.m_contentHandler.endElement("", "", ELEM_SUBCONFIGURATION);
            this.m_lastSubConfigs.put(subConfigs[i].getName(), mapName);
            ++i;
        }
        this.m_contentHandler.endElement("", "", ELEM_SUBCONFIGURATIONS);
    }

    private void parseConfigEntries(Map entries, String destPath, ZipOutputStream out) throws ConfigurationException, SAXException, IOException {
        if (entries.isEmpty()) {
            return;
        }
        HashMap<String, Object> byteValues = null;
        this.m_contentHandler.startElement("", "", ELEM_CONFIG_ENTRIES, new ConfigAttributes());
        int counter = 0;
        Iterator iter = entries.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            ValueEntry entry = (ValueEntry)entries.get(key);
            this.m_contentHandler.startElement("", "", ELEM_CONFIG_ENTRY, this.getAttributesFromValueEntry(entry));
            if (entry.getType() == 50 || entry.getType() == 60) {
                if (byteValues == null) {
                    byteValues = new HashMap<String, Object>();
                }
                String mapName = Integer.toString(counter++);
                this.m_contentHandler.startElement("", "", ELEM_MAP_NAME, new ConfigAttributes());
                this.m_contentHandler.characters(mapName.toCharArray(), 0, mapName.length());
                this.m_contentHandler.endElement("", "", ELEM_MAP_NAME);
                byteValues.put(mapName, entry.getDBValue());
            } else {
                String value = entry.getValue().toString();
                if (entry.getType() == 40) {
                    value = "\"" + value + "\"";
                }
                this.m_contentHandler.startElement("", "", ELEM_VALUE, new ConfigAttributes());
                this.m_contentHandler.characters(value.toCharArray(), 0, value.length());
                this.m_contentHandler.endElement("", "", ELEM_VALUE);
            }
            this.m_contentHandler.endElement("", "", ELEM_CONFIG_ENTRY);
        }
        if (byteValues != null) {
            String destFileName = destPath + BYTE_VALUES_FILE;
            out.putNextEntry(new ZipEntry(destFileName));
            ObjectOutputStream oOut = new ObjectOutputStream(out);
            oOut.writeObject(byteValues);
            oOut.flush();
            ((FilterOutputStream)out).flush();
            out.closeEntry();
        }
        this.m_contentHandler.endElement("", "", ELEM_CONFIG_ENTRIES);
    }

    private void parseFileEntries(Map files, String destPath, ZipOutputStream out) throws ConfigurationException, SAXException, IOException {
        if (files.isEmpty()) {
            return;
        }
        this.m_contentHandler.startElement("", "", ELEM_FILE_ENTRIES, new ConfigAttributes());
        int counter = 0;
        ArrayList<ConfigAttribute> attr = new ArrayList<ConfigAttribute>();
        byte[] buf = new byte[5120];
        Iterator iter = files.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            InputStream in = (InputStream)files.get(name);
            String mapName = "f" + Integer.toString(counter++);
            attr.clear();
            attr.add(new ConfigAttribute(ATT_NAME, name, 0));
            this.m_contentHandler.startElement("", "", ELEM_FILE_ENTRY, new ConfigAttributes(attr));
            this.m_contentHandler.startElement("", "", ELEM_MAP_NAME, new ConfigAttributes());
            this.m_contentHandler.characters(mapName.toCharArray(), 0, mapName.length());
            this.m_contentHandler.endElement("", "", ELEM_MAP_NAME);
            this.m_contentHandler.endElement("", "", ELEM_FILE_ENTRY);
            String destFileName = destPath + mapName;
            out.putNextEntry(new ZipEntry(destFileName));
            int received = 0;
            while ((received = in.read(buf)) != -1) {
                out.write(buf, 0, received);
            }
            ((FilterOutputStream)out).flush();
            out.closeEntry();
        }
        this.m_contentHandler.endElement("", "", ELEM_FILE_ENTRIES);
    }

    private ConfigAttributes getAttributesFromMetaData(ConfigMetaData data) {
        ArrayList<ConfigAttribute> result = new ArrayList<ConfigAttribute>();
        result.add(new ConfigAttribute(ATT_NAME, data.getName(), 1));
        result.add(new ConfigAttribute(ATT_TYPE, Integer.toString(data.getConfigurationType()), 2));
        result.add(new ConfigAttribute(ATT_CACHEMODE, Integer.toString(data.getCacheMode()), 3));
        return new ConfigAttributes(result);
    }

    private ConfigAttributes getAttributesFromValueEntry(ValueEntry entry) {
        ArrayList<ConfigAttribute> result = new ArrayList<ConfigAttribute>();
        result.add(new ConfigAttribute(ATT_NAME, entry.getName(), 1));
        result.add(new ConfigAttribute(ATT_TYPE, ValueEntry.getTypeStringForType(entry.getType()), 2));
        return new ConfigAttributes(result);
    }

    public void parse(String arg0) throws IOException, SAXException {
        throw new SAXException("Method not supported. Need a ConfigInputSource.");
    }

    public void setContentHandler(ContentHandler cntHandler) {
        this.m_contentHandler = cntHandler;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public void setFeature(String arg0, boolean arg1) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.m_lexicalHandler = (LexicalHandler)value;
        } else if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            this.m_declHandler = (DeclHandler)value;
        } else {
            throw new SAXNotSupportedException(name);
        }
    }

    public HashMap getLastSubConfigMap() {
        HashMap result = this.m_lastSubConfigs;
        this.m_lastSubConfigs = null;
        return result;
    }
}

