/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.transfer;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.TransactionListener;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.WriteAccessConfiguration;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigImporter
implements EntityResolver,
TransactionListener {
    public static final int IMPORT_AS_SUBCONFIGURATION = 0;
    public static final int IMPORT_CONTENT = 1;
    private DocumentBuilder m_builder;
    private Map m_byteValues;
    private String m_folderPath = "";
    private String m_transactionId;
    private WriteAccessConfiguration m_rootConfig;
    private int m_importMode;
    private ZipFile m_zipFile;
    private Vector m_zipInputStreams = new Vector();

    public ConfigImporter() throws ConfigurationException {
        try {
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setValidating(true);
            factory.setExpandEntityReferences(true);
            this.m_builder = factory.newDocumentBuilder();
            this.m_builder.setEntityResolver(this);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void importConfig(WriteAccessConfiguration config, String fileName, int importMode) throws ConfigurationException {
        this.m_rootConfig = config;
        this.m_rootConfig.getConfigurationHandler().registerTransactionListener(this);
        this.m_transactionId = this.m_rootConfig.getConfigurationHandler().getTransactionId();
        try {
            this.m_zipFile = new ZipFile(fileName);
            ZipEntry contextDoc = this.m_zipFile.getEntry("contents.xml");
            if (contextDoc == null) {
                String message = "File contents.xml not found in import archive.";
                throw new ConfigurationException("kernel_1532", new Object[]{message});
            }
            InputStream contextDocIn = this.m_zipFile.getInputStream(contextDoc);
            this.m_zipInputStreams.add(contextDocIn);
            Document doc = this.m_builder.parse(contextDocIn);
            Element configTag = doc.getDocumentElement();
            String configName = configTag.getAttribute("name");
            int configType = Integer.parseInt(configTag.getAttribute("type"));
            if (importMode == 0) {
                config = (WriteAccessConfiguration)config.createSubConfiguration(configName, configType);
            } else if (configType == 1) {
                String message = "The import-file contains a PropertySheet and must be imported with importMode IMPORT_AS_SUBCONFIGURATION.";
                throw new ConfigurationException("kernel_1532", new Object[]{message});
            }
            Map subConfigs = this.processDoc(doc, config, this.m_folderPath);
            Iterator iter = subConfigs.keySet().iterator();
            while (iter.hasNext()) {
                String subPath = (String)iter.next();
                this.importInternal((WriteAccessConfiguration)subConfigs.get(subPath), subPath);
            }
        }
        catch (SAXException sax) {
            throw new ConfigurationException(sax);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private void importInternal(WriteAccessConfiguration config, String path) throws ConfigurationException {
        try {
            String contextDocPath = null;
            contextDocPath = path.equals("") ? "contents.xml" : path + "/" + "contents.xml";
            ZipEntry contextDoc = this.m_zipFile.getEntry(contextDocPath);
            if (contextDoc == null) {
                String message = "File " + contextDocPath + " not found in import archive.";
                throw new ConfigurationException("kernel_1532", new Object[]{message});
            }
            InputStream contextDocIn = this.m_zipFile.getInputStream(contextDoc);
            this.m_zipInputStreams.add(contextDocIn);
            Document doc = this.m_builder.parse(contextDocIn);
            Map subConfigs = this.processDoc(doc, config, path);
            Iterator iter = subConfigs.keySet().iterator();
            while (iter.hasNext()) {
                String subPath = (String)iter.next();
                this.importInternal((WriteAccessConfiguration)subConfigs.get(subPath), path + "/" + subPath);
            }
        }
        catch (SAXException sax) {
            throw new ConfigurationException(sax);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private Map processDoc(Document doc, WriteAccessConfiguration config, String path) throws ConfigurationException {
        try {
            String message;
            String mapName;
            Element mapNameTag;
            HashMap<String, Configuration> subConfigMap = new HashMap<String, Configuration>();
            NodeList subConfigs = doc.getElementsByTagName("sub-configuration");
            NodeList entries = doc.getElementsByTagName("config-entry");
            NodeList files = doc.getElementsByTagName("file-entry");
            this.m_byteValues = null;
            int i = 0;
            while (i < subConfigs.getLength()) {
                Element subConfigTag = (Element)subConfigs.item(i);
                String name = subConfigTag.getAttribute("name");
                int type = Integer.parseInt(subConfigTag.getAttribute("type"));
                int cacheMode = Integer.parseInt(subConfigTag.getAttribute("cachemode"));
                mapNameTag = (Element)subConfigTag.getElementsByTagName("map-name").item(0);
                mapName = mapNameTag.getFirstChild().getNodeValue();
                Configuration subConfig = config.createSubConfiguration(name, type);
                subConfig.setCacheMode(cacheMode);
                subConfigMap.put(mapName, subConfig);
                ++i;
            }
            int i2 = 0;
            while (i2 < entries.getLength()) {
                Element entryTag = (Element)entries.item(i2);
                String name = entryTag.getAttribute("name");
                String typeString = entryTag.getAttribute("type");
                int type = ValueEntry.getTypeForTypeString(typeString);
                Object value = null;
                if (type == 50 || type == 60) {
                    Element mapNameTag2;
                    String mapName2;
                    if (this.m_byteValues == null) {
                        String byteValuePath = null;
                        byteValuePath = path.equals("") ? "bytevalues" : path + "/" + "bytevalues";
                        ZipEntry byteValueEntry = this.m_zipFile.getEntry(byteValuePath);
                        if (byteValueEntry == null) {
                            message = "File " + byteValuePath + " not found in import archive.";
                            throw new ConfigurationException("kernel_1532", new Object[]{message});
                        }
                        InputStream zipIn = this.m_zipFile.getInputStream(byteValueEntry);
                        this.m_zipInputStreams.add(zipIn);
                        ObjectInputStream in = new ObjectInputStream(zipIn);
                        this.m_byteValues = (Map)in.readObject();
                        in.close();
                    }
                    if ((value = (Object)this.m_byteValues.get(mapName2 = (mapNameTag2 = (Element)entryTag.getElementsByTagName("map-name").item(0)).getFirstChild().getNodeValue())) == null) {
                        message = "Invalid map-name for configuration/entry: " + config.getPath() + "/" + name;
                        throw new ConfigurationException("kernel_1532", new Object[]{message});
                    }
                } else {
                    String message2;
                    Element valueTag = (Element)entryTag.getElementsByTagName("value").item(0);
                    Node valueData = valueTag.getFirstChild();
                    String valueString = null;
                    if (valueData == null) {
                        message2 = "Null-value for configuration/entry: " + config.getPath() + "/" + name;
                        throw new ConfigurationException("kernel_1532", new Object[]{message2});
                    }
                    valueString = valueData.getNodeValue();
                    valueString = valueString.trim();
                    switch (type) {
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: {
                            value = new Long(valueString);
                            break;
                        }
                        case 25: {
                            value = new Boolean(valueString) != false ? new Long(1L) : new Long(0L);
                            break;
                        }
                        case 30: {
                            value = new Double(valueString);
                            break;
                        }
                        case 40: {
                            if (valueString.length() < 2 || valueString.charAt(0) != '\"' || valueString.charAt(valueString.length() - 1) != '\"') {
                                message2 = "Configuration/entry does not start and end with '\"': " + config.getPath() + "/" + name;
                                throw new ConfigurationException("kernel_1532", new Object[]{message2});
                            }
                            value = valueString.substring(1, valueString.length() - 1);
                        }
                    }
                }
                ValueEntry entry = ValueEntry.createValueEntry(name, value, type);
                config.addValueEntry(entry);
                ++i2;
            }
            int i3 = 0;
            while (i3 < files.getLength()) {
                Element fileTag = (Element)files.item(i3);
                String name = fileTag.getAttribute("name");
                mapNameTag = (Element)fileTag.getElementsByTagName("map-name").item(0);
                mapName = mapNameTag.getFirstChild().getNodeValue();
                String filePath = null;
                filePath = path.equals("") ? mapName : path + "/" + mapName;
                ZipEntry fileEntry = this.m_zipFile.getEntry(filePath);
                if (fileEntry == null) {
                    message = "File " + filePath + " not found in import archive.";
                    throw new ConfigurationException("kernel_1532", new Object[]{message});
                }
                InputStream fileIn = this.m_zipFile.getInputStream(fileEntry);
                this.m_zipInputStreams.add(fileIn);
                config.addFileAsStreamWithLength(name, fileIn, (int)fileEntry.getSize());
                ++i3;
            }
            return subConfigMap;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream in = this.getClass().getResourceAsStream(systemId);
        InputSource src = new InputSource(in);
        src.setSystemId(systemId);
        return src;
    }

    public void transactionFinished(String transactionId) {
        if (this.m_transactionId.equals(transactionId)) {
            this.m_rootConfig.getConfigurationHandler().unregisterTransactionListener(this);
            Iterator iter = ((AbstractList)this.m_zipInputStreams).iterator();
            while (iter.hasNext()) {
                InputStream in = (InputStream)iter.next();
                try {
                    in.close();
                }
                catch (Exception e) {
                    Environment.getInstance().getLogging().logThrowable("Error while closing ZipInputStreams after import", e);
                }
            }
            try {
                this.m_zipFile.close();
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable("Error while closing ZipFile after import", e);
            }
        }
    }
}

