/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.transfer;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.transfer.ConfigInputSource;
import com.sap.engine.core.configuration.impl.utilities.transfer.ConfigParser;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.jaxp.TransformerImpl;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.util.SAXToDocHandler;
import com.sap.engine.lib.xsl.xslt.output.DocHandlerSerializer;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ConfigExporter {
    public static final String DTD_FILE_NAME = "configExportFormat.dtd";
    public static final String CONTENT_FILE_NAME = "contents.xml";
    private ConfigParser m_parser = new ConfigParser();
    private DocHandlerSerializer m_serializer = new DocHandlerSerializer();
    private ZipOutputStream m_zipOut;

    public ConfigExporter() throws ConfigurationException {
        Properties props = TransformerImpl.DEFAULT_OUTPUT_PROPERTIES;
        props.setProperty("indent", "yes");
        props.setProperty("doctype-system", DTD_FILE_NAME);
        this.m_serializer.setOutputProperties(props);
        SAXToDocHandler saxOut = new SAXToDocHandler((DocHandler)this.m_serializer);
        this.m_parser.setContentHandler((ContentHandler)saxOut);
        try {
            this.m_parser.setProperty("http://xml.org/sax/properties/lexical-handler", saxOut);
        }
        catch (SAXException sx) {
            throw new ConfigurationException(sx);
        }
    }

    /*
     * Loose catch block
     */
    public void export(Configuration config, String destFilePath) throws ConfigurationException {
        block8: {
            this.m_zipOut = new ZipOutputStream(new FileOutputStream(destFilePath));
            this.exportInternal(config, "");
            ((FilterOutputStream)this.m_zipOut).flush();
            Object var6_3 = null;
            try {
                this.m_zipOut.close();
            }
            catch (IOException e) {
                Environment.getInstance().getLogging().logThrowable("Error while closing ZipOutputStream after export", e);
            }
            break block8;
            {
                catch (ConfigurationException ce) {
                    throw ce;
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                try {
                    this.m_zipOut.close();
                }
                catch (IOException e) {
                    Environment.getInstance().getLogging().logThrowable("Error while closing ZipOutputStream after export", e);
                }
                throw throwable;
            }
        }
    }

    private void exportInternal(Configuration config, String destFilePath) throws ConfigurationException {
        try {
            ConfigInputSource iSource = new ConfigInputSource(config, destFilePath, this.m_zipOut);
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            this.m_serializer.setOutputStream((OutputStream)content);
            this.m_parser.parse(iSource);
            this.m_zipOut.putNextEntry(new ZipEntry(destFilePath + CONTENT_FILE_NAME));
            content.writeTo(this.m_zipOut);
            ((FilterOutputStream)this.m_zipOut).flush();
            this.m_zipOut.closeEntry();
            content.close();
            HashMap lastSubConfigs = this.m_parser.getLastSubConfigMap();
            if (lastSubConfigs != null) {
                Iterator iter = lastSubConfigs.keySet().iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    Configuration subConfig = config.getSubConfiguration(name);
                    String subFilePath = destFilePath + lastSubConfigs.get(name) + "/";
                    this.exportInternal(subConfig, subFilePath);
                }
            }
        }
        catch (SAXException sax) {
            Exception nested = sax.getException();
            if (nested instanceof ConfigurationException) {
                throw (ConfigurationException)((Object)nested);
            }
            throw new ConfigurationException(sax);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

