/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.transfer;

import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.WriteAccessConfiguration;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigDefaultHandler
extends DefaultHandler {
    private WriteAccessConfiguration m_config;
    private String m_path;
    private HashMap m_subConfigs = new HashMap();
    private Map m_byteValues;
    private Vector m_stack = new Vector();
    private String m_collectChars;

    public void init(WriteAccessConfiguration config, String path) throws ConfigurationException {
        this.m_config = config;
        this.m_path = path;
        this.m_subConfigs.clear();
        this.m_collectChars = "";
        this.m_byteValues = null;
    }

    public void characters(char[] chars, int offset, int count) throws SAXException {
        if (this.m_stack.size() < 2) {
            return;
        }
        Element lastElem = (Element)this.m_stack.lastElement();
        if (lastElem.m_elemType.equals("map-name") || lastElem.m_elemType.equals("value")) {
            this.m_collectChars = this.m_collectChars + String.valueOf(chars, offset, count);
        }
    }

    public void endDocument() throws SAXException {
        if (!this.m_stack.isEmpty()) {
            throw new SAXException("Inconsistent Document.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.m_stack.size() <= 0) throw new SAXException("Error in endElement: " + qName);
            Element lastElem = (Element)this.m_stack.lastElement();
            if (!lastElem.m_elemType.equals(qName)) {
                throw new SAXException("Error in endElement: " + qName);
            }
            if (this.m_stack.size() > 1) {
                Element secLastElem = (Element)this.m_stack.get(this.m_stack.size() - 2);
                if (lastElem.m_elemType.equals("map-name")) {
                    Attributes attr = secLastElem.m_attr;
                    if (secLastElem.m_elemType.equals("sub-configuration")) {
                        String dirName = this.m_collectChars;
                        String name = attr.getValue("name");
                        int type = Integer.parseInt(attr.getValue("type"));
                        File testFile = new File(this.m_path + File.separator + dirName);
                        if (!testFile.exists()) {
                            throw new SAXException("Invalid map-name for subconfiguration: " + name);
                        }
                        int cacheMode = Integer.parseInt(attr.getValue("cachemode"));
                        Configuration subConfig = this.m_config.createSubConfiguration(name, type);
                        subConfig.setCacheMode(cacheMode);
                        this.m_subConfigs.put(dirName, subConfig);
                    } else if (secLastElem.m_elemType.equals("config-entry")) {
                        if (this.m_byteValues == null) {
                            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.m_path + File.separator + "bytevalues"));
                            this.m_byteValues = (Map)in.readObject();
                            in.close();
                        }
                        String mapName = this.m_collectChars;
                        Object value = this.m_byteValues.get(mapName);
                        String name = attr.getValue("name");
                        int type = ValueEntry.getTypeForTypeString(attr.getValue("type"));
                        ValueEntry entry = ValueEntry.createValueEntry(name, value, type);
                        this.m_config.addValueEntry(entry);
                    } else {
                        if (!secLastElem.m_elemType.equals("file-entry")) throw new SAXException("Illegal element sequence.");
                        String name = attr.getValue("name");
                        String fileName = this.m_collectChars;
                        File file = new File(this.m_path + File.separator + fileName);
                        if (!file.exists()) {
                            throw new SAXException("Invalid map-name for file: " + name);
                        }
                        this.m_config.addFileEntryByKey(name, file);
                    }
                } else if (lastElem.m_elemType.equals("value")) {
                    if (!secLastElem.m_elemType.equals("config-entry")) throw new SAXException("Illegal element sequence.");
                    Attributes attr = secLastElem.m_attr;
                    Object value = null;
                    String valueString = this.m_collectChars;
                    String name = attr.getValue("name");
                    int type = ValueEntry.getTypeForTypeString(attr.getValue("type"));
                    switch (type) {
                        case 20: 
                        case 21: 
                        case 22: {
                            value = new Long(valueString);
                            break;
                        }
                        case 25: {
                            value = new Boolean(valueString) != false ? new Long(1L) : new Long(0L);
                            break;
                        }
                        case 30: {
                            value = new Double(valueString);
                            break;
                        }
                        case 40: {
                            value = valueString;
                        }
                    }
                    ValueEntry entry = ValueEntry.createValueEntry(name, value, type);
                    this.m_config.addValueEntry(entry);
                }
            }
            this.m_stack.remove(this.m_stack.size() - 1);
            this.m_collectChars = "";
            return;
        }
        catch (SAXException sax) {
            throw sax;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public void startDocument() throws SAXException {
        this.m_stack.clear();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("configuration") || qName.equals("sub-configuration") || qName.equals("file-entry") || qName.equals("config-entry")) {
            this.m_stack.add(new Element(qName, atts));
        } else {
            this.m_stack.add(new Element(qName, null));
        }
    }

    public Map getLastSubConfigs() {
        return (Map)this.m_subConfigs.clone();
    }

    class Element {
        public String m_elemType;
        public Attributes m_attr;

        public Element(String elemType, Attributes attr) {
            this.m_elemType = elemType;
            if (attr != null) {
                this.m_attr = new AttributesImpl(attr);
            }
        }
    }
}

