/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.transfer;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.core.configuration.impl.ConfigurationImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.exception.BaseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class BatchTransfer {
    public static int MODE_IMPORT = 1;
    public static int MODE_EXPORT = 2;
    ConfigurationHandler m_configHandler;
    HashMap m_configsToOpen;
    boolean m_overwrite = false;

    public BatchTransfer(ConfigurationHandlerFactory factory) throws ConfigurationException {
        this.m_configHandler = factory.getConfigurationHandler();
        this.m_configsToOpen = new HashMap();
    }

    protected void registerConfigToOpen(ConfigurationPath path) {
        ConfigurationPath existing = this.getExistingConfigPath(path);
        if (existing != null) {
            if (path.isArgumentSubTree(existing)) {
                this.m_configsToOpen.remove(existing);
                this.m_configsToOpen.put(path, null);
            }
        } else {
            this.m_configsToOpen.put(path, null);
        }
    }

    protected ConfigurationPath getExistingConfigPath(ConfigurationPath pathToOpen) {
        Iterator iterator = this.m_configsToOpen.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigurationPath openPath = (ConfigurationPath)iterator.next();
            if (!openPath.isArgumentSubTree(pathToOpen) && !pathToOpen.isArgumentSubTree(openPath)) continue;
            return openPath;
        }
        return null;
    }

    protected Configuration getOpenConfig(ConfigurationPath pathToOpen) {
        Iterator iterator = this.m_configsToOpen.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ConfigurationPath openPath = (ConfigurationPath)entry.getKey();
            if (!openPath.isArgumentSubTree(pathToOpen) && !pathToOpen.isArgumentSubTree(openPath)) continue;
            return (Configuration)entry.getValue();
        }
        return null;
    }

    protected void initializeConfigurations(int transferMode, int openMode) throws ConfigurationException {
        Iterator it = this.m_configsToOpen.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            entry.setValue(this.getConfigurationObjectForInit((ConfigurationPath)entry.getKey(), transferMode, openMode));
        }
    }

    protected Configuration getConfigurationObjectForInit(ConfigurationPath configPath, int transferMode, int openMode) throws ConfigurationException {
        if (transferMode == MODE_EXPORT) {
            return this.m_configHandler.openConfiguration(configPath.getPathString(), openMode);
        }
        Configuration result = null;
        try {
            result = this.m_configHandler.openConfiguration(configPath.getPathString(), 1);
            return result;
        }
        catch (NameNotFoundException e) {
            if (configPath.getLevels() > 1) {
                throw e;
            }
            return this.m_configHandler.createRootConfiguration(configPath.getPathString());
        }
    }

    public void batchImport(Properties p) throws ConfigurationException {
        this.batchTransfer(p, -1, MODE_IMPORT);
    }

    public void batchExport(Properties p, int openMode) throws ConfigurationException {
        this.batchTransfer(p, openMode, MODE_EXPORT);
    }

    private void batchTransfer(Properties p, int openMode, int transferMode) throws ConfigurationException {
        try {
            try {
                this.m_overwrite = false;
                String overwriteStr = p.getProperty("%OVERWRITE");
                if (overwriteStr != null && overwriteStr.trim().equalsIgnoreCase("true")) {
                    this.m_overwrite = true;
                }
                Iterator it = ((Hashtable)p).entrySet().iterator();
                Vector<BatchTransferElement> allElements = new Vector<BatchTransferElement>();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (((String)entry.getKey()).equalsIgnoreCase("%OVERWRITE")) continue;
                    allElements.addElement(new BatchTransferElement((String)entry.getKey(), (String)entry.getValue(), openMode, transferMode));
                }
                this.initializeConfigurations(transferMode, openMode);
                it = ((AbstractList)allElements).iterator();
                while (it.hasNext()) {
                    ((BatchTransferElement)((Object)it.next())).transfer();
                }
                this.m_configHandler.commit();
            }
            catch (ConfigurationException e) {
                this.m_configHandler.rollback();
                throw e;
            }
            Object var9_9 = null;
            this.m_configHandler.closeAllConfigurations();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.m_configHandler.closeAllConfigurations();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            BatchTransfer.cmdLineError();
        }
        Properties batchprops = null;
        Properties cfgMgrprops = null;
        Object cmd = null;
        try {
            FileInputStream cfgMgrFile = new FileInputStream(args[0]);
            cfgMgrprops = new Properties();
            cfgMgrprops.load(cfgMgrFile);
            cfgMgrFile.close();
            FileInputStream propsfile = new FileInputStream(args[1]);
            batchprops = new Properties();
            batchprops.load(propsfile);
            propsfile.close();
            if (!args[2].equalsIgnoreCase("export") && !args[2].equalsIgnoreCase("import")) {
                throw new Exception("invalid command");
            }
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().logThrowable(e);
            System.out.println(e.getMessage());
            BatchTransfer.cmdLineError();
        }
        ConfigurationManagerBootstrapImpl factory = null;
        DotPainter dotPainter = new DotPainter();
        try {
            factory = new ConfigurationManagerBootstrapImpl(cfgMgrprops);
            BatchTransfer transfer = new BatchTransfer(factory);
            if (args[2].equalsIgnoreCase("export")) {
                System.out.println("Exporting");
                new Thread(dotPainter).start();
                transfer.batchExport(batchprops, 1);
            }
            if (args[2].equalsIgnoreCase("import")) {
                System.out.println("Importing");
                new Thread(dotPainter).start();
                transfer.batchImport(batchprops);
            }
            dotPainter.stop();
            factory.shutdown();
            System.out.println("done");
        }
        catch (ConfigurationException e) {
            Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e));
            System.out.println("BatchTransfer failed");
            System.out.println("Reason: " + BatchTransfer.getMessage((Throwable)((Object)e)));
            dotPainter.stop();
            if (factory != null) {
                factory.shutdown();
            }
            System.exit(-1);
        }
    }

    public static void cmdLineError() {
        System.out.println("Parameters are:\n    <config manager properties path> path to config manager property file\n    <batch transfer properties path> path to batch transfer property file\n    <command>         export|import");
        System.exit(-1);
    }

    private static String getMessage(Throwable e) {
        if (e == null) {
            return "";
        }
        if (!e.getMessage().equals("")) {
            return e.getMessage();
        }
        if (!(e instanceof BaseException)) {
            return "";
        }
        return BatchTransfer.getMessage(((BaseException)e).getCause());
    }

    public static class DotPainter
    implements Runnable {
        boolean stop = false;

        public synchronized void run() {
            while (!this.stop) {
                try {
                    this.wait(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stop) continue;
                System.out.print(".");
            }
        }

        public synchronized void stop() {
            this.stop = true;
        }
    }

    private class BatchTransferElement {
        private Configuration m_configObj;
        private String m_filePath;
        private ConfigurationPath m_cfgPath;
        private int m_openMode;
        private int m_transferMode;

        public BatchTransferElement(String cfgPath, String filePath, int openMode, int transferMode) throws ConfigurationException {
            try {
                this.m_filePath = filePath;
                this.m_cfgPath = ConfigurationPath.getConfigurationPath(cfgPath);
                this.m_openMode = openMode;
                this.m_transferMode = transferMode;
                File f = new File(filePath);
                if (transferMode == MODE_IMPORT && !f.canRead()) {
                    throw new IOException("Can not read " + filePath);
                }
                if (transferMode == MODE_EXPORT) {
                    if (f.exists() && !f.canWrite()) {
                        throw new IOException("Can not write " + filePath);
                    }
                    if (!f.exists()) {
                        new FileOutputStream(filePath).close();
                    }
                }
                this.prepareConfiguration();
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
        }

        void prepareConfiguration() throws ConfigurationException {
            if (this.m_transferMode == MODE_EXPORT) {
                BatchTransfer.this.registerConfigToOpen(this.m_cfgPath);
            } else {
                boolean success = false;
                ConfigurationPath curPath = this.m_cfgPath;
                Configuration result = null;
                while (!success) {
                    try {
                        if (curPath != ConfigurationPath.ROOT_CONFIG_PATH) {
                            result = BatchTransfer.this.m_configHandler.openConfiguration(curPath.getPathString(), 1);
                            BatchTransfer.this.registerConfigToOpen(curPath);
                            result.close();
                        } else {
                            ConfigurationPath rootPath = this.m_cfgPath.getRootConfigurationPath();
                            BatchTransfer.this.registerConfigToOpen(rootPath);
                        }
                        success = true;
                    }
                    catch (NameNotFoundException e) {
                        curPath = curPath.getParrentPath();
                    }
                }
            }
        }

        Configuration getConfigurationForTransfer() throws ConfigurationException {
            if (this.m_transferMode == MODE_EXPORT) {
                ConfigurationImpl result = (ConfigurationImpl)BatchTransfer.this.getOpenConfig(this.m_cfgPath);
                if (!result.getPathWrapper().equals(this.m_cfgPath)) {
                    result = (ConfigurationImpl)result.getSubConfiguration(result.getPathWrapper().getRelPathForSubPath(this.m_cfgPath));
                }
                return result;
            }
            ConfigurationImpl result = (ConfigurationImpl)BatchTransfer.this.getOpenConfig(this.m_cfgPath);
            if (!result.getPathWrapper().equals(this.m_cfgPath)) {
                result = (ConfigurationImpl)result.createSubConfigurationHierachy(result.getPathWrapper().getRelPathForSubPath(this.m_cfgPath));
            }
            return result;
        }

        public void transfer() throws ConfigurationException {
            this.m_configObj = this.getConfigurationForTransfer();
            if (this.m_transferMode == MODE_EXPORT) {
                this.m_configObj.export(this.m_filePath);
            } else if (this.m_transferMode == MODE_IMPORT) {
                if (BatchTransfer.this.m_overwrite) {
                    this.m_configObj.deleteAllFiles();
                    this.m_configObj.deleteAllSubConfigurations();
                    this.m_configObj.deleteAllConfigEntries();
                }
                this.m_configObj.importContent(this.m_filePath);
            } else {
                throw new ConfigurationException("kernel_1507", new Object[]{"BatchTransfer"});
            }
        }
    }
}

