/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.dbtransfertool;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.Export;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.Import;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class Transfer {
    private static final String COMMAND_EXPORT = "export";
    private static final String COMMAND_IMPORT = "import";
    private static final String COMMAND_TRANSFER = "transfer";
    private static final String DEFAULT_PROPS = "dbTransferTool.properties";
    private static final String TRANSFER_EXPORT_FILE = "tmpExp.zip";
    private static final String DEFAULT_DRIVER = "com.sap.sql.jdbc.direct.DirectDriver";
    static final String OBJECT_FILE_NAME = "objects";
    static final String TEMP_FILE_NAME = "temp";
    static final String RELATIVE_TEMP_FOLDER = "temp";
    static String TRANSFER_FILE;
    static String TEMP_FOLDER;
    private boolean m_isOk = true;
    private String m_command = "";
    private String m_exportFileName = "";
    private Connection m_con_exp;
    private Connection m_con_imp;

    public Transfer(String[] args) {
        this.checkArguments(args);
    }

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        Transfer transfer = new Transfer(args);
        if (transfer.m_isOk) {
            System.out.println(transfer.m_command + " running ...");
            transfer.process();
            if (transfer.m_isOk) {
                System.out.println(transfer.m_command + " successfully finished!");
            } else {
                System.out.println(transfer.m_command + " failed!");
            }
            double executionTime = (System.currentTimeMillis() - startTime) / 1000L;
            System.out.println(transfer.m_command + " execution time = " + executionTime + " seconds");
        }
    }

    private void checkArguments(String[] args) {
        System.out.println("Parsing arguments");
        this.m_command = args[0];
        if (!(this.m_command.equals(COMMAND_EXPORT) || this.m_command.equals(COMMAND_IMPORT) || this.m_command.equals(COMMAND_TRANSFER))) {
            System.out.println("Command " + this.m_command + " not valid.");
            this.m_isOk = false;
            return;
        }
        String propsFileName = null;
        propsFileName = args.length > 1 ? args[1] : "." + System.getProperty("file.separator") + DEFAULT_PROPS;
        File configFile = new File(propsFileName);
        if (!configFile.exists()) {
            System.out.println("Configuration file " + propsFileName + " not found.");
            this.m_isOk = false;
            return;
        }
        Properties transferProperties = null;
        try {
            FileInputStream fis = new FileInputStream(propsFileName);
            transferProperties = new Properties();
            transferProperties.load(fis);
        }
        catch (Throwable e) {
            System.out.println("Problem during access of configuration file.");
            e.printStackTrace();
            Environment.getInstance().getLogging().logThrowable("Problem during access of configuration file.", e, (byte)4);
            this.m_isOk = false;
            return;
        }
        String srcConfigProperties = transferProperties.getProperty("srcConfigProperties");
        String destConfigProperties = transferProperties.getProperty("destConfigProperties");
        String exportFileName = transferProperties.getProperty("exportFileName");
        if (srcConfigProperties == null) {
            System.out.println("Properties-File " + propsFileName + ": property srcConfigProperties not found.");
            this.m_isOk = false;
            return;
        }
        if (destConfigProperties == null) {
            System.out.println("Properties-File " + propsFileName + ": property destConfigProperties not found.");
            this.m_isOk = false;
            return;
        }
        if (exportFileName == null) {
            System.out.println("Properties-File " + propsFileName + ": property exportFileName not found.");
            this.m_isOk = false;
            return;
        }
        String outputFolder = null;
        if (!this.m_command.equals(COMMAND_TRANSFER)) {
            File exportFile = new File(exportFileName);
            if (exportFile.exists() && this.m_command.equals(COMMAND_EXPORT)) {
                System.out.println("Export file " + exportFileName + " already exists. Please remove or rename.");
                this.m_isOk = false;
                return;
            }
            if (!exportFile.exists() && this.m_command.equals(COMMAND_IMPORT)) {
                System.out.println("Export file " + exportFileName + " not found.");
                this.m_isOk = false;
                return;
            }
            outputFolder = exportFile.getParent();
            outputFolder = outputFolder == null ? "" : outputFolder + System.getProperty("file.separator");
        } else {
            exportFileName = TRANSFER_EXPORT_FILE;
            outputFolder = "." + System.getProperty("file.separator");
        }
        this.m_exportFileName = exportFileName;
        TEMP_FOLDER = outputFolder + "temp" + System.getProperty("file.separator");
        if (this.m_command.equals(COMMAND_EXPORT) || this.m_command.equals(COMMAND_TRANSFER)) {
            this.m_con_exp = this.getConnectionFromProps(srcConfigProperties);
        }
        if (this.m_command.equals(COMMAND_IMPORT) || this.m_command.equals(COMMAND_TRANSFER)) {
            this.m_con_imp = this.getConnectionFromProps(destConfigProperties);
        }
        if (!this.m_isOk) {
            return;
        }
        System.out.println("Arguments o.k.");
    }

    private Connection getConnectionFromProps(String configFileName) {
        Properties props = null;
        try {
            FileInputStream fis = new FileInputStream(configFileName);
            props = new Properties();
            props.load(fis);
        }
        catch (Throwable e) {
            System.out.println("Problem during access of ConfigurationManager properties file " + configFileName);
            e.printStackTrace();
            Environment.getInstance().getLogging().logThrowable("Problem during access of ConfigurationManager properties file " + configFileName, e, (byte)4);
            this.m_isOk = false;
            return null;
        }
        String driver = props.getProperty("rdbms.driver");
        String url = props.getProperty("rdbms.url");
        String user = props.getProperty("rdbms.user");
        String password = props.getProperty("rdbms.password");
        if (driver == null) {
            System.out.println("Configuration-File " + configFileName + ": property rdbms.driver not found. Use default driver " + DEFAULT_DRIVER);
            driver = DEFAULT_DRIVER;
        }
        if (url == null) {
            System.out.println("Configuration-File " + configFileName + ": property rdbms.url not found.");
            this.m_isOk = false;
            return null;
        }
        if (user == null) {
            System.out.println("Configuration-File " + configFileName + ": property rdbms.user not found.");
            this.m_isOk = false;
            return null;
        }
        if (password == null) {
            System.out.println("Configuration-File " + configFileName + ": property rdbms.password not found.");
            this.m_isOk = false;
            return null;
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            Environment.getInstance().getLogging().logThrowable("Configuration file " + configFileName + ": driver class " + driver + "could not be found.", e, (byte)4);
            System.out.println("Configuration file " + configFileName + ": driver class " + driver + "could not be found.");
            this.m_isOk = false;
            return null;
        }
        Connection con = null;
        try {
            con = DriverManager.getConnection(url, user, password);
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            System.out.println("Could not open JDBC connection based on (url, user, password)=(" + url + ", " + user + ", " + password + ")");
            Environment.getInstance().getLogging().logThrowable("Could not open JDBC connection based on (url, user, password)=(" + url + ", " + user + ", " + password + ")", e, (byte)4);
            e.printStackTrace();
            this.m_isOk = false;
        }
        return con;
    }

    private void process() {
        try {
            if (this.m_command.equals(COMMAND_EXPORT)) {
                this.exportData();
                this.m_con_exp.close();
            } else if (this.m_command.equals(COMMAND_IMPORT)) {
                this.importData();
                this.m_con_imp.close();
            } else if (this.m_command.equals(COMMAND_TRANSFER)) {
                this.exportData();
                this.importData();
                File f = new File(this.m_exportFileName);
                f.delete();
                this.m_con_imp.close();
            }
        }
        catch (Throwable t) {
            Environment.getInstance().getLogging().logThrowable(t);
            t.printStackTrace();
            this.m_isOk = false;
        }
    }

    private void exportData() throws Throwable {
        Export exporter = new Export(this.m_con_exp, this.m_exportFileName);
        exporter.process();
    }

    private void importData() throws Throwable {
        Import importer = new Import(this.m_con_imp, this.m_exportFileName);
        importer.process();
    }

    private String getCommand() {
        return this.m_command;
    }
}

