/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.dbtransfertool;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.Config;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.ConfigEntry;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.KeySequence;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Import {
    private static final String INSERT_CONFIG = "INSERT INTO J2EE_CONFIG (CID, PARENTCID, PATHPREFIX, CPATH, PATHHASH, CACHEMODE, CTYPE) VALUES (?,?,?,?,?,?,?)";
    private static final String INSERT_CONFIGENTRY = "INSERT INTO J2EE_CONFIGENTRY (CID, NAMEHASH, ISFILE, NAME, DTYPE, VBIGINT, VDOUBLE, VSTR, VBYTES, FBLOB) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_KEYSEQUENCE = "INSERT INTO J2EE_KEYSEQUENCE (SEQUENCE_ID, INC_VALUE) VALUES (?,?)";
    private static final int BATCH_SIZE = 1000;
    private Connection m_con;
    private ObjectInputStream m_importOis;
    private ZipFile m_importZipFile;
    private PreparedStatement m_insertConfigStmt;
    private PreparedStatement m_insertConfigEntryStmt;
    private PreparedStatement m_insertKeySequenceStmt;
    private Vector m_isSet;

    public Import(Connection argConnection, String importFileName) throws Throwable {
        this.m_importZipFile = new ZipFile(importFileName);
        ZipEntry objectFileEntry = this.m_importZipFile.getEntry("objects");
        if (objectFileEntry == null) {
            throw new Exception("Object file is missing in import file. Zip file is corrupted. Redo Export.");
        }
        InputStream importIs = this.m_importZipFile.getInputStream(objectFileEntry);
        this.m_importOis = new ObjectInputStream(importIs);
        this.m_con = argConnection;
        this.m_insertConfigStmt = this.m_con.prepareStatement(INSERT_CONFIG);
        this.m_insertConfigEntryStmt = this.m_con.prepareStatement(INSERT_CONFIGENTRY);
        this.m_insertKeySequenceStmt = this.m_con.prepareStatement(INSERT_KEYSEQUENCE);
    }

    public void process() throws Throwable {
        try {
            int configBatchSize = 0;
            int configEntryBatchSize = 0;
            boolean isOk = true;
            while (isOk) {
                try {
                    Object obj = this.m_importOis.readObject();
                    if (obj instanceof Config) {
                        this.loadConfig((Config)obj);
                        if (++configBatchSize <= 1000) continue;
                        this.m_insertConfigStmt.executeBatch();
                        continue;
                    }
                    if (obj instanceof ConfigEntry) {
                        this.loadConfigEntry((ConfigEntry)obj);
                        if (++configEntryBatchSize <= 1000) continue;
                        this.m_insertConfigEntryStmt.executeBatch();
                        continue;
                    }
                    if (!(obj instanceof KeySequence)) continue;
                    this.loadKeySequence((KeySequence)obj);
                }
                catch (EOFException e) {
                    isOk = false;
                }
            }
            this.m_insertConfigStmt.executeBatch();
            this.m_insertConfigEntryStmt.executeBatch();
            this.m_con.commit();
            Object var6_7 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.close();
            throw throwable;
        }
    }

    private void loadConfig(Config config) throws Throwable {
        this.m_insertConfigStmt.setLong(1, config.getCid());
        this.m_insertConfigStmt.setLong(2, config.getParentCid());
        this.m_insertConfigStmt.setString(3, config.getPathPrefix());
        this.m_insertConfigStmt.setString(4, config.getCpath());
        this.m_insertConfigStmt.setInt(5, config.getPathHash());
        this.m_insertConfigStmt.setInt(6, config.getCacheMode());
        this.m_insertConfigStmt.setInt(7, config.getCtype());
        this.m_insertConfigStmt.addBatch();
    }

    private void loadConfigEntry(ConfigEntry configEntry) throws Throwable {
        this.m_insertConfigEntryStmt.setLong(1, configEntry.getCid());
        this.m_insertConfigEntryStmt.setInt(2, configEntry.getNamehash());
        this.m_insertConfigEntryStmt.setInt(3, configEntry.getIsFile());
        this.m_insertConfigEntryStmt.setString(4, configEntry.getName());
        this.m_insertConfigEntryStmt.setInt(5, configEntry.getDtype());
        this.m_insertConfigEntryStmt.setLong(6, configEntry.getVbigint());
        this.m_insertConfigEntryStmt.setDouble(7, configEntry.getVdouble());
        this.m_insertConfigEntryStmt.setString(8, configEntry.getVstr());
        this.m_insertConfigEntryStmt.setBytes(9, configEntry.getVbytes());
        int fileCounter = configEntry.getFblobNo();
        if (fileCounter != 0) {
            ZipEntry blobEntry = this.m_importZipFile.getEntry("temp" + fileCounter);
            if (blobEntry == null) {
                throw new Exception("FBLOB file is missing in import file. Zip file is corrupted. Redo Export.");
            }
            InputStream blobIs = this.m_importZipFile.getInputStream(blobEntry);
            if (this.m_isSet == null) {
                this.m_isSet = new Vector();
            }
            this.m_isSet.add(blobIs);
            this.m_insertConfigEntryStmt.setBinaryStream(10, blobIs, (int)blobEntry.getSize());
        } else {
            this.m_insertConfigEntryStmt.setBinaryStream(10, (InputStream)null, 0);
        }
        this.m_insertConfigEntryStmt.addBatch();
    }

    private void loadKeySequence(KeySequence keySequence) throws Throwable {
        this.m_insertKeySequenceStmt.setInt(1, keySequence.getSequenceId());
        this.m_insertKeySequenceStmt.setLong(2, keySequence.getIncValue());
        this.m_insertKeySequenceStmt.execute();
    }

    private void close() {
        try {
            this.m_importOis.close();
            this.closeImportStreams();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Environment.getInstance().getLogging().logThrowable(t);
        }
    }

    private void closeImportStreams() throws Throwable {
        Enumeration enumeration = this.m_isSet.elements();
        while (enumeration.hasMoreElements()) {
            InputStream is = (InputStream)enumeration.nextElement();
            is.close();
        }
    }
}

