/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities.dbtransfertool;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.Config;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.ConfigEntry;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.KeySequence;
import com.sap.engine.core.configuration.impl.utilities.dbtransfertool.Transfer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Export {
    private static String SELECT_CONFIG = "SELECT CID, PARENTCID, PATHPREFIX, CPATH, PATHHASH, CACHEMODE, CTYPE FROM J2EE_CONFIG";
    private static String SELECT_CONFIGENTRY = "SELECT CID, NAMEHASH, ISFILE, NAME, DTYPE, VBIGINT, VDOUBLE, VSTR, VBYTES, FBLOB FROM J2EE_CONFIGENTRY";
    private static String SELECT_KEYSEQUENCE = "SELECT SEQUENCE_ID, INC_VALUE FROM J2EE_KEYSEQUENCE";
    private Connection m_con;
    private String m_exportFileName;
    private ObjectOutputStream m_exportOos;
    private ZipOutputStream m_exportZos;
    private int m_fileCounter = 0;
    private File m_tempFolder;

    public Export(Connection argConnection, String exportFileName) throws Throwable {
        this.m_exportFileName = exportFileName;
        this.m_tempFolder = new File(Transfer.TEMP_FOLDER);
        this.m_tempFolder.mkdir();
        FileOutputStream exportFos = new FileOutputStream(Transfer.TEMP_FOLDER + "objects");
        this.m_exportOos = new ObjectOutputStream(exportFos);
        if (!this.m_exportFileName.endsWith(".zip")) {
            this.m_exportFileName = this.m_exportFileName + ".zip";
        }
        FileOutputStream fos = new FileOutputStream(this.m_exportFileName);
        this.m_exportZos = new ZipOutputStream(fos);
        this.m_con = argConnection;
    }

    public void process() throws Throwable {
        try {
            this.unloadConfig();
            this.unloadConfigEntry();
            this.unloadKeySequence();
            Object var3_1 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.close();
            throw throwable;
        }
    }

    private void unloadConfig() throws Throwable {
        PreparedStatement selectStmt = this.m_con.prepareStatement(SELECT_CONFIG);
        ResultSet result = selectStmt.executeQuery();
        while (result.next()) {
            Config config = new Config();
            config.setCid(result.getLong(1));
            config.setParentCid(result.getLong(2));
            config.setPathPrefix(result.getString(3));
            config.setCpath(result.getString(4));
            config.setPathHash(result.getInt(5));
            config.setCacheMode(result.getInt(6));
            config.setCtype(result.getInt(7));
            this.m_exportOos.writeObject(config);
            this.m_exportOos.flush();
        }
    }

    private void unloadConfigEntry() throws Throwable {
        PreparedStatement selectStmt = this.m_con.prepareStatement(SELECT_CONFIGENTRY);
        ResultSet result = selectStmt.executeQuery();
        while (result.next()) {
            ConfigEntry configEntry = new ConfigEntry();
            configEntry.setCid(result.getLong(1));
            configEntry.setNamehash(result.getInt(2));
            configEntry.setIsFile(result.getInt(3));
            configEntry.setName(result.getString(4));
            configEntry.setDtype(result.getInt(5));
            configEntry.setVbigint(result.getLong(6));
            configEntry.setVdouble(result.getDouble(7));
            configEntry.setVstr(result.getString(8));
            configEntry.setVbytes(result.getBytes(9));
            InputStream fblob = result.getBinaryStream(10);
            if (fblob != null) {
                ++this.m_fileCounter;
                configEntry.setFblobNo(this.m_fileCounter);
                String tmpFileName = Transfer.TEMP_FOLDER + "temp" + this.m_fileCounter;
                ZipEntry entry = new ZipEntry("temp" + this.m_fileCounter);
                this.m_exportZos.putNextEntry(entry);
                boolean length = false;
                byte[] buf = new byte[2000];
                int received = 0;
                while ((received = fblob.read(buf)) != -1) {
                    this.m_exportZos.write(buf, 0, received);
                }
                ((FilterOutputStream)this.m_exportZos).flush();
            } else {
                configEntry.setFblobNo(0);
            }
            this.m_exportOos.writeObject(configEntry);
            this.m_exportOos.flush();
        }
    }

    private void unloadKeySequence() throws Throwable {
        PreparedStatement selectStmt = this.m_con.prepareStatement(SELECT_KEYSEQUENCE);
        ResultSet result = selectStmt.executeQuery();
        while (result.next()) {
            KeySequence keySequence = new KeySequence();
            keySequence.setSequenceId(result.getInt(1));
            keySequence.setIncValue(result.getLong(2));
            this.m_exportOos.writeObject(keySequence);
            this.m_exportOos.flush();
        }
    }

    private void close() {
        try {
            this.m_exportOos.close();
            this.zipObjectFile();
            this.removeTempFolder();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Environment.getInstance().getLogging().logThrowable(t);
        }
    }

    private void zipObjectFile() throws Throwable {
        ZipEntry entry = new ZipEntry("objects");
        this.m_exportZos.putNextEntry(entry);
        FileInputStream fis = new FileInputStream(Transfer.TEMP_FOLDER + "objects");
        byte[] buf = new byte[2000];
        int received = 0;
        while ((received = fis.read(buf)) != -1) {
            this.m_exportZos.write(buf, 0, received);
        }
        ((FilterOutputStream)this.m_exportZos).flush();
        fis.close();
        this.m_exportZos.close();
    }

    private void removeTempFolder() throws Throwable {
        File[] files = this.m_tempFolder.listFiles();
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
        this.m_tempFolder.delete();
    }
}

