/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Utils {
    public static final String lineWrap = System.getProperty("line.separator");

    public static String getStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        t.printStackTrace(wrapper);
        wrapper.flush();
        return writer.toString();
    }

    public static String getStackTraceWithoutFirstLine(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        t.printStackTrace(wrapper);
        wrapper.flush();
        String traceString = writer.toString();
        traceString = traceString.substring(traceString.indexOf(lineWrap) + lineWrap.length());
        return traceString;
    }

    public static String removeTrailingWhitespace(String str) {
        if (str == null) {
            return null;
        }
        boolean needToCut = false;
        int i = str.length() - 1;
        while (i > -1) {
            if (!Character.isWhitespace(str.charAt(i))) {
                if (needToCut) {
                    return str.substring(0, i + 1);
                }
                return str;
            }
            needToCut = true;
            --i;
        }
        return "";
    }

    public static boolean hasTrailingWhitespace(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        char ch = str.charAt(str.length() - 1);
        return Character.isWhitespace(ch);
    }
}

