/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;

public class SimpleSortedSet
implements SortedSet {
    private List m_list;
    private Comparator m_comp;

    public SimpleSortedSet() {
        this.m_list = new Vector();
        this.m_comp = null;
    }

    public SimpleSortedSet(Comparator comp) {
        this.m_list = new Vector();
        this.m_comp = comp;
    }

    private SimpleSortedSet(List list, Comparator comp) {
        this.m_list = list;
        this.m_comp = comp;
    }

    public boolean add(Object o) {
        return this.binaryInsert(o, this.m_list);
    }

    public boolean addAll(Collection c) {
        boolean result = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.add(iter.next())) continue;
            result = true;
        }
        return result;
    }

    public void clear() {
        this.m_list.clear();
    }

    public Object clone() {
        return new SimpleSortedSet(new Vector(this.m_list), this.m_comp);
    }

    public boolean contains(Object o) {
        return this.m_list.contains(o);
    }

    public Object get(int index) {
        return this.m_list.get(index);
    }

    public int indexOf(Object o) {
        int result = this.m_comp == null ? Collections.binarySearch(this.m_list, o) : Collections.binarySearch(this.m_list, o, this.m_comp);
        if (result < 0) {
            result = -(result + 1);
        }
        return result;
    }

    public void remove(int index) {
        this.m_list.remove(index);
    }

    public void removeRange(int startIndex, int endIndex) {
        int i = startIndex;
        while (i <= endIndex) {
            this.remove(i);
            ++i;
        }
    }

    public int size() {
        return this.m_list.size();
    }

    public Object[] toArray() {
        return this.m_list.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.m_list.toArray(array);
    }

    private boolean binaryInsert(Object o, List list) {
        int insertionPoint = this.m_comp == null ? -(Collections.binarySearch(list, o) + 1) : -(Collections.binarySearch(list, o, this.m_comp) + 1);
        if (insertionPoint < 0) {
            return false;
        }
        list.add(insertionPoint, o);
        return true;
    }

    public Comparator comparator() {
        return this.m_comp;
    }

    public Object first() {
        return this.m_list.get(0);
    }

    public SortedSet headSet(Object toElement) {
        return new SimpleSortedSet(this.m_list.subList(0, this.indexOf(toElement)), this.m_comp);
    }

    public Object last() {
        return this.m_list.get(this.m_list.size() - 1);
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        return new SimpleSortedSet(this.m_list.subList(this.indexOf(fromElement), this.indexOf(toElement)), this.m_comp);
    }

    public SortedSet tailSet(Object fromElement) {
        return new SimpleSortedSet(this.m_list.subList(this.indexOf(fromElement), this.m_list.size()), this.m_comp);
    }

    public boolean containsAll(Collection c) {
        return this.m_list.containsAll(c);
    }

    public boolean isEmpty() {
        return this.m_list.isEmpty();
    }

    public Iterator iterator() {
        return this.m_list.iterator();
    }

    public boolean remove(Object o) {
        return this.m_list.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.m_list.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.m_list.retainAll(c);
    }
}

